/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'dialog',
	{
		init : function( editor, pluginPath )
		{
		}
	});

CKEDITOR.DIALOG_RESIZE_NONE = 0;
CKEDITOR.DIALOG_RESIZE_RESIZE_WIDTH = 1;
CKEDITOR.DIALOG_RESIZE_RESIZE_HEIGHT = 2;
CKEDITOR.DIALOG_RESIZE_RESIZE_BOTH = 3;

CKEDITOR.dialog =
{
	add: function( name, callback )
	{
	},

	okButton : null,

	cancelButton : null,

	addUIElement: null,

	dialogDefinitions : {
		'testOnly' : function()
		{
			return {
				'title' : 'Test Dialog',
				'resizable' : CKEDITOR.DIALOG_RESIZE_NONE,
				'minWidth' : 500,
				'minHeight' : 400,
				'contents' : []
			};
		}
	}
};

(function()
{
	var defaultDialogDefinition = {
		'resizable' : CKEDITOR.DIALOG_RESIZE_NONE,
		'minWidth' : 600,
		'minHeight' : 400,
		'buttons' : [CKEDITOR.dialog.okButton, CKEDITOR.dialog.cancelButton],
		'onOk' : function(){alert('ok called');},
		'onCancel' : function(){alert('cancel caled');},
		'onLoad' : function(){alert('onload called');}
	};

	CKEDITOR.tools.extend( CKEDITOR.editor.prototype,
		{
			'openDialog' : function( dialogName )
			{
				if ( !( dialogName in CKEDITOR.dialog.dialogDefinitions) )
				{
					alert( 'The dialog "' + dialogName + '" is not defined.' );
					return false;
				}

				// Add the dialog to the top document.
				var dialogElement = this.theme.buildDialog( this ),
					doc = CKEDITOR.document;
				dialogElement.appendTo( doc.getBody() );

				var dialogDefinition = CKEDITOR.tools.extend( {}, defaultDialogDefinition,
					CKEDITOR.dialog.dialogDefinitions[dialogName]() );

				// Resize the dialog to the minimum size.
				this.theme.resizeDialog( this, dialogElement, dialogDefinition.minWidth, dialogDefinition.minHeight );

				return true;
			}
		});
})();
