/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.tool;

import javax.servlet.http.HttpServletRequest;

import net.fckeditor.handlers.ConnectorHandler;
import net.fckeditor.handlers.ResourceType;
import net.fckeditor.requestcycle.ThreadLocalData;

/**
 * Some static helper methods in conjunction with the servlet response.
 *
 * @version $Id: UtilsResponse.java 2407 2008-09-01 18:47:35Z th-schwarz $
 */
public class UtilsResponse {

	/**
	 * Constructs a URL from different parameters. This method is about to
	 * change in version 2.5. 
	 * TODO {@link ConnectorHandler#getUserFilesPath()} call has to be eliminated, because it could contains absolute paths in future ! ???
	 */
	public static String constructResponseUrl(ResourceType resourceType, String resourceTypePath, String urlPath) {
		HttpServletRequest request = ThreadLocalData.getServletRequest();
		StringBuffer sb = new StringBuffer();
		
		if ( ConnectorHandler.isFullUrl()) {
			String address = request.getRequestURL().toString();
			sb.append(address.substring(0, address.indexOf('/', 8)));
		}
		    	
		sb.append(ConnectorHandler.getUserFilesPath());
		sb.append(resourceTypePath);
		
		if (Utils.isNotEmpty(urlPath))
			sb.append(urlPath);
		
		return sb.toString();
	}

}
