/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.requestcycle;

import javax.servlet.http.HttpServletRequest;



/**
 * An interface which provides the authorization of server-side commands.<br />
 * The commands are:
 * <ul>
 * <li>{@link #isEnabledForFileBrowsing()}: Enables the user
 * to browse/select files.</li>
 * <li>{@link #isEnabledForFileUpload()}: Enables the user
 * to upload files.</li>
 * <li>{@link #isEnabledForFolderCreation()} Enables the user
 * to create folders.</li>
 * </ul>
 * <strong>If your implementation needs {@link HttpServletRequest} e.g. to get a
 * session variable, you can get it by calling {@link ThreadLocalData#getServletRequest()}.</strong>
 * 
 * @version $Id: UserAction.java 2413 2008-09-02 14:31:20Z th-schwarz $
 */
public interface UserAction {

	/**
	 * Authenticates/enables the current user for uploading files.<br />
	 * 
	 * @return <code>true</code> if user can upload to the server, or
	 *         <code>false</code>
	 */
	public boolean isEnabledForFileUpload();

	/**
	 * Authenticates/enables the current user for browsing files.<br />
	 * 
	 * @return <code>true</code> if user can browse the server, or
	 *         <code>false</code>
	 */
	public boolean isEnabledForFileBrowsing();
	

	/**
	 * Authenticates/enables the current user to create folders.<br />
	 * 
	 * @return <code>true</code> if user can create folders on the server, or
	 *         <code>false</code>
	 */
	public boolean isEnabledForFolderCreation();

}
