/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.connector;


import java.io.InputStream;

import javax.servlet.ServletContext;

import net.fckeditor.handlers.ResourceType;
import net.fckeditor.response.GetResponse;
import net.fckeditor.response.UploadResponse;

/**
 * Interface for all Connectors.<br>
 * Keep in mind that the {@link Dispatcher} verifies the request and redirects the relevant parameters
 * to the implementation of the connector and forwards the response of the Connector to {@link ConnectorServlet}.
 * That means, you don't need to check the basic parameters 'type' and 'currentFolder' against null.
 * <br>
 * <br>
 * TODO find a nice way to have #getFiles and #getFolder instead of #getFileAndFolders.
 * 
 * @version $Id: Connector.java 2421 2008-09-02 17:09:11Z th-schwarz $
 */
public interface Connector {
	
	/**
	 * Initializes the connector. This method will be called on the start of the webapp.
	 * 
	 * @param servletContext to get the real path for example.
	 */
	public void init(final ServletContext servletContext);
	
	public GetResponse getFolders(final ResourceType type, final String currentFolder);
	
	public GetResponse getFilesAndFolders(final ResourceType type, final String currentFolder);
	
	public GetResponse createFolder(final ResourceType type, final String currentFolder, final String newFolder);
	
	public UploadResponse fileUpload(final ResourceType type, final String currentFolder, final String fileName, final InputStream inputStream);
}
