/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'dialog',
	{
		init : function( editor, pluginPath )
		{
		}
	});

CKEDITOR.DIALOG_RESIZE_NONE = 0;
CKEDITOR.DIALOG_RESIZE_RESIZE_WIDTH = 1;
CKEDITOR.DIALOG_RESIZE_RESIZE_HEIGHT = 2;
CKEDITOR.DIALOG_RESIZE_RESIZE_BOTH = 3;

CKEDITOR.dialog =
{
	add: function( name, callback )
	{
	},

	okButton : null,

	cancelButton : null,

	addUIElement: null,

	dialogDefinitions : {
		testOnly : function()
		{
			return {
				title : 'Test Dialog',
				resizable : CKEDITOR.DIALOG_RESIZE_NONE,
				minWidth : 500,
				minHeight : 400,
				contents : [
					{
						id : 'tab1',
						label : 'First Tab',
						title : ''
					}
				]
			};
		}
	},

	storedDialogs : {},

	construct : function( editor, dialogName )
	{
		if ( arguments.length < 2 )
			return;

		// Load the dialog definition.
		var definition = CKEDITOR.dialog.dialogDefinitions[dialogName];
		if ( typeof( definition ) != 'function' )
		{
			alert( 'Error: The dialog "' + dialogName + '" is not defined.' );
			return;
		}
		definition = CKEDITOR.tools.extend( {}, CKEDITOR.dialog._.defaultDialogDefinition, definition() );
		if ( !( definition.title && definition.contents ) )
		{
			alert( 'Error: The dialog "' + dialogName + '" is missing its title or contents.' );
			return;
		}

		// Initialize some basic parameters.
		this._ = {
			editor : editor,
			element : editor.theme.buildDialog( editor ),
			name : dialogName,
			definition : definition,
			isShown : false,
			size : { width : 0, height : 0 }
		};

		// Initialize the parts map.
		var element = this._.element.getFirst();
		function getPart(elementIndices)
		{
			var e = element;
			for ( var i = 0 ; i < elementIndices.length ; i++ )
				e = e.getChild( elementIndices[i] );
			return e;
		}
		this._.parts = {
			'tl' : [0,0],
			't' : [0,1],
			'tr' : [0,2],
			'l' : [1,0],
			'c' : [1,1],
			'r' : [1,2],
			'bl' : [2,0],
			'b' : [2,1],
			'br' : [2,2],
			'title' : [1,1,0],
			'tabs' : [1,1,1],
			'contents' : [1,1,2],
			'buttons' : [1,1,3]
		};
		for ( var i in this._.parts )
			this._.parts[i] = getPart( this._.parts[i] );

		// Insert the title.
		( new CKEDITOR.dom.text( definition.title, CKEDITOR.document ) ).appendTo( this._.parts['title'] );
	}
};

CKEDITOR.dialog._ = {
	defaultDialogDefinition :
	{
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 600,
		minHeight : 400,
		buttons : [CKEDITOR.dialog.okButton, CKEDITOR.dialog.cancelButton],
		onOk : function(){alert('ok called');},
		onCancel : function(){alert('cancel caled');},
		onLoad : function(){alert('onload called');}
	}
}


CKEDITOR.dialog.construct.prototype = {
	resize : (function()
	{
		// Define the function for resizing dialog parts at load to speed up
		// the actual resize operation.
		var setSize = function( dialog, partName, width, height )
		{
			var element = partName ? dialog._.parts[partName] : dialog._.element.getFirst();
			element.setStyles( {
				width : Math.max( width || 0, 0 ) + 'px',
				height : Math.max( height || 0, 0 ) + 'px'
			} );
		}

		// Dialog parts dimensions.
		//  16x16  |  ?x16  |  16x16
		//  16x?   |  ?x?   |  16x?
		//  30x51  |  ?x51  |  30x51
		return function( width, height )
		{
			setSize( this, 't', width - 32, 16 );
			setSize( this, 'l', 16, height - 67 );
			setSize( this, 'c', width - 32, height - 67 );
			setSize( this, 'r', 16, height - 67 );
			setSize( this, 'b', width - 60, 51 );
			setSize( this, null, width, height );
			this._.size = { width : width, height : height };
		}
	})(),

	move : function( x, y )
	{
		// The dialog may be fixed positioned or absolute positioned. Ask the
		// browser what is the current situation first.
		var isFixed = this._.element.getComputedStyle( 'position' ) == 'fixed';

		// If not fixed positioned, add scroll position to the coordinates.
		if ( !isFixed )
		{
			var scrollPosition = CKEDITOR.document.getWindow().getScrollPosition();
			x += scrollPosition.x;
			y += scrollPosition.y;
		}

		this._.element.getFirst().setStyles(
				{
					'left' : x + 'px',
					'top' : y + 'px'
				});
	},

	show : function()
	{
		// Insert the dialog's element to the root document.
		var element = this._.element;
		var definition = this._.definition;
		if ( element.getParent() != CKEDITOR.document.getBody() )
			element.appendTo( CKEDITOR.document.getBody() );

		// First, set the dialog to an appropriate size.
		this.resize( definition.minWidth, definition.minHeight );

		// Rearrange the dialog to the middle of the window.
		var viewSize = CKEDITOR.document.getWindow().getViewPaneSize();
		this.move( ( viewSize.width - this._.size.width ) / 2, ( viewSize.height - this._.size.height ) / 2 );
	},

	hide : function()
	{
		// Remove the dialog's element from the root document.
		var element = this._.element;
		if ( !element.getParent() )
			return;
		element.remove();
	}
};

(function()
{
	CKEDITOR.tools.extend( CKEDITOR.editor.prototype,
		{
			'openDialog' : function( dialogName )
			{
				var dialog = CKEDITOR.dialog.storedDialogs[dialogName] || new CKEDITOR.dialog.construct( this, dialogName );
				CKEDITOR.dialog.storedDialogs[dialogName] = dialog;
				dialog.show();
				return dialog;
			}
		});
})();
