﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright ( C ) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later ( the "GPL" )
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later ( the "LGPL" )
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later ( the "MPL" )
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * Manage table operations.
 */

var FCKTableHandler = new Object() ;

FCKTableHandler.InsertRow = function()
{
	// Get the row where the selection is placed in.
	var oRow = FCKSelection.MoveToAncestorNode( 'TR' ) ;
	if ( !oRow ) return ;

	// Create a clone of the row.
	var oNewRow = oRow.cloneNode( true ) ;

	// Insert the new row (copy) before of it.
	oRow.parentNode.insertBefore( oNewRow, oRow ) ;

	// Clean the row (it seems that the new row has been added after it).
	FCKTableHandler.ClearRow( oRow ) ;
}

FCKTableHandler.DeleteRows = function( row )
{
	// If no row has been passed as a parameer,
	// then get the row( s ) containing the cells where the selection is placed in.	
	// If user selected multiple rows ( by selecting multiple cells ), walk
	// the selected cell list and delete the rows containing the selected cells
	if ( !row  )
	{
		var aCells = FCKTableHandler.GetSelectedCells();
		var aRowsToDelete = new Array();
		//queue up the rows -- it's possible ( and likely ) that we may get duplicates
		for ( var i = 0; i < aCells.length; i++  )
		{
			var oRow = FCKTools.GetElementAscensor( aCells[i],'TR'  );
			aRowsToDelete[oRow.rowIndex] = oRow;
		}
		for ( var i = aRowsToDelete.length; i >= 0; i--  )
		{
			if ( aRowsToDelete[i]  )
				FCKTableHandler.DeleteRows( aRowsToDelete[i] );
		}
	}
	if ( !row  ) return ;

	// Get the row's table.
	var oTable = FCKTools.GetElementAscensor( row, 'TABLE' ) ;

	// If just one row is available then delete the entire table.
	if ( oTable.rows.length == 1 )
	{
		FCKTableHandler.DeleteTable( oTable ) ;
		return ;
	}

	// Delete the row.
	row.parentNode.removeChild( row ) ;
}

FCKTableHandler.DeleteTable = function( table )
{
	// If no table has been passed as a parameer,
	// then get the table where the selection is placed in.
	if ( !table )
	{
		table = FCKSelection.GetSelectedElement() ;
		if ( !table || table.tagName != 'TABLE' )
			table = FCKSelection.MoveToAncestorNode( 'TABLE' ) ;
	}
	if ( !table ) return ;

	// Delete the table.
	FCKSelection.SelectNode( table ) ;
	FCKSelection.Collapse();
	
	// if the table is wrapped with a singleton <p> ( or something similar ), remove
	// the surrounding tag -- which likely won't show after deletion anyway
	if ( table.parentNode.children.length == 1 )
		table.parentNode.parentNode.removeChild( table.parentNode );
	else
		table.parentNode.removeChild( table  ) ;
}

FCKTableHandler.InsertColumn = function()
{
	// Get the cell where the selection is placed in.
	var oCell = FCKSelection.MoveToAncestorNode( 'TD' ) || FCKSelection.MoveToAncestorNode( 'TH' ) ;

	if ( !oCell ) return ;

	// Get the cell's table.
	var oTable = FCKTools.GetElementAscensor( oCell, 'TABLE' ) ;

	// Get the index of the column to be created (based on the cell).
	var iIndex = oCell.cellIndex + 1 ;

	// Loop throw all rows available in the table.
	for ( var i = 0 ; i < oTable.rows.length ; i++ )
	{
		// Get the row.
		var oRow = oTable.rows[i] ;

		// If the row doens't have enought cells, ignore it.
		if ( oRow.cells.length < iIndex )
			continue ;

		oCell = oRow.cells[iIndex-1].cloneNode( false ) ;

		if ( FCKBrowserInfo.IsGecko )
			oCell.innerHTML = GECKO_BOGUS ;

		// Get the cell that is placed in the new cell place.
		var oBaseCell = oRow.cells[iIndex] ;

		// If the cell is available (we are not in the last cell of the row).
		if ( oBaseCell )
			oRow.insertBefore( oCell, oBaseCell ) ;	// Insert the new cell just before of it.
		else
			oRow.appendChild( oCell ) ;				// Append the cell at the end of the row.
	}
}

FCKTableHandler.DeleteColumns = function( oCell )
{
	// if user selected multiple cols ( by selecting multiple cells ), walk
	// the selected cell list and delete the rows containing the selected cells
	if ( !oCell  )
	{
		var aColsToDelete = FCKTableHandler.GetSelectedCells();
		for ( var i = aColsToDelete.length; i >= 0; i--  )
		{
			if ( aColsToDelete[i]  )
				FCKTableHandler.DeleteColumns( aColsToDelete[i]  );
		}
		return;
	}

	if ( !oCell ) return ;

	// Get the cell's table.
	var oTable = FCKTools.GetElementAscensor( oCell, 'TABLE' ) ;

	// Get the cell index.
	var iIndex = oCell.cellIndex ;

	// Loop throw all rows (from down to up, because it's possible that some
	// rows will be deleted).
	for ( var i = oTable.rows.length - 1 ; i >= 0 ; i-- )
	{
		// Get the row.
		var oRow = oTable.rows[i] ;

		// If the cell to be removed is the first one and the row has just one cell.
		if ( iIndex == 0 && oRow.cells.length == 1 )
		{
			// Remove the entire row.
			FCKTableHandler.DeleteRows( oRow ) ;
			continue ;
		}

		// If the cell to be removed exists the delete it.
		if ( oRow.cells[iIndex] )
			oRow.removeChild( oRow.cells[iIndex] ) ;
	}
}

FCKTableHandler.InsertCell = function( cell )
{
	// Get the cell where the selection is placed in.
	var oCell = cell ? cell : FCKSelection.MoveToAncestorNode( 'TD' ) ;
	if ( !oCell ) return null ;

	// Create the new cell element to be added.
	var oNewCell = FCK.EditorDocument.createElement( 'TD' ) ;
	if ( FCKBrowserInfo.IsGecko )
		oNewCell.innerHTML = GECKO_BOGUS ;
//	oNewCell.innerHTML = "&nbsp;" ;

	// If it is the last cell in the row.
	if ( oCell.cellIndex == oCell.parentNode.cells.length - 1 )
	{
		// Add the new cell at the end of the row.
		oCell.parentNode.appendChild( oNewCell ) ;
	}
	else
	{
		// Add the new cell before the next cell (after the active one).
		oCell.parentNode.insertBefore( oNewCell, oCell.nextSibling ) ;
	}

	return oNewCell ;
}

FCKTableHandler.DeleteCell = function( cell )
{
	// If this is the last cell in the row.
	if ( cell.parentNode.cells.length == 1 )
	{
		// Delete the entire row.
		FCKTableHandler.DeleteRows( FCKTools.GetElementAscensor( cell, 'TR' ) ) ;
		return ;
	}

	// Delete the cell from the row.
	cell.parentNode.removeChild( cell ) ;
}

FCKTableHandler.DeleteCells = function()
{
	var aCells = FCKTableHandler.GetSelectedCells() ;

	for ( var i = aCells.length - 1 ; i >= 0  ; i-- )
	{
		FCKTableHandler.DeleteCell( aCells[i] ) ;
	}
}

FCKTableHandler.MergeCells = function()
{
	// Get all selected cells.
	var aCells = FCKTableHandler.GetSelectedCells() ;

	// At least 2 cells must be selected.
	if ( aCells.length < 2 )
		return ;

	// The merge can occour only if the selected cells are from the same row.
	if ( aCells[0].parentNode != aCells[aCells.length-1].parentNode )
		return ;

	// Calculate the new colSpan for the first cell.
	var iColSpan = isNaN( aCells[0].colSpan ) ? 1 : aCells[0].colSpan ;

	var sHtml = '' ;
	var oCellsContents = FCK.EditorDocument.createDocumentFragment() ;

	for ( var i = aCells.length - 1 ; i >= 0 ; i-- )
	{
		var eCell = aCells[i] ;

		// Move its contents to the document fragment.
		for ( var c = eCell.childNodes.length - 1 ; c >= 0 ; c-- )
		{
			var eChild = eCell.removeChild( eCell.childNodes[c] ) ;

			if ( ( eChild.hasAttribute && eChild.hasAttribute('_moz_editor_bogus_node') ) || ( eChild.getAttribute && eChild.getAttribute( 'type', 2 ) == '_moz' ) )
				continue ;

				oCellsContents.insertBefore( eChild, oCellsContents.firstChild ) ;
		}

		if ( i > 0 )
		{
			// Accumulate the colspan of the cell.
			iColSpan += isNaN( eCell.colSpan ) ? 1 : eCell.colSpan ;

			// Delete the cell.
			FCKTableHandler.DeleteCell( eCell ) ;
		}
	}

	// Set the innerHTML of the remaining cell (the first one).
	aCells[0].colSpan = iColSpan ;

	if ( FCKBrowserInfo.IsGecko && oCellsContents.childNodes.length == 0 )
		aCells[0].innerHTML = GECKO_BOGUS ;
	else
		aCells[0].appendChild( oCellsContents ) ;
}

FCKTableHandler.SplitCell = function()
{
	// Check that just one cell is selected, otherwise return.
	var aCells = FCKTableHandler.GetSelectedCells() ;
	if ( aCells.length != 1 )
		return ;

	var aMap = this._CreateTableMap( aCells[0].parentNode.parentNode ) ;
	var iCellIndex = FCKTableHandler._GetCellIndexSpan( aMap, aCells[0].parentNode.rowIndex , aCells[0] ) ;

	var aCollCells = this._GetCollumnCells( aMap, iCellIndex ) ;

	for ( var i = 0 ; i < aCollCells.length ; i++ )
	{
		if ( aCollCells[i] == aCells[0] )
		{
			var oNewCell = this.InsertCell( aCells[0] ) ;
			if ( !isNaN( aCells[0].rowSpan ) && aCells[0].rowSpan > 1 )
				oNewCell.rowSpan = aCells[0].rowSpan ;
		}
		else
		{
			if ( isNaN( aCollCells[i].colSpan ) )
				aCollCells[i].colSpan = 2 ;
			else
				aCollCells[i].colSpan += 1 ;
		}
	}
}

// Get the cell index from a TableMap.
FCKTableHandler._GetCellIndexSpan = function( tableMap, rowIndex, cell )
{
	if ( tableMap.length < rowIndex + 1 )
		return null ;

	var oRow = tableMap[ rowIndex ] ;

	for ( var c = 0 ; c < oRow.length ; c++ )
	{
		if ( oRow[c] == cell )
			return c ;
	}
	
	return null ;
}

// Get the cell location from a TableMap. Returns an array with an [x,y] location
FCKTableHandler._GetCellLocation = function( tableMap, cell  )
{
	for ( var i = 0 ; i < tableMap.length; i++ )
	{
		for ( var c = 0 ; c < tableMap[i].length ; c++  )
		{
			if ( tableMap[i][c] == cell  ) return [i,c];
		}
	}
	return null ;
}

// Get the cells available in a collumn of a TableMap.
FCKTableHandler._GetCollumnCells = function( tableMap, collumnIndex )
{
	var aCollCells = new Array() ;

	for ( var r = 0 ; r < tableMap.length ; r++ )
	{
		var oCell = tableMap[r][collumnIndex] ;
		if ( oCell && ( aCollCells.length == 0 || aCollCells[ aCollCells.length - 1 ] != oCell ) )
			aCollCells[ aCollCells.length ] = oCell ;
	}

	return aCollCells ;
}

// This function is quite hard to explain. It creates a matrix representing all cells in a table.
// The difference here is that the "spanned" cells (colSpan and rowSpan) are duplicated on the matrix
// cells that are "spanned". For example, a row with 3 cells where the second cell has colSpan=2 and rowSpan=3
// will produce a bi-dimensional matrix with the following values (representing the cells):
//		Cell1, Cell2, Cell2, Cell 3
//		Cell4, Cell2, Cell2, Cell 5
FCKTableHandler._CreateTableMap = function( table )
{
	var aRows = table.rows ;

	// Row and Collumn counters.
	var r = -1 ;

	var aMap = new Array() ;

	for ( var i = 0 ; i < aRows.length ; i++ )
	{
		r++ ;
		if ( !aMap[r] )
			aMap[r] = new Array() ;

		var c = -1 ;

		for ( var j = 0 ; j < aRows[i].cells.length ; j++ )
		{
			var oCell = aRows[i].cells[j] ;

			c++ ;
			while ( aMap[r][c] )
				c++ ;

			var iColSpan = isNaN( oCell.colSpan ) ? 1 : oCell.colSpan ;
			var iRowSpan = isNaN( oCell.rowSpan ) ? 1 : oCell.rowSpan ;

			for ( var rs = 0 ; rs < iRowSpan ; rs++ )
			{
				if ( !aMap[r + rs] )
					aMap[r + rs] = new Array() ;

				for ( var cs = 0 ; cs < iColSpan ; cs++ )
				{
					aMap[r + rs][c + cs] = aRows[i].cells[j] ;
				}
			}

			c += iColSpan - 1 ;
		}
	}
	return aMap ;
}

FCKTableHandler.ClearRow = function( tr )
{
	// Get the array of row's cells.
	var aCells = tr.cells ;

	// Replace the contents of each cell with "nothing".
	for ( var i = 0 ; i < aCells.length ; i++ )
	{
		if ( FCKBrowserInfo.IsGecko )
			aCells[i].innerHTML = GECKO_BOGUS ;
		else
			aCells[i].innerHTML = '' ;
	}
}

//Returns TRUE if any cell has width set
FCKTableHandler.HasCellWidths = function( table )
{
	for ( var r = 0; r < table.rows.length; r++ )
	{
		for ( var c = 0; c < table.rows[r].cells.length; c++ )
		{
			if ( table.rows[r].cells[c].width ) return true;
		}
	}
	return false;
}

//Clears all cell widths/heights ( letting the browser size everything )
FCKTableHandler.ClearCellWidths = function( table )
{
	for ( var r = 0; r < table.rows.length; r++ )
	{
		for ( var c = 0; c < table.rows[r].cells.length; c++ )
		{
			table.rows[r].cells[c].width = "";
			table.rows[r].cells[c].height = "";
			table.rows[r].cells[c].removeAttribute( "WIDTH" );
			table.rows[r].cells[c].removeAttribute( "HEIGHT" );
		}
	}
}

//Cleanup table widths. If bPercent, recalculates table widths in %. If bClear,
//moves all table widths as early as possible

FCKTableHandler.CleanupTableWidths = function( table, bPercent, bClear, aMapIn )
{
	var aMap = aMapIn ? aMapIn : this._CreateTableMap( table ) ;
	var nCols = aMap[0].length;
	var nRows = aMap.length;
	var nTotalWidth = 0;
	var aSizeCells = new Array();
	var aSizes = new Array();
	//work the table column-by-column
	for ( var nCol = 0; nCol < nCols; nCol++ )
	{
		var nMax = 0;
		var oCell = null;
		//walk the rows for a specific column -- find the topmost non-colspan'd item
		//and the maximum pixel width ( according to the browser )
		for ( var nRow = 0; nRow < nRows; nRow++ )
		{
			if ( aMap[nRow][nCol].colSpan > 1 ) continue;
			//use topmost non-colspan'd cell to put the width in
			if ( !oCell ) oCell = aMap[nRow][nCol];
			if ( aMap[nRow][nCol].offsetWidth > nMax ) nMax = aMap[nRow][nCol].offsetWidth;
		}
		aSizes[nCol] = nMax;
		nTotalWidth += nMax;
		aSizeCells[nCol] = oCell;
	}
	//if we were asked for percentage width, go through and convert the sizes to %. note
	//that we do this based on the calculated width of all the cells; this is more
	//reliable because offsetWidth, et al., includes table borders, padding, etc.
	for ( var nCol = 0; nCol < aSizeCells.length; nCol++ )
	{
		if ( bPercent )
		{
			var nWidth = Math.round( 100 * (aSizeCells[nCol].offsetWidth/nTotalWidth ));
			if ( nWidth == 0 ) nWidth = 1;
			strWidth =  nWidth + "%";
		}
		else
		{
			strWidth =  aSizes[nCol];
		}

		//set all width attributes
		for ( var nRow = 0; nRow < nRows; nRow++ )
		{
			if ( aMap[nRow][nCol].colSpan == 1 )
			{
				aMap[nRow][nCol].width = bClear ? '' : strWidth;
				if ( bClear ) aMap[nRow][nCol].removeAttribute( "width" );
				aSizeCells[nCol].width = strWidth;
			}
		}
	}
}

// Move the cursor into the next ( or previous ) cell
FCKTableHandler.MoveToNextCell = function( bRev )
{
	var aCells = FCKTableHandler.GetSelectedCells();
	if ( aCells.length == 0 ) return;
	var oCell = aCells[0];
	var oNextCell = bRev ? oCell.previousSibling: oCell.nextSibling;
	if ( !oNextCell )
	{
		var oNext;
		var oRow = FCKTools.GetElementAscensor( oCell,"TR" );
		if ( bRev )
		{
			if ( !(oNext = oRow.previousSibling )) return;
			oNextCell=oNext.cells[oNext.cells.length - 1];
		}
		else
		{
			if ( !(oNext = oRow.nextSibling )) return;
			oNextCell=oNext.cells[0];
		}
	}
	FCKSelection.SelectNode( oNextCell );
	FCKSelection.Collapse();
}
//////////////////////////////////////////////////////////////////
// Table Sizer
//


// Returns the closest sizeable cell to point (or the left of the specified point
// if between cells). Generally, this will be a heading cell (i.e. a cell in
// the first row). If *all* the candidate cells are colspan'd (heaven forbid),
// don't allow sizing. x and y are in client coordinates

FCKTableHandler.SizableCellFromPoint = function( table, ncx, ncy )
{
	var aRows = table.rows ;
	var x = ncx - this._CalcPosition( table )[0];
	for ( var i = 0 ; i < aRows.length ; i++  )
	{
		for ( var j = 0; j < aRows[i].cells.length - 1; j++ )
		{
			if ( aRows[i].cells[j + 1].offsetLeft > x )
			{
				if ( aRows[i].cells[j].colSpan < 2 )
				{
					return aRows[i].cells[j];
				}
				else
				{
					break;
				}
			}	
		}
	}
	return null;
}

// Creates the table resize bar. If a table resize bar is present, uses it. You
// must explicitly destroy the table resize bar with DestroyResizeBar after use.
FCKTableHandler.CreateResizeBar = function()
{
	if ( this.ResizeBar ) return this.ResizeBar;
	var oBar;	
	oBar = FCK.EditorDocument.createElement( "SPAN" );

	// setup the bar
	oBar.id = '__FCKResizeBar';
	oBar.style.position = "absolute";
	oBar.style.top = "0px";
	oBar.style.left = "0px";
	oBar.style.height = "0px";
	oBar.style.width = "2px";
	oBar.style.borderLeft = "1px solid #0033FF";
	oBar.style.display = "none";
	oBar.style.cursor = "e-resize";

	FCK.EditorDocument.body.appendChild( oBar );
	this.ResizeBar = oBar;
	return oBar;
}

// Destroys the table resize bar
FCKTableHandler.DestroyResizeBar = function()
{
	if ( !this.ResizeBar ) return;
	this.ResizeBar.parentNode.removeChild( FCKTableHandler.ResizeBar );
	this.ResizeBar = null;
}

// Figures out whether we want to size or let the browser do its thing. We can
// size if the table is the target and we're between cells, OR if we're on
// a table cell and on the far right edge of the cell within 3px of the edge
// ( allows us to easily size tables with thin borders )

FCKTableHandler.CanSizeHere = function( ev, cell, tbl )
{
	var elem = ev.srcElement || ev.originalTarget;
	var aCellLoc = this._CalcPosition( cell );
	var aTableLoc = this._CalcPosition( tbl );
	//in the td client area, but not on the edge
	if ( elem != tbl ) return ( (aCellLoc[0] + cell.offsetWidth - ev.clientX ) < 3);
	//on the table edge
	if ( (aTableLoc[0] + tbl.offsetWidth - ev.clientX ) < 3 ||
		( aTableLoc[0] - ev.clientX ) < 3 ||
		( aTableLoc[1] + tbl.offsetHeight - ev.clientY < 3 ) ||
		( aTableLoc[1] - ev.clientY < 3 )) return false;
	return true;
}


// Sets up table sizing
FCKTableHandler.StartTableSizing = function( ev, cell, tbl )
{
	if ( !cell ) return null;
	this.tableMap = this._CreateTableMap( tbl ) ;
	var aCellLoc = this._GetCellLocation( this.tableMap, cell );				//returns [row,col]
	if ( !aCellLoc ) return null;
	//we're in the last column, so we can't size
	if ( aCellLoc[1] == this.tableMap[aCellLoc[0]].length - 1 ) return null;
	var nTarget = aCellLoc[1] + 1;
	this.adjacentCell = null;
	for ( var i=0; i < this.tableMap.length; i++ )
	{
		if ( this.tableMap[i][nTarget].colSpan < 2 )
		{
			this.adjacentCell = this.tableMap[i][nTarget];
			break;
		}
	}
	if ( this.adjacentCell == null ) return null;	//can't size, no adjacent col
	this.targetCell = cell;
	//ok. we have everything we need. off we go.
	
	//create the resize bar
	this.pixWidths = !( this.targetCell.width.search('%' ) == -1 || !this.targetCell.width);
	var oVBar = this.CreateResizeBar();
	//oVBar.style.left = FCK.EditorDocument.body.scrollLeft + this._CalcPosition( cell ) + cell.offsetWidth;
	//this.origPos = FCK.EditorDocument.body.scrollLeft + ev.clientX;
	this.origPos = FCK.EditorDocument.body.scrollLeft + this._CalcPosition( cell )[0] + cell.offsetWidth;
	oVBar.style.left = this.origPos;
	oVBar.style.cursor = "e-resize";
	oVBar.setAttribute( "UNSELECTABLE","on" );
	tbl.setAttribute( "UNSELECTABLE","on" );
	this.sizeOffset = ev.clientX - this.origPos;
	//minimum size is always the left edge of the cell + some safety margin.
	//max size is always the right edge of the next cell - some safety margin
	this.minSize = FCK.EditorDocument.body.scrollLeft + this._CalcPosition( cell )[0] + 10;
	this.maxSize = FCK.EditorDocument.body.scrollLeft + this._CalcPosition( this.adjacentCell )[0] + this.adjacentCell.offsetWidth - 10;
	oVBar.style.top = this._CalcPosition( tbl )[1];
	oVBar.style.height = tbl.clientHeight + ( tbl.border*2 );
	oVBar.style.display = "inline";
	this.CleanupTableWidths( tbl,false, true,this.tableMap );
	return true;
}

FCKTableHandler.FinishTableSizing = function()
{
	var tbl = FCKTools.GetElementAscensor( this.targetCell,"TABLE" );
	var nTargetDiff = this.ResizeBar.offsetLeft - this.origPos;
	//widths are in pixels after StartTableSizing, so this is safe
	tbl.style.cursor = '';
	if ( tbl.runtimeStyle ) tbl.runtimeStyle.cursor = '';
	this.targetCell.width = parseInt( this.targetCell.width ) + nTargetDiff;
	this.adjacentCell.width = parseInt( this.adjacentCell.width ) - nTargetDiff;
	this.DestroyResizeBar();
	this.CleanupTableWidths( tbl,this.pixWidths,true,this.tableMap );
	this.targetCell = null;
	this.origPos = null;
	tbl.removeAttribute( "UNSELECTABLE" );
	if ( FCKBrowserInfo.IsGecko  ) tbl.style.MozUserSelect = "";
}

// Sizes the table to the given mouse position
FCKTableHandler.SizeTo = function( x )
{
	var nPos = x - this.sizeOffset;
	if ( nPos > this.maxSize ) nPos = this.maxSize;
	if ( nPos < this.minSize ) nPos = this.minSize;
	//runtimeStyle is way faster under IE
	if ( this.ResizeBar.runtimeStyle )
		this.ResizeBar.runtimeStyle.left = nPos;
	else
		this.ResizeBar.style.left = nPos;
	if ( FCKBrowserInfo.IsGecko && FCK.EditorDocument.selection.type != 'None' ) FCK.EditorDocument.selection.collapse();
}

// returns TRUE if we are actively sizing a table
FCKTableHandler.IsTableSizing = function()
{
	return ( this.targetCell != null );
}

// figure out where ( with respect to the edge of the parent ) a given table/cell is
FCKTableHandler._CalcPosition = function( ob )
{
	var oParent=ob;
	var nY = 0;
	var nX = 0;
	while ( oParent && oParent.tagName != "BODY" )
	{
		nX += oParent.offsetLeft;
		nY += oParent.offsetTop;
		oParent = oParent.offsetParent;
	}
	return [nX,nY];
}

FCKTableHandler.tbl_MouseDown = function ( FCK, e )
{
	var elem = e.srcElement || e.originalTarget;
	var strTag = elem ? elem.tagName.toUpperCase() : null;
	//find the table we're part of, if we are
	if ( elem && (strTag == 'TABLE' || strTag == 'TD' || strTag == 'TH' ) )
	{
		FCKTableHandler.targetCell = null;
		var oTable = FCKTools.GetElementAscensor( elem, "TABLE" );
		//figure out if there's a cell we can size
		var oCell = FCKTableHandler.SizableCellFromPoint( oTable, e.clientX, e.clientY );
		if ( !oCell ) return true;
		if ( FCKTableHandler.CanSizeHere( e,oCell,oTable ) )
		{
			if ( FCKTableHandler.StartTableSizing( e,oCell, oTable ) )
			{
				if ( oTable.runtimeStyle ) oTable.runtimeStyle.cursor = "e-resize";
				if ( FCKBrowserInfo.IsGecko  ) oTable.style.MozUserSelect = "none";
				e.cancelBubble	= true ;
				e.returnValue	= false ;
				return false;
			}
		}
	}
	return true;
}

FCKTableHandler.tbl_MouseUp = function ( FCK, e )
{
	if ( FCKTableHandler.IsTableSizing( )) FCKTableHandler.FinishTableSizing();
}

FCKTableHandler.tbl_MouseMove = function ( FCK, e )
{
	var elem = e.srcElement || e.originalTarget;
	if ( FCKTableHandler.IsTableSizing() )
	{
		FCKTableHandler.SizeTo( e.clientX );
		e.cancelBubble	= true ;
		e.returnValue	= false ;
		return false;
	}
	
	if ( elem.tagName.toUpperCase() == 'TABLE' )
	{
		//let the browser handle global sizing and move if the user is on
		//the RH edge of a table
		if ( elem.clientWidth - e.offsetX < 3 ||
			elem.clientHeight - e.offsetY < 3 ||
			e.offsetX < 2 || e.offsetY < 2 )
		{
			elem.style.cursor = "";	
			return true;
		}
		//block browser sizing -- we're going to do it ourselves, thanks
		if ( elem.runtimeStyle ) elem.runtimeStyle.cursor = "e-resize";
		e.cancelBubble	= true ;
		e.returnValue	= false ;
		return false;
	}
	else if ( elem.tagName.toUpperCase() == 'TD' )
	{
	    var tbl = FCKTools.GetElementAscensor( elem, "TABLE" );
		if ( e.offsetX >= (elem.offsetWidth - 4 ))
		{
			e.cancelBubble	= true ;
			e.returnValue	= false ;
			return false;
	    }
	}
	return true;
}

FCK.Events.AttachEvent( "OnMouseMove", FCKTableHandler.tbl_MouseMove );
FCK.Events.AttachEvent( "OnMouseDown", FCKTableHandler.tbl_MouseDown );
FCK.Events.AttachEvent( "OnMouseUp", FCKTableHandler.tbl_MouseUp );
