/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'dialogui' );

CKEDITOR.tools.extend( CKEDITOR.ui.dialog,
	{
		labeledElement : function( dialog, elementDefinition, htmlList, contentHtml )
		{
			if (arguments.length < 4)
				return;

			var innerHTML = function()
			{
				var html = [ '<div class="cke_dialog_ui_labeled_title">',
						CKEDITOR.tools.htmlEncode( elementDefinition.title ),
						'</div>',
						'<div class="cke_dialog_ui_labeled_content">',
						contentHtml( dialog, elementDefinition ),
						'</div>'
					];
				return html.join( '' );
			}
			CKEDITOR.ui.dialog.uiElement.call( this, dialog, elementDefinition, htmlList, 'div', null, null, innerHTML );
		},

		inputElement : function( dialog, elementDefinition, htmlList, stylesArg, attributesArg, contentsArg )
		{
			if (arguments.length < 3)
				return;

			if ( !this._ )
				this._ = {};
			var attributes = ( attributesArg && attributesArg.call ? attributesArg( elementDefinition ) : attributesArg ) || {},
				id = this._.inputId = elementDefinition.id && elementDefinition.id + '_inputElement',
				styles = ( stylesArg && stylesArg.call ? stylesArg( elementDefinition ) : stylesArg ) || {},
				inputContents = ( contentsArg && contentsArg.call ? contentsArg( dialog, elementDefinition) : contentsArg ) || '';

			// Set the id for the inner input element.
			if ( id )
				attributes.id = attributes.name = id;

			// Set the type.
			attributes.type = elementDefinition.type;

			// Set the type and definition CSS class names.
			var classes = {};
			classes[ 'cke_dialog_ui_input_' + elementDefinition.type ] = 1;
			if ( elementDefinition.className )
				classes[ elementDefinition.className ] = 1;
			var attributeClasses = ( attributes.class && attributes.class.split ) ? attributes.class.split( ' ' ) : [];
			for ( var i = 0 ; i < attributeClasses.length ; i++ )
			{
				if ( attributeClasses[i] )
					classes[ attributeClasses[i] ] = 1;
			}
			var finalClasses = [];
			for ( var i in classes )
				finalClasses.push( i );
			attributes.class = finalClasses.join( ' ' );

			// Set the default value.
			if ( elementDefinition.default )
				attributes.value = elementDefinition.default;

			// Write the inline CSS styles.

			var innerHTML = function()
			{
				var html = [ '<input ' ];
				for ( var i in attributes )
					html.push( i + '="' + attributes[i] + '" ' );
				html.push( '>', inputContents, '</input>' );
				return html.join( '' );
			}
			CKEDITOR.ui.dialog.labeledElement.call( this, dialog, elementDefinition, htmlList, innerHTML );
		}
	});

CKEDITOR.ui.dialog.labeledElement.prototype = new CKEDITOR.ui.dialog.uiElement;
CKEDITOR.ui.dialog.inputElement.prototype = CKEDITOR.tools.extend( new CKEDITOR.ui.dialog.labeledElement,
		{
			getElement : function()
			{
				return CKEDITOR.document.getById( this._.inputId );
			}
		});

CKEDITOR.dialog.addUIElement( 'text',
		{
			build : function( dialog, elementDefinition, output )
			{
				return new CKEDITOR.ui.dialog.inputElement( dialog, elementDefinition, output );
			}
		});
