/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'dialogui' );

CKEDITOR.tools.extend( CKEDITOR.ui.dialog,
	{
		labeledElement : function( dialog, elementDefinition, htmlList, contentHtml )
		{
			if ( arguments.length < 4 )
				return;

			if ( !this._ )
				this._ = {};
			var children = this._.children = [];
			var innerHTML = function()
			{
				var html = [ '<div class="cke_dialog_ui_labeled_label">',
						CKEDITOR.tools.htmlEncode( elementDefinition.label ),
						'</div>',
						'<div class="cke_dialog_ui_labeled_content">',
						contentHtml( dialog, elementDefinition ),
						'</div>'
					];
				return html.join( '' );
			}
			CKEDITOR.ui.dialog.uiElement.call( this, dialog, elementDefinition, htmlList, 'div', null, null, innerHTML );
		},

		textInput : function( dialog, elementDefinition, htmlList, stylesArg, attributesArg, contentsArg )
		{
			if ( arguments.length < 3 )
				return;

			if ( !this._ )
				this._ = {};
			var attributes = ( attributesArg && attributesArg.call ? attributesArg( elementDefinition ) : attributesArg ) || {},
				id = this._.inputId = attributes.id || elementDefinition.id, 
				styles = ( stylesArg && stylesArg.call ? stylesArg( elementDefinition ) : stylesArg ) || {},
				inputContents = ( contentsArg && contentsArg.call ? contentsArg( dialog, elementDefinition) : contentsArg ) || '';

			// Set the id for the inner input element.
			if ( id )
			{
				id = this._.inputId = id + '_textInput';
				attributes.id = attributes.name = id;
			}

			// Set the type.
			attributes.type = elementDefinition.type;

			// Set the type and definition CSS class names.
			var classes = {};
			classes[ 'cke_dialog_ui_input_' + elementDefinition.type ] = 1;
			if ( elementDefinition.className )
				classes[ elementDefinition.className ] = 1;
			var attributeClasses = ( attributes.class && attributes.class.split ) ? attributes.class.split( ' ' ) : [];
			for ( var i = 0 ; i < attributeClasses.length ; i++ )
			{
				if ( attributeClasses[i] )
					classes[ attributeClasses[i] ] = 1;
			}
			var finalClasses = [];
			for ( var i in classes )
				finalClasses.push( i );
			attributes.class = finalClasses.join( ' ' );

			// Set the default value.
			if ( elementDefinition.default )
				attributes.value = elementDefinition.default;

			// Write the inline CSS styles.
			var styleStr = [];
			for ( var i in styles )
				styleStr.push( i + ':' + styles[i] );
			if ( styleStr.length > 0 )
				attributes.style = styleStr.join( '; ' );

			var innerHTML = function()
			{
				var html = [ '<input ' ];
				for ( var i in attributes )
					html.push( i + '="' + attributes[i] + '" ' );
				html.push( '>', inputContents, '</input>' );
				return html.join( '' );
			}
			CKEDITOR.ui.dialog.labeledElement.call( this, dialog, elementDefinition, htmlList, innerHTML );
		},

		checkbox : function( dialog, elementDefinition, htmlList )
		{
			if ( arguments.length < 3)
				return;

			if ( !this._ )
				var _ = this._ = {};

			var innerHTML = function()
			{
				var myDefinition = CKEDITOR.tools.extend( {}, elementDefinition,
						{
							id : elementDefinition.id ? elementDefinition.id + '_checkbox' : CKEDITOR.tools.getNextNumber() + '_checkbox',
							title : null,
							type : null
						}, true ),
					html = [],
					attributes = { class : 'cke_dialog_ui_checkbox_input', type : 'checkbox' };
				if ( elementDefinition.checked )
					attributes.checked = 'checked';
				_.checkbox = new CKEDITOR.ui.dialog.uiElement( dialog, myDefinition, html, 'input', null, attributes );
				html.push( ' ', CKEDITOR.tools.htmlEncode( elementDefinition.label ) );
				return html.join( '' );
			}

			CKEDITOR.ui.dialog.uiElement.call( this, dialog, elementDefinition, htmlList, 'label', null, null, innerHTML );
		},

		radio : function( dialog, elementDefinition, htmlList )
		{
			if ( arguments.length < 3)
				return;

			if ( !this._ )
				this._ = {};
			var children = this._.children = [];

			var innerHTML = function()
			{
				var html = [],
					commonAttributes = { class : 'cke_dialog_ui_radio_item' },
					commonName = elementDefinition.id ? elementDefinition.id + '_radio' : CKEDITOR.tools.getNextNumber() + '_radio';
				for ( var i = 0 ; i < elementDefinition.items.length ; i++ )
				{
					var item = elementDefinition.items[i],
						inputDefinition = CKEDITOR.tools.extend( {}, elementDefinition,
								{
									id : CKEDITOR.tools.getNextNumber() + '_radio_input',
									title : null,
									type : null
								}, true ),
						labelDefinition = CKEDITOR.tools.extend( {}, inputDefinition,
								{
									id : null,
									title : item[2]
								}, true ),
						inputHtml = [],
						inputAttributes = 
						{
							type : 'radio',
							class : 'cke_dialog_ui_radio_input',
							name : commonName,
							value : item[1]
						};
					if ( elementDefinition.default == item[1] )
						inputAttributes.checked = 'checked';
					children.push( new CKEDITOR.ui.dialog.uiElement( dialog, inputDefinition, inputHtml, 'input', null, inputAttributes ) );
					new CKEDITOR.ui.dialog.uiElement( dialog, labelDefinition, html, 'label', null, null,
						   inputHtml.join( '' ) + ' ' + item[0] );
				}
				return html.join( ' ' );
			}

			CKEDITOR.ui.dialog.labeledElement.call(this, dialog, elementDefinition, htmlList, innerHTML );
		},

		button : function( dialog, elementDefinition, htmlList )
		{
			if ( arguments.length < 3)
				return;

			if ( !this._ )
				this._ = {};

			CKEDITOR.ui.dialog.uiElement.call(this, dialog, elementDefinition, htmlList, 'input' );
		}
	});

CKEDITOR.ui.dialog.labeledElement.prototype = new CKEDITOR.ui.dialog.uiElement;
CKEDITOR.ui.dialog.textInput.prototype = CKEDITOR.tools.extend( new CKEDITOR.ui.dialog.labeledElement,
		{
			getElement : function()
			{
				return CKEDITOR.document.getById( this._.inputId );
			}
		}, true );
CKEDITOR.ui.dialog.checkbox.prototype = CKEDITOR.tools.extend( new CKEDITOR.ui.dialog.uiElement,
		{
			getElement : function()
			{
				return this._.checkbox.getElement();
			},

			setValue : function( checked )
			{
				this.getElement().$.checked = checked;
			},

			getValue : function()
			{
				return this.getElement().$.checked;
			}
		}, true );

CKEDITOR.ui.dialog.radio.prototype = CKEDITOR.tools.extend( new CKEDITOR.ui.dialog.uiElement,
		{
			setValue : function( value )
			{
				var children = this._.children,
					item;
				for ( var i = 0 ; ( i < children.length ) && ( item = children[i] ) ; i++ )
					item.$.checked = ( item.getValue() == value );
			},

			getValue : function()
			{
				var children = this._.children;
				for ( var i = 0 ; i < children.length ; i++ )
				{
					if ( children[i].$.checked )
						return children[i].getValue();
				}
				return null;
			}
		}, true );

CKEDITOR.dialog.addUIElement( 'text',
		{
			build : function( dialog, elementDefinition, output )
			{
				return new CKEDITOR.ui.dialog.textInput( dialog, elementDefinition, output );
			}
		});

CKEDITOR.dialog.addUIElement( 'password',
		{
			build : function( dialog, elementDefinition, output )
			{
				return new CKEDITOR.ui.dialog.textInput( dialog, elementDefinition, output );
			}
		});

CKEDITOR.dialog.addUIElement( 'checkbox',
		{
			build : function( dialog, elementDefinition, output )
			{
				return new CKEDITOR.ui.dialog.checkbox( dialog, elementDefinition, output );
			}
		});

CKEDITOR.dialog.addUIElement( 'radio',
		{
			build : function( dialog, elementDefinition, output )
			{
				return new CKEDITOR.ui.dialog.radio( dialog, elementDefinition, output );
			}
		});
