﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

(function()
{
	var loaded = {};

	var loadImage = function( image, callback )
	{
		var doCallback = function()
			{
				loaded[ image ] = 1;
				callback();
			};

		var img = new CKEDITOR.dom.element( 'img' );
		img.on( 'load', doCallback );
		img.on( 'error', doCallback );
		img.setAttribute( 'src', image );
	};

	/**
	 * Load images into the browser cache.
	 * @namespace
	 * @example
	 */
 	CKEDITOR.imageCacher =
	{
		/**
		 * Loads one or more images.
		 * @param {Array} images The URLs for the images to be loaded.
		 * @param {Function} callback The function to be called once all images
		 *		are loaded.
		 */
		load : function( images, callback )
		{
			var pendingCount = images.length;

			var checkPending = function()
			{
				if ( --pendingCount === 0 )
					callback();
			};

			for ( var i = 0 ; i < images.length ; i++ )
			{
				var image = images[ i ];

				if ( loaded[ image ] )
					checkPending();
				else
					loadImage( image, checkPending );
			}
		}
	};
})();
