/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'dialogui' );

CKEDITOR.tools.extend( CKEDITOR.ui.dialog,
	{
		labeledElement : function( dialog, elementDefinition, htmlList, contentHtml )
		{
			if ( arguments.length < 4 )
				return;

			if ( !this._ )
				this._ = {};
			var children = this._.children = [];
			var innerHTML = function()
			{
				var html = [ '<div class="cke_dialog_ui_labeled_label">',
						CKEDITOR.tools.htmlEncode( elementDefinition.label ),
						'</div>',
						'<div class="cke_dialog_ui_labeled_content">',
						contentHtml( dialog, elementDefinition ),
						'</div>'
					];
				return html.join( '' );
			}
			CKEDITOR.ui.dialog.uiElement.call( this, dialog, elementDefinition, htmlList, 'div', null, null, innerHTML );
		},

		textInput : function( dialog, elementDefinition, htmlList, stylesArg, attributesArg, contentsArg )
		{
			if ( arguments.length < 3 )
				return;

			if ( !this._ )
				this._ = {};
			var attributes = ( attributesArg && attributesArg.call ? attributesArg( elementDefinition ) : attributesArg ) || {},
				id = this._.inputId = attributes.id || elementDefinition.id, 
				styles = ( stylesArg && stylesArg.call ? stylesArg( elementDefinition ) : stylesArg ) || {},
				inputContents = ( contentsArg && contentsArg.call ? contentsArg( dialog, elementDefinition) : contentsArg ) || '';

			// Set the id for the inner input element.
			if ( id )
			{
				id = this._.inputId = id + '_textInput';
				attributes.id = attributes.name = id;
			}

			// Set the type.
			attributes.type = elementDefinition.type;

			// Set the type and definition CSS class names.
			var classes = {};
			classes[ 'cke_dialog_ui_input_' + elementDefinition.type ] = 1;
			if ( elementDefinition.className )
				classes[ elementDefinition.className ] = 1;
			var attributeClasses = ( attributes['class'] && attributes['class'].split ) ? attributes['class'].split( ' ' ) : [];
			for ( var i = 0 ; i < attributeClasses.length ; i++ )
			{
				if ( attributeClasses[i] )
					classes[ attributeClasses[i] ] = 1;
			}
			var finalClasses = [];
			for ( var i in classes )
				finalClasses.push( i );
			attributes['class'] = finalClasses.join( ' ' );

			// Set the default value.
			if ( elementDefinition['default'] )
				attributes.value = elementDefinition['default'];

			// Write the inline CSS styles.
			var styleStr = [];
			for ( var i in styles )
				styleStr.push( i + ':' + styles[i] );
			if ( styleStr.length > 0 )
				attributes.style = styleStr.join( '; ' );

			var innerHTML = function()
			{
				var html = [ '<input ' ];
				for ( var i in attributes )
					html.push( i + '="' + attributes[i] + '" ' );
				html.push( '>', inputContents, '</input>' );
				return html.join( '' );
			}
			CKEDITOR.ui.dialog.labeledElement.call( this, dialog, elementDefinition, htmlList, innerHTML );
		},

		checkbox : function( dialog, elementDefinition, htmlList )
		{
			if ( arguments.length < 3)
				return;

			if ( !this._ )
				var _ = this._ = {};

			var innerHTML = function()
			{
				var myDefinition = CKEDITOR.tools.extend( {}, elementDefinition,
						{
							id : elementDefinition.id ? elementDefinition.id + '_checkbox' : CKEDITOR.tools.getNextNumber() + '_checkbox',
							title : null,
							type : null
						}, true ),
					html = [],
					attributes = { 'class' : 'cke_dialog_ui_checkbox_input', type : 'checkbox' };
				if ( elementDefinition.checked )
					attributes.checked = 'checked';
				_.checkbox = new CKEDITOR.ui.dialog.uiElement( dialog, myDefinition, html, 'input', null, attributes );
				html.push( ' ', CKEDITOR.tools.htmlEncode( elementDefinition.label ) );
				return html.join( '' );
			}

			CKEDITOR.ui.dialog.uiElement.call( this, dialog, elementDefinition, htmlList, 'label', null, null, innerHTML );
		},

		radio : function( dialog, elementDefinition, htmlList )
		{
			if ( arguments.length < 3)
				return;

			if ( !this._ )
				this._ = {};
			var children = [];

			var innerHTML = function()
			{
				var inputHtmlList = [], html = [],
					commonAttributes = { 'class' : 'cke_dialog_ui_radio_item' },
					commonName = elementDefinition.id ? elementDefinition.id + '_radio' : CKEDITOR.tools.getNextNumber() + '_radio';
				for ( var i = 0 ; i < elementDefinition.items.length ; i++ )
				{
					var item = elementDefinition.items[i],
						inputDefinition = CKEDITOR.tools.extend( {}, elementDefinition,
								{
									id : CKEDITOR.tools.getNextNumber() + '_radio_input',
									title : null,
									type : null
								}, true ),
						labelDefinition = CKEDITOR.tools.extend( {}, inputDefinition,
								{
									id : null,
									title : item[2]
								}, true ),
						inputHtml = [],
						inputAttributes = 
						{
							type : 'radio',
							'class' : 'cke_dialog_ui_radio_input',
							name : commonName,
							value : item[1]
						};
					if ( elementDefinition['default'] == item[1] )
						inputAttributes.checked = 'checked';
					children.push( new CKEDITOR.ui.dialog.uiElement( dialog, inputDefinition, inputHtml, 'input', null, inputAttributes ) );
					new CKEDITOR.ui.dialog.uiElement( dialog, labelDefinition, inputHtmlList, 'label', null, null,
						   inputHtml.join( '' ) + ' ' + item[0] );
				}
				new CKEDITOR.ui.dialog.hbox( dialog, [], inputHtmlList, html );
				return html.join( '' );
			}

			CKEDITOR.ui.dialog.labeledElement.call( this, dialog, elementDefinition, htmlList, innerHTML );
		},

		button : function( dialog, elementDefinition, htmlList )
		{
			if ( arguments.length < 3)
				return;

			if ( !this._ )
				this._ = {};

			var innerHTML = function()
			{
				return [ '<tbody><tr><td class="cke_dialog_ui_button_txt">', CKEDITOR.tools.htmlEncode( elementDefinition.label ),
					   '</td></tr></tbody>' ].join( '' );
			}

			// Add OnClick event to this input.
			CKEDITOR.event.implementOn( this );
			if ( elementDefinition.onClick )
				this.on( 'click', elementDefinition.onClick );

			// Register an event handler for processing button clicks.
			var me = this;
			dialog.on( 'load', function( eventInfo )
					{
						if ( !eventInfo.data.buttonHandlerRegistered )
						{
							dialog.getElement().on( 'mouseup', function( evt )
								{
									var target = evt.data.getTarget();

									// If there's no active button, bail out.
									if ( !CKEDITOR.ui.dialog.button._.activeButton )
										return;

									// Change styles to remove active status.
									CKEDITOR.ui.dialog.button._.activeButton.removeClass( 'cke_dialog_ui_button_active' );

									// Fire the click event - but only if the
									// active button is the same as target.
									if ( CKEDITOR.ui.dialog.button._.activeButton.$ == target.$ )
										me.fire( 'click' );

									// Clear active button flag.
									CKEDITOR.ui.dialog.button.activeButton = null;
								});

							dialog.getElement().on( 'mousedown', function( evt )
								{
									var target = evt.data.getTarget();

									// If we aren't inside an inactive button, bail out.
									if ( target.getName() != 'td' || target.$.className.search( 'cke_dialog_ui_button_txt' ) == -1 )
										return;

									// Change styles to indicate the button is being clicked.
									target.addClass( 'cke_dialog_ui_button_active' );

									// Store the currently active button.
									CKEDITOR.ui.dialog.button._.activeButton = target;
								});
							eventInfo.data.buttonHandlerRegistered = true;
						}

						this.getElement().unselectable();
					}, this);

			CKEDITOR.ui.dialog.uiElement.call( this, dialog, elementDefinition, htmlList, 'table', null, null, innerHTML );
		},

		html : function( dialog, elementDefinition, htmlList )
		{
			if ( arguments.length < 3 )
				return;

			CKEDITOR.ui.dialog.uiElement.call( this, dialog, elementDefinition, htmlList, 'span', null, null, elementDefinition.html );
		}
	}, true);

CKEDITOR.ui.dialog.textInput.prototype = CKEDITOR.tools.extend( new CKEDITOR.ui.dialog.labeledElement,
		{
			getElement : function()
			{
				return CKEDITOR.document.getById( this._.inputId );
			}
		}, true );

CKEDITOR.ui.dialog.checkbox.prototype = CKEDITOR.tools.extend( new CKEDITOR.ui.dialog.uiElement,
		{
			getElement : function()
			{
				return this._.checkbox.getElement();
			},

			setValue : function( checked )
			{
				this.getElement().$.checked = checked;
			},

			getValue : function()
			{
				return this.getElement().$.checked;
			}
		}, true );

CKEDITOR.ui.dialog.radio.prototype = CKEDITOR.tools.extend( new CKEDITOR.ui.dialog.uiElement,
		{
			setValue : function( value )
			{
				var children = this._.children,
					item;
				for ( var i = 0 ; ( i < children.length ) && ( item = children[i] ) ; i++ )
					item.$.checked = ( item.getValue() == value );
			},

			getValue : function()
			{
				var children = this._.children;
				for ( var i = 0 ; i < children.length ; i++ )
				{
					if ( children[i].$.checked )
						return children[i].getValue();
				}
				return null;
			}
		}, true );

CKEDITOR.ui.dialog.labeledElement.prototype
	= CKEDITOR.ui.dialog.button.prototype
	= CKEDITOR.ui.dialog.html.prototype = new CKEDITOR.ui.dialog.uiElement;

CKEDITOR.ui.dialog.button._ = { activeButton : null };

(function()
{
	var textBuilder = 
	{
		build : function( dialog, elementDefinition, output )
		{
			return new CKEDITOR.ui.dialog.textInput( dialog, elementDefinition, output );
		}
	},
	commonBuilder = 
	{
		build : function( dialog, elementDefinition, output )
		{
			return new CKEDITOR.ui.dialog[elementDefinition.type]( dialog, elementDefinition, output );
		}
	};

	CKEDITOR.dialog.addUIElement( 'text', textBuilder );
	CKEDITOR.dialog.addUIElement( 'password', textBuilder );
	CKEDITOR.dialog.addUIElement( 'checkbox', commonBuilder );
	CKEDITOR.dialog.addUIElement( 'radio', commonBuilder );
	CKEDITOR.dialog.addUIElement( 'button', commonBuilder );
	CKEDITOR.dialog.addUIElement( 'html', commonBuilder );
})();
