/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.requestcycle.impl;

import net.fckeditor.handlers.ConnectorHandler;
import net.fckeditor.requestcycle.ThreadLocalData;
import net.fckeditor.requestcycle.UserPathBuilder;

/**
 * This implementation always returns the context path with the UserFilesPath
 * from the properties file.
 * 
 * @version $Id: ContextPathBuilder.java 2584 2008-10-17 19:52:59Z mosipov $
 * 
 */
public class ContextPathBuilder implements UserPathBuilder {

	/* (non-Javadoc)
	 * @see net.fckeditor.requestcycle.UserPathBuilder#getUserFilesPath()
	 */
	public String getUserFilesPath() {
		String path = ThreadLocalData.getServletRequest().getContextPath().concat(ConnectorHandler.getDefaultUserFilesPath());
		return path;
	}
	
	/* (non-Javadoc)
	 * @see net.fckeditor.requestcycle.UserPathBuilder#getLocalUserFilesPath()
	 */
	public String getLocalUserFilesPath() {
		return ConnectorHandler.getDefaultUserFilesPath();
	}
}
