/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.connector;


import java.io.InputStream;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletContext;

import net.fckeditor.connector.exception.FolderAlreadyExistsException;
import net.fckeditor.connector.exception.InvalidCurrentFolderException;
import net.fckeditor.connector.exception.InvalidFolderNameException;
import net.fckeditor.connector.exception.SecurityIssueException;
import net.fckeditor.connector.exception.UnknownException;
import net.fckeditor.handlers.ResourceType;

/**
 * Interface for all Connectors.<br>
 * The Connector will be initialized by the {@link Dispatcher}. If an error is happened there are well-defined
 * exceptions which could be thrown. So the {@link Dispatcher} can react according to it.
 * <br><br>
 * Keep in mind that the {@link Dispatcher} verifies the request and redirects the relevant parameters
 * to the different methods of the connector and forwards the response to {@link ConnectorServlet}.
 * Therefore you don't need to check the basic parameters 'type' and 'currentFolder' against <code>null</code>.
 * 
 * @version $Id: Connector.java 2590 2008-10-19 12:37:12Z mosipov $
 */
public interface Connector {
	
	/**
	 * This key is to address a file's name in {@link #getFiles(ResourceType, String)} map.
	 */
	public final static String KEY_NAME  = "name";
	/**
	 * This key is to address a file's size in {@link #getFiles(ResourceType, String)} map.
	 */
	public final static String KEY_SIZE = "size";
	
	/**
	 * Initializes the connector. This method will be called on the start of the webapp.
	 * 
	 * @param servletContext eg. to get the real path of a file for example.
	 */
	public void init(final ServletContext servletContext);

	/**
	 * Returns a list of file attributes. which are inside the abstract path
	 * <code>/[type-folder]/[currentFolder]</code>.
	 * Filename, file size (in bytes).
	 * 
	 * @param type
	 * @param currentFolder
	 * @return A list of folder names.
	 * @throws InvalidCurrentFolderException
	 * @throws SecurityIssueException
	 * @throws UnknownException
	 */
	public List<Map<String, Object>> getFiles(final ResourceType type, final String currentFolder)
		throws InvalidCurrentFolderException, SecurityIssueException, UnknownException;
	
	/**
	 * Returns a list of folders which are inside the abstract path
	 * <code>/[type-folder]/[currentFolder]</code>.
	 * 
	 * @param type
	 * @param currentFolder
	 * @return A list of file names.
	 * @throws InvalidCurrentFolderException
	 * @throws SecurityIssueException
	 * @throws UnknownException
	 */
	public List<String> getFolders(final ResourceType type, final String currentFolder)
		throws InvalidCurrentFolderException, SecurityIssueException, UnknownException;
		
	/**
	 * Creates a new folder inside inside the abstract path
	 * <code>/[type-folder]/[currentFolder]</code>.
	 * 
	 * @param type
	 * @param currentFolder
	 * @param newFolder Name of the new folder to create.
	 * @throws InvalidCurrentFolderException
	 * @throws SecurityIssueException
	 * @throws InvalidFolderNameException
	 * @throws FolderAlreadyExistsException
	 */
	public void createFolder(final ResourceType type, final String currentFolder, final String newFolder) 
		throws InvalidCurrentFolderException, SecurityIssueException, InvalidFolderNameException, FolderAlreadyExistsException;

	/**
	 * Uploads a new file into the abstract path <code>/[type-folder]/[currentFolder]</code>. If there is 
	 * already a file with the same name, the new one has to be renamed.<br/>
	 * FileUpload and QuickUpload will be handled the same way since QuickUpload
	 * is just a specialization of FileUpload.
	 * 
	 * @param type
	 * @param currentFolder
	 * @param fileName
	 * @param inputStream Content of the file.
	 * @return <code>fileName</code> or the name of the renamed file.
	 * @throws InvalidCurrentFolderException
	 * @throws SecurityIssueException
	 */
	public String fileUpload(final ResourceType type, final String currentFolder, final String fileName, final InputStream inputStream)
		throws InvalidCurrentFolderException, SecurityIssueException;

}
