package net.fckeditor.requestcycle.impl;

import javax.servlet.http.HttpServletRequest;

import net.fckeditor.handlers.ConnectorHandler;
import net.fckeditor.requestcycle.UserPathBuilder;

/**
 * This implementation always returns the UserFilesPath from the properties file
 * absolute to the server root URL.
 * 
 * @version $Id$
 * 
 */
public class ServerRootPathBuilder implements UserPathBuilder {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * net.fckeditor.requestcycle.UserPathBuilder#getUserFilesAbsolutePath(javax
	 * .servlet.http.HttpServletRequest)
	 */
	public String getUserFilesAbsolutePath(HttpServletRequest request) {
		return ConnectorHandler.getUserFilesAbsolutePath();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * net.fckeditor.requestcycle.UserPathBuilder#getUserFilesPath(javax.servlet
	 * .http.HttpServletRequest)
	 */
	public String getUserFilesPath(HttpServletRequest request) {
		return ConnectorHandler.getUserFilesPath();
	}

}
