/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/** @fileoverview The "dialogui" plugin. */

CKEDITOR.plugins.add( 'dialogui' );

(function()
{
	var initPrivateObject = function( elementDefinition )
	{
		this._ || ( this._ = {} );
		if ( 'default' in elementDefinition )
			this._['default'] = elementDefinition['default'];
		var args = [ this._ ];
		for ( var i = 1 ; i < arguments.length ; i++ )
			args.push( arguments[i] );
		args.push( true );
		CKEDITOR.tools.extend.apply( CKEDITOR.tools, args );
		return this._;
	},
	textBuilder = 
	{
		build : function( dialog, elementDefinition, output )
		{
			return new CKEDITOR.ui.dialog.textInput( dialog, elementDefinition, output );
		}
	},
	commonBuilder = 
	{
		build : function( dialog, elementDefinition, output )
		{
			return new CKEDITOR.ui.dialog[elementDefinition.type]( dialog, elementDefinition, output );
		}
	},
	commonPrototype =
	{
		isChanged : function()
		{
			return this.getValue() != this._['default'];
		},

		reset: function()
		{
			this.setValue( this._['default'] );
		}
	};

	CKEDITOR.tools.extend( CKEDITOR.ui.dialog,
		/** @lends CKEDITOR.ui.dialog */
		{
			/**
			 * Base class for all dialog elements with a textual label on the left.
			 * @constructor
			 * @example
			 * @extends CKEDITOR.ui.dialog.uiElement
			 */
			labeledElement : function( dialog, elementDefinition, htmlList, contentHtml )
			{
				if ( arguments.length < 4 )
					return;

				initPrivateObject.call( this, elementDefinition );
				var children = this._.children = [];
				/** @ignore */
				var innerHTML = function()
				{
					var html = [ '<div class="cke_dialog_ui_labeled_label">',
							CKEDITOR.tools.htmlEncode( elementDefinition.label ),
							'</div>',
							'<div class="cke_dialog_ui_labeled_content">',
							contentHtml( dialog, elementDefinition ),
							'</div>'
						];
					return html.join( '' );
				};
				CKEDITOR.ui.dialog.uiElement.call( this, dialog, elementDefinition, htmlList, 'div', null, null, innerHTML );
			},

			/**
			 * A text input with a label.
			 * @constructor
			 * @example
			 * @extends CKEDITOR.ui.dialog.labeledElement
			 */
			textInput : function( dialog, elementDefinition, htmlList, stylesArg, attributesArg, contentsArg )
			{
				if ( arguments.length < 3 )
					return;

				initPrivateObject.call( this, elementDefinition );
				var attributes = ( attributesArg && attributesArg.call ? attributesArg( elementDefinition ) : attributesArg ) || {},
					id = this._.inputId = attributes.id || elementDefinition.id, 
					styles = ( stylesArg && stylesArg.call ? stylesArg( elementDefinition ) : stylesArg ) || {},
					inputContents = ( contentsArg && contentsArg.call ? contentsArg( dialog, elementDefinition) : contentsArg ) || '',
					i;

				// Set the default value.
				if ( !( 'default' in this._ ) )
					this._['default'] = '';

				// Set the id for the inner input element.
				if ( id )
				{
					id = this._.inputId = id + '_textInput';
					attributes.id = attributes.name = id;
				}

				// Set the type.
				attributes.type = elementDefinition.type;

				// Set the type and definition CSS class names.
				var classes = {};
				classes[ 'cke_dialog_ui_input_' + elementDefinition.type ] = 1;
				if ( elementDefinition.className )
					classes[ elementDefinition.className ] = 1;
				var attributeClasses = ( attributes['class'] && attributes['class'].split ) ? attributes['class'].split( ' ' ) : [];
				for ( i = 0 ; i < attributeClasses.length ; i++ )
				{
					if ( attributeClasses[i] )
						classes[ attributeClasses[i] ] = 1;
				}
				var finalClasses = [];
				for ( i in classes )
					finalClasses.push( i );
				attributes['class'] = finalClasses.join( ' ' );

				// Set the default value.
				if ( elementDefinition['default'] )
					attributes.value = elementDefinition['default'];

				// Write the inline CSS styles.
				var styleStr = [];
				for ( i in styles )
					styleStr.push( i + ':' + styles[i] );
				if ( styleStr.length > 0 )
					attributes.style = styleStr.join( '; ' );

				// Set the validator, if any.
				if ( elementDefinition.validate )
					this.validate = elementDefinition.validate;

				/** @ignore */
				var innerHTML = function()
				{
					var html = [ '<input ' ];
					for ( var i in attributes )
						html.push( i + '="' + attributes[i] + '" ' );
					html.push( '>', inputContents, '</input>' );
					return html.join( '' );
				};
				CKEDITOR.ui.dialog.labeledElement.call( this, dialog, elementDefinition, htmlList, innerHTML );
			},

			/**
			 * A single checkbox with a label on the right.
			 * @constructor
			 * @extends CKEDITOR.ui.dialog.uiElement
			 */
			checkbox : function( dialog, elementDefinition, htmlList )
			{
				if ( arguments.length < 3)
					return;

				var _ = initPrivateObject.call( this, elementDefinition, { 'default' : elementDefinition.checked || false }  );

				if ( elementDefinition.validate )
					this.validate = elementDefinition.validate();

				/** @ignore */
				var innerHTML = function()
				{
					var myDefinition = CKEDITOR.tools.extend( {}, elementDefinition,
							{
								id : elementDefinition.id ? elementDefinition.id + '_checkbox' : CKEDITOR.tools.getNextNumber() + '_checkbox',
								title : null,
								type : null
							}, true ),
						html = [],
						attributes = { 'class' : 'cke_dialog_ui_checkbox_input', type : 'checkbox' };
					if ( elementDefinition.checked )
						attributes.checked = 'checked';
					_.checkbox = new CKEDITOR.ui.dialog.uiElement( dialog, myDefinition, html, 'input', null, attributes );
					html.push( ' ', CKEDITOR.tools.htmlEncode( elementDefinition.label ) );
					return html.join( '' );
				};

				CKEDITOR.ui.dialog.uiElement.call( this, dialog, elementDefinition, htmlList, 'label', null, null, innerHTML );
			},

			/**
			 * A group of radio buttons.
			 * @constructor
			 * @example
			 * @extends CKEDITOR.ui.dialog.labeledElement
			 */
			radio : function( dialog, elementDefinition, htmlList )
			{
				if ( arguments.length < 3)
					return;

				initPrivateObject.call( this, elementDefinition );
				if ( !( 'default' in this._ ) )
					this._['default'] = elementDefinition.items[0][1] ;
				if ( elementDefinition.validate )
					this.validate = elementDefinition.valdiate;
				var children = [];

				/** @ignore */
				var innerHTML = function()
				{
					var inputHtmlList = [], html = [],
						commonAttributes = { 'class' : 'cke_dialog_ui_radio_item' },
						commonName = elementDefinition.id ? elementDefinition.id + '_radio' : CKEDITOR.tools.getNextNumber() + '_radio';
					for ( var i = 0 ; i < elementDefinition.items.length ; i++ )
					{
						var item = elementDefinition.items[i],
							inputDefinition = CKEDITOR.tools.extend( {}, elementDefinition,
									{
										id : CKEDITOR.tools.getNextNumber() + '_radio_input',
										title : null,
										type : null
									}, true ),
							labelDefinition = CKEDITOR.tools.extend( {}, inputDefinition,
									{
										id : null,
										title : item[2]
									}, true ),
							inputHtml = [],
							inputAttributes = 
							{
								type : 'radio',
								'class' : 'cke_dialog_ui_radio_input',
								name : commonName,
								value : item[1]
							};
						if ( elementDefinition['default'] == item[1] )
							inputAttributes.checked = 'checked';
						children.push( new CKEDITOR.ui.dialog.uiElement( dialog, inputDefinition, inputHtml, 'input', null, inputAttributes ) );
						new CKEDITOR.ui.dialog.uiElement( dialog, labelDefinition, inputHtmlList, 'label', null, null,
							   inputHtml.join( '' ) + ' ' + item[0] );
					}
					new CKEDITOR.ui.dialog.hbox( dialog, [], inputHtmlList, html );
					return html.join( '' );
				};

				CKEDITOR.ui.dialog.labeledElement.call( this, dialog, elementDefinition, htmlList, innerHTML );
				this._.children = children;
			},

			/**
			 * A button with a label inside.
			 * @constructor
			 * @example
			 * @extends CKEDITOR.ui.dialog.uiElement
			 */
			button : function( dialog, elementDefinition, htmlList )
			{
				if ( arguments.length < 3)
					return;

				initPrivateObject.call( this, elementDefinition, { disabled : elementDefinition.disabled || false } );

				/** @ignore */
				var innerHTML = function()
				{
					return [ '<tbody><tr><td class="cke_dialog_ui_button_txt">',
						   CKEDITOR.tools.htmlEncode( elementDefinition.label ),
						   '</td></tr></tbody>' ].join( '' );
				};

				// Add OnClick event to this input.
				CKEDITOR.event.implementOn( this );

				// Register an event handler for processing button clicks.
				var me = this;
				dialog.on( 'load', function( eventInfo )
						{
							var element = this.getElement();
							element.on( 'mousedown', function( evt )
								{
									// If button is disabled, don't do anything.
									if ( me._.disabled )
										return;

									// Change styles to indicate the button is being clicked.
									me.getElement().addClass( 'active' );

									// Store the currently active button.
									CKEDITOR.ui.dialog.button._.activeButton = [ me, me.getElement() ];
								});

							// IE BUG: Padding attributes are ignored for <td> cells.
							if ( CKEDITOR.env.ie )
								element.getChild( [0, 0, 0] ).$.innerHTML += '';

							if ( !eventInfo.data.buttonHandlerRegistered )
							{
								CKEDITOR.document.on( 'mouseup', function( evt )
									{
										var target = evt.data.getTarget();

										// If there's no active button, bail out.
										if ( !CKEDITOR.ui.dialog.button._.activeButton )
											return;

										// Change styles to remove active status.
										CKEDITOR.ui.dialog.button._.activeButton[1].removeClass( 'active' );

										// Fire the click event - but only if the
										// active button is the same as target.
										if ( CKEDITOR.ui.dialog.button._.activeButton[1].equals( target.getAscendant( 'table' ) ) )
											CKEDITOR.ui.dialog.button._.activeButton[0].fire( 'click', { dialog : dialog } );

										// Clear active button flag.
										CKEDITOR.ui.dialog.button._.activeButton = null;
									});

								eventInfo.data.buttonHandlerRegistered = true;
							}

							this.getElement().unselectable();
						}, this );

				CKEDITOR.ui.dialog.uiElement.call( this, dialog, elementDefinition, htmlList, 'table', null, null, innerHTML );
			},

			/**
			 * A dialog element made from raw HTML code.
			 * @extends CKEDITOR.ui.dialog.uiElement
			 * @example
			 * @constructor
			 */
			html : (function()
			{
				var myHtmlRe = /^\s*<[\w:]+\s+([^>]*)?>/,
					theirHtmlRe = /^(\s*<[\w:]+(?:\s+[^>]*)?)((?:.|\r|\n)+)$/,
					emptyTagRe = /\/$/;
				return function( dialog, elementDefinition, htmlList )
				{
					if ( arguments.length < 3 )
						return;

					var myHtmlList = [],
						myHtml,
						theirHtml = elementDefinition.html,
						myMatch, theirMatch;
					CKEDITOR.ui.dialog.uiElement.call( this, dialog, elementDefinition, myHtmlList, 'span', null, null, '' );

					// Append the attributes created by the uiElement call to the real HTML.
					myHtml = myHtmlList.join( '' );
					myMatch = myHtml.match( myHtmlRe );
					theirMatch = theirHtml.match( theirHtmlRe ) || [ '', '', '' ];

					if ( emptyTagRe.test( theirMatch[1] ) )
					{
						theirMatch[1] = theirMatch[1].slice( 0, -1 );
						theirMatch[2] = '/' + theirMatch[2];
					}

					htmlList.push( [ theirMatch[1], ' ', myMatch[1] || '', theirMatch[2] ].join( '' ) );
				}
			})()
		}, true );

	CKEDITOR.ui.dialog.labeledElement.prototype
		= CKEDITOR.ui.dialog.html.prototype = new CKEDITOR.ui.dialog.uiElement;

	CKEDITOR.ui.dialog.button.prototype = CKEDITOR.tools.extend( new CKEDITOR.ui.dialog.uiElement,
			/** @lends CKEDITOR.ui.dialog.button.prototype */
			{
				/**
				 * Simulates a click to the button.
				 * @example
				 * @returns {Object} Return value of the 'click' event.
				 */
				click : function()
				{
					if ( !this._.disabled )
						return this.fire( 'click', { dialog : this._.dialog } );
				},

				/**
				 * Enables the button.
				 * @example
				 */
				enable : function()
				{
					this._.disabled = false;
					this.getElement().removeClass( 'disabled' );
				},

				/**
				 * Disables the button.
				 * @example
				 */
				disable : function()
				{
					this._.disabled = true;
					this.getElement().addClass( 'disabled' );
				},

				eventProcessors : CKEDITOR.tools.extend( {}, CKEDITOR.ui.dialog.uiElement.prototype.eventProcessors,
					{
						onClick : function( dialog, func )
						{
							this.on( 'click', func );
						}
					}, true )
			}, true );

	CKEDITOR.ui.dialog.textInput.prototype = CKEDITOR.tools.extend( new CKEDITOR.ui.dialog.labeledElement,
			/** @lends CKEDITOR.ui.dialog.textInput.prototype */
			{
				/**
				 * Gets the text input DOM element under this UI object.
				 * @example
				 * @returns {CKEDITOR.dom.element} The DOM element of the text input.
				 */
				getElement : function()
				{
					return CKEDITOR.document.getById( this._.inputId );
				},

				/**
				 * Selects all the text in the text input.
				 * @example
				 */
				select : function()
				{
					this.focus();
					this.getElement().$.select();
				}
			}, commonPrototype, true );

	CKEDITOR.ui.dialog.checkbox.prototype = CKEDITOR.tools.extend( new CKEDITOR.ui.dialog.uiElement,
			/** @lends CKEDITOR.ui.dialog.checkbox.prototype */
			{
				/**
				 * Gets the checkbox DOM element.
				 * @example
				 * @returns {CKEDITOR.dom.element} The DOM element of the checkbox.
				 */
				getElement : function()
				{
					return this._.checkbox.getElement();
				},

				/**
				 * Sets the state of the checkbox.
				 * @example
				 * @param {Boolean} true to tick the checkbox, false to untick it.
				 */
				setValue : function( checked )
				{
					this.getElement().$.checked = checked;
				},

				/**
				 * Gets the state of the checkbox.
				 * @example
				 * @returns {Boolean} true means the checkbox is ticked, false means it's not ticked.
				 */
				getValue : function()
				{
					return this.getElement().$.checked;
				}
			}, commonPrototype, true );

	CKEDITOR.ui.dialog.radio.prototype = CKEDITOR.tools.extend( new CKEDITOR.ui.dialog.uiElement,
			/** @lends CKEDITOR.ui.dialog.radio.prototype */
			{
				/**
				 * Checks one of the radio buttons in this button group.
				 * @example
				 * @param {String} value The value of the button to be chcked.
				 */
				setValue : function( value )
				{
					var children = this._.children,
						item;
					for ( var i = 0 ; ( i < children.length ) && ( item = children[i] ) ; i++ )
					{
						item.getElement().$.checked = ( item.getValue() == value );
					}
				},

				/**
				 * Gets the value of the currently checked radio button.
				 * @example
				 * @returns {String} The currently checked button's value.
				 */
				getValue : function()
				{
					var children = this._.children;
					for ( var i = 0 ; i < children.length ; i++ )
					{
						if ( children[i].getElement().$.checked )
							return children[i].getValue();
					}
					return null;
				}
			}, commonPrototype, true );

	CKEDITOR.ui.dialog.button._ = { activeButton : null };

	CKEDITOR.dialog.addUIElement( 'text', textBuilder );
	CKEDITOR.dialog.addUIElement( 'password', textBuilder );
	CKEDITOR.dialog.addUIElement( 'checkbox', commonBuilder );
	CKEDITOR.dialog.addUIElement( 'radio', commonBuilder );
	CKEDITOR.dialog.addUIElement( 'button', commonBuilder );
	CKEDITOR.dialog.addUIElement( 'html', commonBuilder );
})();
