﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview Defines the {@link CKEDITOR.plugins} object, which is used to
 *		manage plugins registration and loading.
 */

/**
 * Manages plugins registration and loading.
 * @namespace
 * @augments CKEDITOR.resourceManager
 * @example
 */
CKEDITOR.plugins = new CKEDITOR.resourceManager(
	'_source/' +	// TODO: Set @-Packager.RemoveLine
	'plugins/', 'plugin' );

CKEDITOR.plugins.load = CKEDITOR.tools.override( CKEDITOR.plugins.load, function( originalLoad )
	{
		return function( name, callback, scope )
		{
			var allPlugins = {};

			var loadPlugins = function( names )
			{
				originalLoad.call( this, names, function( plugins )
					{
						CKEDITOR.tools.extend( allPlugins, plugins );

						var requiredPlugins = [];
						for ( var pluginName in plugins )
						{
							var plugin = plugins[ pluginName ],
								requires = plugin && plugin.requires;

							if ( requires )
							{
								for ( var i = 0 ; i < requires.length ; i++ )
								{
									if ( !allPlugins[ requires[ i ] ] )
										requiredPlugins.push( requires[ i ] );
								}
							}
						}

						if ( requiredPlugins.length )
							loadPlugins.call( this, requiredPlugins );
						else if ( callback )
							callback.call( scope || window, allPlugins );
					}
					, this);

			};

			loadPlugins.call( this, name );
		};
	});

CKEDITOR.plugins.setLang = function( pluginName, languageCode, languageEntries )
{
	var plugin = this.get( pluginName );
	plugin.lang[ languageCode ] = languageEntries;
};
