﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview Defines the {@link CKEDITOR.config} object, which holds the
 * default configuration settings.
 */

/**
 * Holds the default configuration settings. Changes to this object are
 * reflected in all editor instances, if not specificaly specified for those
 * instances.
 * @namespace
 * @example
 * // All editor created after the following setting will not load custom
 * // configuration files.
 * CKEDITOR.config.customConfig = '';
 */
CKEDITOR.config =
{
	/**
	 * The URL path for the custom configuration file to be loaded. If not
	 * overloaded with inline configurations, it defaults to the "config.js"
	 * file present in the root of the CKEditor installation directory.<br /><br />
	 *
	 * CKEditor will recursively load custom configuration files defined inside
	 * other custom configuration files.
	 * @type String
	 * @default '&lt;CKEditor folder&gt;/config.js'
	 * @example
	 * // Load a specific configuration file.
	 * CKEDITOR.replace( 'myfiled', { customConfig : '/myconfig.js' } );
	 * @example
	 * // Do not load any custom configuration file.
	 * CKEDITOR.replace( 'myfiled', { customConfig : '' } );
	 */
	customConfig : CKEDITOR.getUrl( 'config.js' ),

	/**
	 * The base href URL used to resolve relative and absolute URLs in the
	 * editor content.
	 * @type String
	 * @default '' (empty string)
	 * @example
	 * config.baseHref = 'http://www.example.com/path/';
	 */
	baseHref : '',

	/**
	 * The CSS file to be used to apply style to the contents. It should
	 * reflect the CSS used in the final pages where the contents are to be
	 * used.
	 * @type String
	 * @default '&lt;CKEditor folder&gt;/contents.css'
	 * @example
	 * config.contentsCss = '/css/mysitestyles.css';
	 */
	contentsCss : CKEDITOR.basePath + 'contents.css',

	/**
	 * The writting direction of the language used to write the editor
	 * contents. Allowed values are 'ltr' for Left-To-Right language (like
	 * English), or 'rtl' for Right-To-Left languages (like Arabic).
	 * @default 'ltr'
	 * @type String
	 * @example
	 * config.contentsLangDirection = 'rtl';
	 */
	contentsLangDirection : 'ltr',

	/**
	 * Instructs the editor to automatically localize the editor to the user
	 * language, if possible. If set to false, the [@link #defaultLanguage]
	 * language is used.
	 * @default true
	 * @type Boolean
	 * @example
	 * // Forces the editor to always load the German interface.
	 * config.autoLanguage = false;
	 * config.defaultLanguage = 'de';
	 */
	autoLanguage : true,

	/**
	 * The language to be used if [@link #autoLanguage] is set to false, or
	 * when it's not possible to localize the editor to the user language.
	 * @default 'en'
	 * @type String
	 * @example
	 * config.defaultLanguage = 'it';
	 */
	defaultLanguage : 'en',

	/**
	 * A comma separated list of plugins that are not related to editor
	 * instances. Reserved to plugins that extend the core code only.<br /><br />
	 *
	 * There are no ways to override this setting, except by editing the source
	 * code of CKEditor (_source/core/config.js).
	 * @type String
	 * @example
	 */
	corePlugins : '',

	/**
	 * Sets the doctype to be used when loading the editor content as HTML.
	 * @type String
	 * @default '&lt;!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"&gt;'
	 * @example
	 * // Set the doctype to the HTML 4 (quirks) mode.
	 * config.docType = '&lt;!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"&gt;';
	 */
	docType : '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">',

	/**
	 * Indicates whether the contents to be edited are being inputted as a full
	 * HTML page. A full page includes the &lt;html&gt;, &lt;head&gt; and
	 * &lt;body&gt; tags. The final output will also reflect this setting,
	 * including the &lt;body&gt; contents only if this setting is disabled.
	 * @type Boolean
	 * @default false
	 * @example
	 * config.fullPage = true;
	 */
	fullPage : false,

	/**
	 * The editor height, in CSS size format or pixel integer.
	 * @type String|Number
	 * @default '200'
	 * @example
	 */
	height : 200,

	/**
	 * Comma separated list of plugins to load and initialize for an editor
	 * instance.
	 * @type String
	 * @default 'editingblock,elementspath,sourcearea,toolbar,wysiwygarea'
	 * @example
	 * config.plugins = 'elementspath,toolbar,wysiwygarea';
	 */
	plugins : 'basicstyles,button,dialog,elementspath,horizontalrule,htmldataprocessor,keystrokes,removeformat,smiley,sourcearea,tab,toolbar,wysiwygarea',

	/**
	 * The theme to be used to build the UI.
	 * @type String
	 * @default 'default'
	 * @see CKEDITOR.config.skin
	 * @example
	 * config.theme = 'default';
	 */
	theme : 'default',

	/**
	 * The skin to load.
	 * @type String
	 * @default 'default'
	 * @example
	 * config.skin = 'v2';
	 */
	skin : 'default',

	/**
	 * The editor width in CSS size format or pixel integer.
	 * @type String|Number
	 * @default '100%'
	 * @example
	 */
	width : '100%',

	/**
	 * The base Z-index for floating dialogs and popups.
	 * @type Number
	 * @default 10000
	 * @example
	 * config.basePopupZIndex = 2000
	 */
	basePopupZIndex : 10000,

	/**
	 * The color of the dialog background cover. It should be a valid CSS color string.
	 * @type String
	 * @default white
	 * @example
	 * config.backgroundCoverColor = 'rgb(255, 254, 253)';
	 */
	backgroundCoverColor : 'white',

	/**
	 * The opacity of the dialog background cover. It should be a number within the range [0.0, 1.0].
	 * @type Number
	 * @default 0.5
	 * @example
	 * config.backgroundCoverOpacity = 0.7;
	 */
	backgroundCoverOpacity : 0.5,

	/**
	 * The distance of magnetic borders used in moving and resizing dialogs, measured in pixels.
	 * @type Number
	 * @default 20
	 * @example
	 * config.magnetic = 30;
	 */
	magnetDistance : 20,

	/**
	 * List of smiley images displayed in the Smiley dialog.
	 * @type Array
	 * @default ['regular_smile.gif','sad_smile.gif','wink_smile.gif','teeth_smile.gif','confused_smile.gif','tounge_smile.gif','embaressed_smile.gif','omg_smile.gif','whatchutalkingabout_smile.gif','angry_smile.gif','angel_smile.gif','shades_smile.gif','devil_smile.gif','cry_smile.gif','lightbulb.gif','thumbs_down.gif','thumbs_up.gif','heart.gif','broken_heart.gif','kiss.gif','envelope.gif']
	 * @example
	 * config.smileyImages = [ 'tounge.gif', 'smile.gif', 'laugh.gif' ];
	 */
	smileyImages : ['regular_smile.gif','sad_smile.gif','wink_smile.gif','teeth_smile.gif','confused_smile.gif','tounge_smile.gif','embaressed_smile.gif','omg_smile.gif','whatchutalkingabout_smile.gif','angry_smile.gif','angel_smile.gif','shades_smile.gif','devil_smile.gif','cry_smile.gif','lightbulb.gif','thumbs_down.gif','thumbs_up.gif','heart.gif','broken_heart.gif','kiss.gif','envelope.gif'],

	smileyPath : CKEDITOR.basePath +  '_source/plugins/smiley/images/',

	smileyWindowWidth : 320,

	smileyWindowHeight : 210,

	smileyColumns : 8
};
