/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.devutil.dtd;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.fckeditor.devutil.dtd.ElementGroup;
import net.fckeditor.devutil.dtd.ElementGroupMapJavascriptBuilder;
import net.fckeditor.devutil.dtd.ElementGroupSizeComparator;

public class DTDJsGenerator {
    private static final String APPLICATION_NAME = "FCKdtd2js";
    protected File _dtdFile;
    protected Set _removeTags;

    public static void main(String[] stringArray) {
        Object object;
        File file;
        if (stringArray.length < 1) {
            DTDJsGenerator.writeHelp(System.out);
        }
        if (!(file = new File(stringArray[0])).exists()) {
            System.err.println("Unable to locate DTD file [" + file.getPath() + "]");
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray.length > 1) {
            object = new StringTokenizer(stringArray[1], ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken().trim();
                if (string.length() <= 0) continue;
                hashSet.add(string);
            }
        }
        try {
            object = new DTDJsGenerator(file, hashSet);
            ((DTDJsGenerator)object).run();
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace(System.err);
        }
    }

    protected static void writeHelp(PrintStream printStream) {
        printStream.println("FCKdtd2js: Simple utility to create a JavaScript from a given DTD.\n");
        printStream.println("Usage: java -jar FCKdtd2js.jar <dtdfile> <ignoretag,...>]");
        printStream.println("  dtdfile - The path/URL to the DTD file to parse.");
        printStream.println("  ignoretag - Comma separated list of tags to ignore in DTD");
        System.exit(0);
    }

    public DTDJsGenerator(File file, Set set) {
        if (file == null || set == null) {
            throw new IllegalArgumentException("File parameter cannot be null.");
        }
        this._dtdFile = file;
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        this._removeTags = set;
    }

    public void run() throws IOException {
        DTDParser dTDParser = new DTDParser(this._dtdFile);
        DTD dTD = dTDParser.parse();
        Map<String, ElementGroup> map = this.createElementGroupMap(dTD);
        if (this._removeTags != null) {
            map.keySet().removeAll(this._removeTags);
        }
        this.compressElementGroupMap(map);
        this.flattenElementGroupMap(map);
        String string = "This file was automatically generated from the file: " + this._dtdFile.getName();
        ElementGroupMapJavascriptBuilder elementGroupMapJavascriptBuilder = new ElementGroupMapJavascriptBuilder();
        String string2 = elementGroupMapJavascriptBuilder.buildJavaScript(string, map);
        System.out.println(string2);
    }

    protected void printGroupMap(Map<String, ElementGroup> map) {
        for (String string : map.keySet()) {
            ElementGroup elementGroup = map.get(string);
            System.out.println("Element [" + string + "]:");
            System.out.println(elementGroup.toString() + "\n");
        }
    }

    protected void flattenElementGroupMap(Map<String, ElementGroup> map) {
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            this.internalRecursiveFlattenElementGroupMap(map.get(iterator.next()));
        }
    }

    private void internalRecursiveFlattenElementGroupMap(ElementGroup elementGroup) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = elementGroup.getSubGroups().iterator();
        while (iterator.hasNext()) {
            ElementGroup elementGroup2 = iterator.next();
            this.internalRecursiveFlattenElementGroupMap(elementGroup2);
            if (elementGroup2.size() != 0) continue;
            linkedList.addAll(elementGroup2.getSubGroups());
            iterator.remove();
        }
        elementGroup.getSubGroups().addAll(linkedList);
    }

    protected void compressElementGroupMap(Map<String, ElementGroup> map) {
        ElementGroup elementGroup;
        for (String iterator : map.keySet()) {
            for (String string : map.keySet()) {
                ElementGroup elementGroup2;
                elementGroup = map.get(iterator);
                if (elementGroup == (elementGroup2 = map.get(string)) || !elementGroup.equals(elementGroup2)) continue;
                map.put(string, elementGroup);
            }
        }
        TreeSet<ElementGroup> treeSet = new TreeSet<ElementGroup>(new ElementGroupSizeComparator());
        treeSet.addAll(map.values());
        block2: while (treeSet.size() > 0) {
            Iterator iterator = treeSet.iterator();
            ElementGroup elementGroup3 = (ElementGroup)iterator.next();
            if (elementGroup3.size() > 2) {
                while (iterator.hasNext()) {
                    ElementGroup elementGroup4 = (ElementGroup)iterator.next();
                    elementGroup = elementGroup3.intersectGroup(elementGroup4);
                    if (elementGroup.size() < 2) continue;
                    iterator.remove();
                    treeSet.remove(treeSet.first());
                    elementGroup3.addSubGroup(elementGroup);
                    elementGroup4.addSubGroup(elementGroup);
                    treeSet.add(elementGroup3);
                    treeSet.add(elementGroup4);
                    treeSet.add(elementGroup);
                    continue block2;
                }
            }
            treeSet.remove(treeSet.first());
        }
    }

    protected Map<String, ElementGroup> createElementGroupMap(DTD dTD) {
        ElementGroup elementGroup = new ElementGroup();
        HashMap<String, ElementGroup> hashMap = new HashMap<String, ElementGroup>();
        Collection collection = dTD.elements.values();
        for (DTDElement dTDElement : collection) {
            if (dTDElement.content instanceof DTDContainer) {
                ElementGroup<String> elementGroup2 = new ElementGroup<String>();
                if (!this.appendAllowedElementsRecursive((DTDContainer)dTDElement.content, elementGroup2)) continue;
                hashMap.put(dTDElement.name, elementGroup2);
                continue;
            }
            if (!(dTDElement.content instanceof DTDEmpty)) continue;
            hashMap.put(dTDElement.name, elementGroup);
        }
        return hashMap;
    }

    protected boolean appendAllowedElementsRecursive(DTDContainer dTDContainer, ElementGroup<String> elementGroup) {
        DTDItem[] dTDItemArray = dTDContainer.getItems();
        boolean bl = false;
        for (int i = 0; i < dTDItemArray.length; ++i) {
            if (dTDItemArray[i] instanceof DTDName) {
                elementGroup.add(((DTDName)dTDItemArray[i]).value);
                bl = true;
                continue;
            }
            if (dTDItemArray[i] instanceof DTDContainer) {
                boolean bl2 = this.appendAllowedElementsRecursive((DTDContainer)dTDItemArray[i], elementGroup);
                bl = bl || bl2;
                continue;
            }
            if (dTDItemArray[i] instanceof DTDPCData) {
                elementGroup.add("#");
                bl = true;
                continue;
            }
            if (!(dTDItemArray[i] instanceof DTDEmpty)) continue;
            bl = true;
        }
        return bl;
    }
}

