/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.devutil.dtd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.fckeditor.devutil.dtd.ElementGroup;

public class ElementGroupMapJavascriptBuilder {
    private static final String DTDMAP_NAME = "FCK.DTD";
    private static final String MERGE_FUNCTION = "X";
    private static final String MERGE_FUNCTION_DEF = "X = FCKTools.Merge ;";
    private static final String REFERENCE_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWYZ";
    private int _varCount;
    private Map<ElementGroup, String> _subGroupAliasMap;

    public String buildJavaScript(String string, Map<String, ElementGroup> map) {
        this._varCount = 0;
        this._subGroupAliasMap = new HashMap<ElementGroup, String>();
        StringBuilder stringBuilder = new StringBuilder();
        this.appendHeader(stringBuilder, string);
        this.appendElementMapFunctionCode(stringBuilder, map);
        return stringBuilder.toString();
    }

    protected void appendHeader(StringBuilder stringBuilder, String string) {
        stringBuilder.append("/*\n");
        stringBuilder.append(" * FCKeditor - The text editor for Internet - http://www.fckeditor.net\n");
        stringBuilder.append(" * Copyright (C) 2003-2007 Frederico Caldeira Knabben\n");
        stringBuilder.append(" *\n");
        stringBuilder.append(" * == BEGIN LICENSE ==\n");
        stringBuilder.append(" *\n");
        stringBuilder.append(" * Licensed under the terms of any of the following licenses at your\n");
        stringBuilder.append(" * choice:\n");
        stringBuilder.append(" *\n");
        stringBuilder.append(" *  - GNU General Public License Version 2 or later (the \"GPL\")\n");
        stringBuilder.append(" *    http://www.gnu.org/licenses/gpl.html\n");
        stringBuilder.append(" *\n");
        stringBuilder.append(" *  - GNU Lesser General Public License Version 2.1 or later (the \"LGPL\")\n");
        stringBuilder.append(" *    http://www.gnu.org/licenses/lgpl.html\n");
        stringBuilder.append(" *\n");
        stringBuilder.append(" *  - Mozilla Public License Version 1.1 or later (the \"MPL\")\n");
        stringBuilder.append(" *    http://www.mozilla.org/MPL/MPL-1.1.html\n");
        stringBuilder.append(" *\n");
        stringBuilder.append(" * == END LICENSE ==\n");
        stringBuilder.append(" *\n");
        stringBuilder.append(" * Contains the DTD mapping for <DTD_NAME>.\n");
        stringBuilder.append(" * ").append(string);
        stringBuilder.append("\n */\n");
    }

    protected void appendElementMapFunctionCode(StringBuilder stringBuilder, Map<String, ElementGroup> map) {
        StringBuilder stringBuilder2 = new StringBuilder();
        HashMap<ElementGroup, Integer> hashMap = new HashMap<ElementGroup, Integer>();
        for (String object2 : map.keySet()) {
            ElementGroup elementGroup = map.get(object2);
            this.appendMissingSubGroupsRecursive(stringBuilder2, elementGroup);
            if (!hashMap.containsKey(elementGroup)) {
                hashMap.put(elementGroup, 1);
                continue;
            }
            hashMap.put(elementGroup, (Integer)hashMap.get(elementGroup) + 1);
        }
        stringBuilder2.append("\n");
        for (ElementGroup elementGroup : hashMap.keySet()) {
            int n;
            int n2;
            int n3;
            int n4 = elementGroup.getSubGroups().size() * 2 + 4;
            if (elementGroup.size() > 0) {
                for (String string : elementGroup) {
                    n4 += string.length() + 3;
                }
                n4 += 2;
            }
            if (n4 == 4 || (n3 = (n2 = ((Integer)hashMap.get(elementGroup)).intValue()) * 2 + n4 + 2) >= (n = n2 * n4)) continue;
            this.appendGroupReference(stringBuilder2, elementGroup);
        }
        stringBuilder2.append("\n");
        stringBuilder2.append("    return {\n");
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            ElementGroup elementGroup = map.get(string);
            stringBuilder2.append("        ");
            this.appendEscapedJsMapKey(stringBuilder2, string);
            stringBuilder2.append(": ");
            this.appendGroupMapContent(stringBuilder2, elementGroup);
            if (iterator.hasNext()) {
                stringBuilder2.append(", ");
            }
            stringBuilder2.append("\n");
        }
        stringBuilder2.append("    } ;\n");
        stringBuilder.append(DTDMAP_NAME).append(" = (function()\n{\n    ");
        stringBuilder.append(MERGE_FUNCTION_DEF).append("\n\n    var ");
        iterator = this._subGroupAliasMap.values().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuilder.append(string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append("; \n");
        stringBuilder.append((CharSequence)stringBuilder2).append("})() ;");
    }

    protected void appendMissingSubGroupsRecursive(StringBuilder stringBuilder, ElementGroup elementGroup) {
        Set set = elementGroup.getSubGroups();
        if (set.size() == 0 && elementGroup.size() == 0) {
            return;
        }
        if (set.size() > 0) {
            for (ElementGroup elementGroup2 : set) {
                if (this._subGroupAliasMap.containsKey(elementGroup2)) continue;
                this.appendMissingSubGroupsRecursive(stringBuilder, elementGroup2);
                this.appendGroupReference(stringBuilder, elementGroup2);
            }
        }
    }

    protected void appendGroupReference(StringBuilder stringBuilder, ElementGroup elementGroup) {
        String string = this.createNextGroupAlias();
        stringBuilder.append("    ").append(string).append(" = ");
        this.appendGroupMapContent(stringBuilder, elementGroup);
        stringBuilder.append(" ;\n");
        this._subGroupAliasMap.put(elementGroup, string);
    }

    protected String createNextGroupAlias() {
        int n = REFERENCE_ALPHABET.length();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this._varCount + n;
        do {
            stringBuilder.append(REFERENCE_ALPHABET.charAt(n2 % n));
        } while ((n2 /= n) > 1);
        ++this._varCount;
        return stringBuilder.reverse().toString();
    }

    protected void appendGroupMapContent(StringBuilder stringBuilder, ElementGroup elementGroup) {
        Object object;
        Iterator<Object> iterator;
        if (this._subGroupAliasMap.containsKey(elementGroup)) {
            stringBuilder.append(this._subGroupAliasMap.get(elementGroup));
            return;
        }
        Set set = elementGroup.getSubGroups();
        if ((elementGroup.size() > 0 ? 1 : 0) + set.size() > 1) {
            stringBuilder.append("X(");
        }
        if (elementGroup.size() > 0 || set.size() == 0) {
            stringBuilder.append("{");
            iterator = elementGroup.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                this.appendEscapedJsMapKey(stringBuilder, (String)object);
                stringBuilder.append(":1");
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("}");
        }
        if (set.size() == 0) {
            return;
        }
        if (elementGroup.size() > 0) {
            stringBuilder.append(", ");
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (ElementGroup)iterator.next();
            stringBuilder.append(this._subGroupAliasMap.get(object));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        if (set.size() + elementGroup.size() > 1) {
            stringBuilder.append(")");
        }
    }

    protected void appendEscapedJsMapKey(StringBuilder stringBuilder, String string) {
        if ("#".equals(string) || "var".equals(string)) {
            stringBuilder.append('\'').append(string).append('\'');
        } else {
            stringBuilder.append(string);
        }
    }
}

