/* 
 * FCKdtd2js - FCKeditor JavaScript DTD map generator - http://www.fckeditor.net 
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben 
 * 
 * == BEGIN LICENSE == 
 * 
 * Licensed under the terms of any of the following licenses at your 
 * choice: 
 * 
 *  - GNU General Public License Version 2 or later (the "GPL") 
 *    http://www.gnu.org/licenses/gpl.html 
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL") 
 *    http://www.gnu.org/licenses/lgpl.html 
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL") 
 *    http://www.mozilla.org/MPL/MPL-1.1.html 
 * 
 * == END LICENSE == 
 */ 

package net.fckeditor.devutil.dtd;

import java.util.Comparator;

/**
 * Compares two given element groups based on their size. 
 */
public class ElementGroupSizeComparator implements Comparator<ElementGroup> {

	/**
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(ElementGroup o1, ElementGroup o2) {
		// Check different size first.
		if(o1.size() != o2.size()) {
			return o1.size() > o2.size()?-1:1; 
		}
		// If the size is equal, the comparence is more tricky. We can 
		// only return 0 if the groups contains the same object.
		if(o1.equals(o2)) return 0;
		
		// Comparing the identity hash codes does not make any comparence sence,
		// but the result is consistient.
		return System.identityHashCode(o1) > System.identityHashCode(o2)?-1:1;
	}

}
