/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'forms',
{
	init : function( editor )
	{
		var forms = CKEDITOR.plugins.forms;
		editor.ui.addButton( 'Form',
			{
				label : editor.lang.form,
				command : 'form'
			});
		editor.addCommand( 'form', new CKEDITOR.dialogCommand( 'form' ) );

		editor.ui.addButton( 'Checkbox',
			{
				label : editor.lang.checkbox,
				command : 'checkbox'
			});
		editor.addCommand( 'checkbox', new CKEDITOR.dialogCommand( 'checkbox' ) );

		editor.ui.addButton( 'Radio',
			{
				label : editor.lang.radio,
				command : 'radio'
			});
		editor.addCommand( 'radio', new CKEDITOR.dialogCommand( 'radio' ) );

		editor.ui.addButton( 'TextField',
			{
				label : editor.lang.textField,
				command : 'textfield'
			});
		editor.addCommand( 'textfield', new CKEDITOR.dialogCommand( 'textfield' ) );

		editor.ui.addButton( 'Select',
			{
				label : editor.lang.select,
				command : 'select'
			});
		editor.addCommand( 'select', new CKEDITOR.dialogCommand( 'select' ) );

		editor.ui.addButton( 'Button',
			{
				label : editor.lang.button,
				command : 'button'
			});
		editor.addCommand( 'button', new CKEDITOR.dialogCommand( 'button' ) );

		editor.ui.addButton( 'ImageButton',
			{
				label : editor.lang.imageButton,
				command : 'imagebutton'
			});
		editor.addCommand( 'imagebutton', new CKEDITOR.dialogCommand( 'imagebutton' ) );

		editor.ui.addButton( 'HiddenField',
			{
				label : editor.lang.hiddenField,
				command : 'hiddenfield'
			});
		editor.addCommand( 'hiddenfield', new CKEDITOR.dialogCommand( 'hiddenfield' ) );

		CKEDITOR.dialog.add( 'form',		this.path + 'dialogs/form.js' );
		CKEDITOR.dialog.add( 'checkbox',	this.path + 'dialogs/checkbox.js' );
		CKEDITOR.dialog.add( 'radio', 		this.path + 'dialogs/radio.js' );
		CKEDITOR.dialog.add( 'textfield',	this.path + 'dialogs/textfield.js' );
		CKEDITOR.dialog.add( 'select',		this.path + 'dialogs/select.js' );
		CKEDITOR.dialog.add( 'button',		this.path + 'dialogs/button.js' );
		CKEDITOR.dialog.add( 'hiddenfield',	this.path + 'dialogs/hiddenfield.js' );
		CKEDITOR.dialog.add( 'imagebutton',	CKEDITOR.plugins.getPath('image') + 'dialogs/image.js' );
	},
	requires : [ 'image' ]
} );
