CKEDITOR.dialog.add( 'testOnly', function( editor )
		{
			return {
				title : 'Test Dialog',
				resizable : CKEDITOR.DIALOG_RESIZE_BOTH,
				buttons : [ 
					CKEDITOR.dialog.okButton.override( { label : 'Apply' } ),
					CKEDITOR.dialog.cancelButton.override( { label : 'Close' } )
					],
				minWidth : 500,
				minHeight : 400,
				contents : [
					{
						id : 'tab1',
						label : 'First Tab',
						title : 'First Tab Title',
						accessKey : 'Q',
						elements : [
							{
								type : 'text',
								label : 'Test Text 1',
								id : 'testText1',
								'default' : 'hello world!',
								accessKey : 'R'
							},

							{
								type : 'text',
								label : 'Test Text 2',
								id : 'testText2',
								'default' : 'Wheee'
							},

							{
								type : 'text',
								label : 'Test Text 3',
								id : 'testText3',
								'default' : 'Blah blah'
							}
						]
					},

					{
						id : 'tab2',
						label : 'Second Tab',
						title : 'Second Tab Title',
						accessKey : 'W',
						elements : [
							{
								type : 'hbox',
								children : [
									{
										type : 'text',
										label : 'Test Text 4',
										title : 'Your love is like bad medicine!',
										id : 'testText4',
										'default' : 'hello world!',
										validate : function( dialog )
										{
											var valid = /^[A-Z a-z!]+$/.test( this.getValue() );
											if ( !valid )
											{
												this.select();
												alert( 'Test Text 4 must only contain alphanumeric characters, space, or ! and must not be empty.' );
											}
											return valid;
										},
										isChanged : false 
									},

									{
										type : 'text',
										label : 'Test Text 5',
										id : 'testText5',
										'default' : 'Wheee'
									},

									{
										type : 'text',
										label : 'Test Text 6',
										id : 'testText6',
										'default' : 'Blah blah'
									}
								]
							}
						]
					},

					{
						id : 'tab3',
						label : 'Third Tab',
						title : 'Third Tab Title',
						accessKey : 'E',
						elements : [
							{
								type : 'vbox',
								children : [
									{
										type : 'checkbox',
										label : 'Enable this',
										title : 'Shake it up, just like bad medicine!',
										accessKey : 'T',
										checked : false
									},

									{
										type : 'checkbox',
										label : 'Enable that',
										checked : true 
									},

									{
										type : 'checkbox',
										label : 'Enable those',
										checked : false
									},

									{
										type : 'radio',
										label : 'Include library:',
										title : 'Trying to include a library in LOLCODE.',
										'default' : 'stdio',
										accessKey : 'Y',
										items : [
											[ 'Standard I/O', 'stdio', 'You need this to write Hello World.' ],
											[ 'Standard C Library', 'stdlib', 'You need this to exit.' ],
											[ 'POSIX Library', 'unistd', 'You need this to sleep.' ],
											[ 'Signal Library', 'signal' ]
										]
									},

									{
										type : 'button',
										label : 'Click Me',
										title : 'Click me plz!',
										accessKey : 'U',
										onClick : function( evt )
										{
											console.log( 'Clicked!!' );
										}
									},

									{
										type : 'html',
										html : '<strong>CKEditor rocks.</strong>'
									}
								]
							}
						]
					}
				]
			};
		});
