/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'link',
{
	init : function( editor, pluginPath )
	{
		editor.addCommand( 'link', new CKEDITOR.dialogCommand( 'link' ) );
		editor.ui.addButton( 'Link',
			{
				label : editor.lang.link,
				command : 'link'
			} );
		editor.ui.addButton( 'Unlink',
			{
				label : editor.lang.unlink,
				command : 'unlink'
			} );
		CKEDITOR.dialog.add( 'link', CKEDITOR.plugins.link.dialog );
	}
} );

CKEDITOR.plugins.link =
{
	dialog : function( editor )
	{
		// Handles the event when the "Target" selection box is changed.
		var targetChanged = function()
		{
			var popupFeatures = this.getDialog().getContentElement( 'target', 'popupFeatures' ).getElement(),
				targetName = this.getDialog().getContentElement( 'target', 'linkTargetName' );
			if ( this.getValue() == 'popup' )
			{
				popupFeatures.show();
				targetName.setLabel( editor.lang.linkTargetPopupName );
			}
			else
			{
				popupFeatures.hide();
				targetName.setLabel( editor.lang.linkTargetFrameName );
			}
		},
		// Handles the event when the "Type" selection box is changed.
			linkTypeChanged = function()
		{
			var dialog = this.getDialog(),
				partIds = [ 'urlOptions', 'anchorOptions', 'emailOptions' ],
				typeValue = this.getValue();
			if ( typeValue == 'url' )
			{
				dialog.showPage( 'target' );
				dialog.showPage( 'upload' );
			}
			else
			{
				dialog.hidePage( 'target' );
				dialog.hidePage( 'upload' );
			}

			for ( var i = 0 ; i < partIds.length ; i++ )
			{
				var element = dialog.getContentElement( 'info', partIds[i] ).getElement();
				if ( partIds[i] == typeValue + 'Options' )
					element.show();
				else
					element.hide();
			}
		};

		return {
			title : editor.lang.linkTitle,
			minWidth : 400,
			minHeight : 320,
			contents : [
				{
					id : 'info',
					label : editor.lang.linkInfo,
					elements :
					[
						{
							id : 'linkType',
							type : 'select',
							label : editor.lang.linkType,
							'default' : 'url',
							items :
							[
								[ editor.lang.url, 'url' ],
								[ editor.lang.linkToAnchor, 'anchor' ],
								[ editor.lang.linkToEmail, 'email' ]
							],
							onChange : linkTypeChanged,
							onLoad : linkTypeChanged
						},
						{
							type : 'vbox',
							id : 'urlOptions',
							children :
							[
								{
									type : 'hbox',
									widths : [ '25%', '75%' ],
									children : 
									[
										{
											id : 'protocol',
											type : 'select',
											label : editor.lang.protocol,
											'default' : 'http://',
											style : 'width : 100%;',
											items :
											[
												[ 'http://' ],
												[ 'https//' ],
												[ 'ftp://' ],
												[ 'news://' ],
												[ '<other>' ]
											]
										},
										{
											type : 'text',
											id : 'url',
											label : editor.lang.url
										}
									]
								},
								{
									type : 'button',
									id : 'browse',
									label : editor.lang.browseServer
								}
							]
						},
						{
							type : 'vbox',
							id : 'anchorOptions',
							width : 260,
							align : 'center',
							padding : 0,
							children :
							[
								{
									type : 'html',
									html : CKEDITOR.tools.htmlEncode( editor.lang.linkSelectAnchor )
								},
								{
									type : 'hbox',
									children : 
									[
										{
											type : 'select',
											id : 'anchorName',
											'default' : '',
											label : editor.lang.linkAnchorName,
											style : 'width: 100%;',
											items :
											[
												[ '' ]
											]
										},
										{
											type : 'select',
											id : 'anchorId',
											'default' : '',
											label : editor.lang.linkAnchorId,
											style : 'width: 100%;',
											items :
											[
												[ '' ]
											]
										}
									]
								}
							]
						},
						{
							'type' : 'vbox',
							id : 'emailOptions',
							children : []
						}
					]
				},
				{
					id : 'target',
					label : editor.lang.linkTarget,
					elements : 
					[
						{
							type : 'hbox',
							widths : [ '50%', '50%' ],
							children :
							[
								{
									type : 'select',
									id : 'linkTargetType',
									label : editor.lang.linkTarget,
									'default' : 'notSet',
									style : 'width : 100%;',
									'items' : 
									[
										[ editor.lang.linkTargetNotSet, 'notSet' ],
										[ editor.lang.linkTargetFrame, 'frame' ],
										[ editor.lang.linkTargetPopup, 'popup' ],
										[ editor.lang.linkTargetNew, 'new' ],
										[ editor.lang.linkTargetTop, 'top' ],
										[ editor.lang.linkTargetSelf, 'self' ],
										[ editor.lang.linkTargetParent, 'parent' ]
									],
									onChange : targetChanged,
									onLoad : targetChanged
								},
								{
									type : 'text',
									id : 'linkTargetName',
									label : editor.lang.linkTargetFrameName
								}
							]
						},
						{
							type : 'vbox',
							width : 260,
							align : 'center',
							padding : 2,
							id : 'popupFeatures',
							children : 
							[
								{
									type : 'html',
									html : CKEDITOR.tools.htmlEncode( editor.lang.linkPopupFeatures )
								},
								{
									type : 'hbox',
									children : 
									[
										{
											type : 'checkbox',
											id : 'resizable',
											label : editor.lang.linkPopupResizable
										},
										{
											type : 'checkbox',
											id : 'statusBar',
											label : editor.lang.linkPopupStatusBar
										}
									]
								},
								{
									type : 'hbox',
									children :
									[
										{
											type : 'checkbox',
											id : 'locationBar',
											label : editor.lang.linkPopupLocationBar
										},
										{
											type : 'checkbox',
											id : 'toolbar',
											label : editor.lang.linkPopupToolbar
										}
									]
								},
								{
									type : 'hbox',
									children :
									[
										{
											type : 'checkbox',
											id : 'menubar',
											label : editor.lang.linkPopupMenuBar
										},
										{
											type : 'checkbox',
											id : 'fullscreen',
											label : editor.lang.linkPopupFullScreen
										}
									]
								},
								{
									type : 'hbox',
									children :
									[
										{
											type : 'checkbox',
											id : 'scrollbars',
											label : editor.lang.linkPopupScrollBars
										},
										{
											type : 'checkbox',
											id : 'dependent',
											label : editor.lang.linkPopupDependent
										}
									]
								},
								{
									type : 'hbox',
									children :
									[
										{
											'type' : 'text',
											widths : [ '30%', '70%' ],
											labelLayout : 'horizontal',
											label : editor.lang.linkPopupWidth,
											id : 'popupWidth'
										},
										{
											'type' : 'text',
											labelLayout : 'horizontal',
											widths : [ '55%', '45%' ],
											label : editor.lang.linkPopupLeft,
											id : 'popupLeft'
										}
									]
								},
								{
									type : 'hbox',
									children :
									[
										{
											'type' : 'text',
											labelLayout : 'horizontal',
											widths : [ '30%', '70%' ],
											label : editor.lang.linkPopupHeight,
											id : 'popupHeight'
										},
										{
											'type' : 'text',
											labelLayout : 'horizontal',
											label : editor.lang.linkPopupTop,
											widths : [ '55%', '45%' ],
											id : 'popupTop'
										}
									]
								}
							]
						}
					]
				},
				{
					id : 'upload',
					label : editor.lang.linkUpload,
					elements : 
					[
						{
							type : 'file',
							id : 'upload',
							label : editor.lang.upload,
							action : 'nowhere.php',
							size : 38
						},
						{
							type : 'fileButton',
							id : 'uploadButton',
							label : editor.lang.uploadSubmit,
							'for' : [ 'upload', 'upload' ]
						}
					]
				},
				{
					id : 'advanced',
					label : editor.lang.linkAdvanced,
					elements : 
					[
						{
							'type' : 'vbox',
							padding : 1,
							children : 
							[
								{
									'type' : 'hbox',
									widths : [ '45%', '35%', '20%' ],
									children : 
									[
										{
											'type' : 'text',
											id : 'advId',
											label : editor.lang.linkId
										},
										{
											'type' : 'select',
											id : 'advLangDir',
											label : editor.lang.linkLangDir,
											'default' : 'notSet',
											style : 'width: 100%;',
											items :
											[
												[ editor.lang.linkLangDirNotSet, 'notSet' ],
												[ editor.lang.linkLangDirLTR, 'ltr' ],
												[ editor.lang.linkLangDirRTL, 'rtl' ]
											]
										},
										{
											'type' : 'text',
											id : 'advAccessKey',
											label : editor.lang.linkAcccessKey,
											maxLength : 1
										}
									]
								},
								{
									'type' : 'hbox',
									widths : [ '45%', '35%', '20%' ],
									children : 
									[
										{
											'type' : 'text',
											label : editor.lang.linkName,
											id : 'advName'
										},
										{
											'type' : 'text',
											label : editor.lang.linkLangCode,
											id : 'advLangCode'
										},
										{
											'type' : 'text',
											label : editor.lang.linkTabIndex,
											id : 'advTabIndex',
											maxLength : 5
										}
									]
								}
							]
						},
						{
							'type' : 'vbox',
							padding : 1,
							children :
							[
								{
									'type' : 'hbox',
									widths : [ '45%', '55%' ],
									children : 
									[
										{
											'type' : 'text',
											label : editor.lang.linkAdvisoryTitle,
											id : 'advTitle'
										},
										{
											'type' : 'text',
											label : editor.lang.linkAdvisoryContentType,
											id : 'advContentType'
										}
									]
								},
								{
									'type' : 'hbox',
									widths : [ '45%', '55%' ],
									children : 
									[
										{
											'type' : 'text',
											label : editor.lang.linkCSSClasses,
											id : 'advCSSClasses'
										},
										{
											'type' : 'text',
											label : editor.lang.linkCharset,
											id : 'advCharset'
										}
									]
								},
								{
									'type' : 'hbox',
									children : 
									[
										{
											'type' : 'text',
											label : editor.lang.linkStyles,
											id : 'advStyles'
										}
									]
								}
							]
						}
					]
				},
			],
			onShow : function()
			{
				this.getContentElement( 'info', 'url' ).focus();
			}
		};
	}
};
