/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */
CKEDITOR.dialog.add( 'select', function( editor )
{
	return {
		title : editor.lang.selectionFieldProp,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 350,
		onOk: function( data )
		{
			return true;
		},

		onCancel: function()
		{
		},
		
		onLoad: function( data )
		{
			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.dlgSelectSelectInfo,
				title : editor.lang.dlgSelectSelectInfo,
				accessKey : '',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						widths : [ '25%','75%' ],
						labelLayout : 'horizontal',
						label : editor.lang.dlgCheckboxName,
						'default' : '',
						accessKey : 'N',
						align:'center',
						style : 'width:350px',
						validate: function( data )
						{
							return true;
						}
					},
					{
						id : 'txtValue',
						type : 'text',
						widths : [ '25%','75%' ],
						labelLayout : 'horizontal',
						label : editor.lang.dlgSelectValue,
						style : 'width:350px',
						'default' : '',
						accessKey : 'V',
						disabled : true
					},
					{
						type : 'hbox',
						widths : [ '175px', '170px' ],
						align : 'center',
						children : 
						[
							{
								id : 'txtSize',
								type : 'text',
								align : 'center',
								labelLayout : 'horizontal',
								label : editor.lang.dlgSelectSize,
								'default' : '',
								accessKey : 'S',
								style : 'width:175px',
								validate: function( data )
								{
									if ( this.getValue() != '' )
									{
										var selectSize = parseInt( this.getValue(), 10 );
										if ( isNaN( selectSize ) )
										{
											this.select();
											return false;
										}
									}
									return true;
								}
							},
							{
								type : 'html',
								align : 'center',
								html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.dlgSelectLines ) + '</span>'
							},
						]
					},
					{
						type : 'html',
						align : 'center',
						html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.dlgSelectOpAvail ) + '</span>'
					},
					{
						type : 'hbox',
						widths : [ '35%', '35%', '15%', '15%' ],
						children :
						[
							{
								id : 'txtName',
								type : 'text',
								label : editor.lang.dlgSelectOpText,
								style : 'width:105px',
								validate: function( data )
								{
									return true;
								}
							},
							{
								id : 'txtValue',
								type : 'text',
								label : editor.lang.dlgSelectOpValue,
								style : 'width:105px',
								validate: function( data )
								{
									return true;
								}
							},
							{
								type : 'button',
								style : '',
								label : editor.lang.dlgSelectBtnAdd,
								title : editor.lang.dlgSelectBtnAdd,
								onClick : function()
								{
								}
							},
							{
								type : 'button',
								label : editor.lang.dlgSelectBtnModify,
								title : editor.lang.dlgSelectBtnModify,
								onClick : function()
								{
								}
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '35%','35%','30%'],
						children :
						[
							{
								type : 'select',
								id : 'cmbText',
								label : '',
								title : '',
								size : 5,
								style : 'width:105px',
								items:	[
								],
								onChange : function()
								{
								}
							},
							{
								type : 'select',
								id : 'cmbText',
								label : '',
								title : '',
								size : 5,
								style : 'width:105px',
								items:	[
								],
								onChange : function()
								{
								}
							},
							{
								type : 'vbox',
								children : 
								[
									{
										type : 'button',
										style : 'width:100%;',
										label : editor.lang.dlgSelectBtnUp,
										title : editor.lang.dlgSelectBtnUp,
										onClick : function()
										{
										}
									},
									{
										type : 'button',
										style : 'width:100%;',
										label : editor.lang.dlgSelectBtnDown,
										title : editor.lang.dlgSelectBtnDown,
										onClick : function()
										{
										}
									}
								]
							}
						]
					},	
					{
						type : 'hbox',
						widths : [ '30%', '30%', '40%' ],
						children :
						[
							{
								type : 'button',
								label : editor.lang.dlgSelectBtnSetValue,
								title : editor.lang.dlgSelectBtnSetValue,
								onClick : function()
								{
								}
							},
							{
								type : 'button',
								label : editor.lang.dlgSelectBtnDelete,
								title : editor.lang.dlgSelectBtnDelete,
								onClick : function()
								{
								}
							},
							{
								id : 'txtType',
								type : 'checkbox',
								label : editor.lang.dlgSelectChkMulti,
								'default' : 'url',
								accessKey : 'M',
								validate: function( data )
								{
									return true;
								}
							},
						]
					}
				]
			}
		]
	};
});
