/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

imageDialog = function( editor, dialogType )
{
	var uploadAction = 'nowhere.php';
	var imageDialog = ( dialogType == 'image' );

	return {
		title : ( imageDialog ) ? editor.lang.dlgImgTitle : editor.lang.imageButtonProp,
		minWidth : 450,
		minHeight : 400,
		onShow : function( )
		{
		},
		onOk : function( )
		{
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.dlgImgInfoTab,
				accessKey : 'I',
				elements :
				[
					{
						type : 'vbox',
						padding : 0,
						children : 
						[
							{
								type : 'html',
								style : 'padding:0px;margin:0px',
								html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.dlgImgURL ) + '</span>'
							},
							{
								type : 'hbox',
								widths : [ '280px', '110px' ],
								align : 'right',
								children : 
								[
									{
										id : 'txtUrl',
										type : 'text',
										label : '',
										style : 'width: 280px',
										validate: function( data ) {
											return true;
										}
									},
									{
										type : 'button',
										id : 'browse',
										style : 'width:100%',
										align : 'center',
										label : editor.lang.browseServer,
										onClick : function()
										{
										}
									}
								]
							}
						]
					},
					{
						id : 'txtAlt',
						type : 'text',
						label : editor.lang.dlgImgAlt,
						accessKey : 'A',
						style : 'width:385px',
						validate: function( data ) {
							return true;
						}
					},
					{
						type : 'hbox',
						widths : [ '140px', '240px' ],
						children : 
						[
							{
								type : 'vbox',
								children : 
								[
									{
										type : 'hbox',
										widths : [ '70%', '30%' ],
										children : 
										[
											{
												type : 'vbox',
												children : 
												[
													{
														type : 'text',
														id : 'txtWidth',
														labelLayout : 'horizontal',	
														style : 'width:100%',
														label : editor.lang.dlgImgWidth,
														validate: function( data ) {
															if ( this.getValue() != '' )
															{
																if ( isNaN( parseInt( this.getValue(), 10 ) ) )
																{
																	this.select();
																	return false;
																}
															}
															return true;
														}
													},
													{
														type : 'text',
														id : 'txtHeight',
														labelLayout : 'horizontal',	
														style : 'width:100%',
														label : editor.lang.dlgImgHeight,
														validate: function( data ) {
															if ( this.getValue() != '' )
															{
																if ( isNaN( parseInt( this.getValue(), 10 ) ) )
																{
																	this.select();
																	return false;
																}
															}
															return true;
														}
													}
												]
											},
											{
												type : 'html',
												style : 'position:relative; top:-20px;width:35px;height:20px',		//valign = top
												html : '<div>'+ 
													'<div onclick="" title="' + editor.lang.dlgImgLockRatio + '" onmouseout="this.className = (true ? \'BtnLocked\' : \'BtnUnlocked\' );" '+ 'onmouseover="this.className = (true ? \'BtnLocked\' : \'BtnUnlocked\' ) + \' BtnOver\';" class="BtnLocked" id="btnLockSizes"></div>' + 
													'<div onclick="" title="' + editor.lang.dlgBtnResetSize + '" onmouseout="this.className=\'BtnReset\';" onmouseover="this.className=\'BtnReset BtnOver\';" class="BtnReset" id="btnResetSize"></div>'+
													'</div>'
											}
										]
									},
									{
										type : 'text',
										id : 'txtBorder',
										labelLayout : 'horizontal',	
										style : 'width:100%',
										label : editor.lang.dlgImgBorder,
										validate: function( data ) {
											if ( this.getValue() != '' )
											{
												if ( isNaN( parseInt( this.getValue(), 10 ) ) )
												{
													this.select();
													return false;
												}
											}
											return true;
										}
									},
									{
										type : 'text',
										id : 'txtHSpace',
										labelLayout : 'horizontal',	
										style : 'width:100%',
										label : editor.lang.dlgImgHSpace,
										validate: function( data ) {
											if ( this.getValue() != '' )
											{
												if ( isNaN( parseInt( this.getValue(), 10 ) ) )
												{
													this.select();
													return false;
												}
											}
											return true;
										}
									},
									{
										type : 'text',
										id : 'txtVSpace',
										labelLayout : 'horizontal',	
										label : editor.lang.dlgImgVSpace,
										style : 'width:100%',
										validate: function( data ) {
											if ( this.getValue() != '' )
											{
												if ( isNaN( parseInt( this.getValue(), 10 ) ) )
												{
													this.select();
													return false;
												}
											}
											return true;
										}
									},
									{
										id : 'cmbAlign',
										type : 'select',
										labelLayout : 'horizontal',	
										widths : [ '30%','70%' ],
										label : editor.lang.dlgImgAlign,
										style : 'width:100%',
										items :
										[
											[ editor.lang.dlgGenNotSet , ''],
											[ editor.lang.dlgImgAlignLeft , 'left'],
											[ editor.lang.dlgImgAlignAbsBottom , 'absBottom'],
											[ editor.lang.dlgImgAlignAbsMiddle , 'absMiddle'],
											[ editor.lang.dlgImgAlignBaseline , 'baseline'],
											[ editor.lang.dlgImgAlignBottom , 'bottom'],
											[ editor.lang.dlgImgAlignMiddle , 'middle'],
											[ editor.lang.dlgImgAlignRight , 'right'],
											[ editor.lang.dlgImgAlignTextTop , 'textTop'],
											[ editor.lang.dlgImgAlignTop , 'top']
										]
									}
								]
							},
							{
								type : 'vbox',
								height : '180px',
								children : 
								[
									{
										type : 'html',
										style : 'width:95%;',
										html: '<div>' + CKEDITOR.tools.htmlEncode( editor.lang.dlgImgPreview ) +
											'<div id="ImagePreviewBox" style="border: 1px solid black;height:160px"></div>'+
											'</div>'
									}
								]
							}
						]
					}
				]
			},
			{
				id : 'Link',
				label : editor.lang.linkTitle,
				padding : 0,
				elements : 
				[
					{
						id : 'txtUrl',
						type : 'text',
						label : editor.lang.dlgImgURL,
						style : 'width: 385px',
						validate: function( data ) {
							return true;
						}
					},
					{
						type : 'button',
						id : 'browse',
						style : 'float:right',
						label : editor.lang.browseServer
					},
					{
						id : 'cmbTarget',
						type : 'select',
						label : editor.lang.linkTarget,
						style : 'width : 90px',
						items :
						[
							[ editor.lang.linkTargetNotSet , ''],
							[ editor.lang.linkTargetNew , '_blank'],
							[ editor.lang.linkTargetTop , '_top'],
							[ editor.lang.linkTargetSelf , '_self'],
							[ editor.lang.linkTargetParent , '_parent']
						]
					}
				]
			},
			{
				id : 'Upload',
				label : editor.lang.dlgImgUpload,
				elements : 
				[
					{
						type : 'file',
						id : 'upload',
						label : editor.lang.dlgImgBtnUpload,
						action : uploadAction,
						size : 38
					},
					{
						type : 'fileButton',
						id : 'uploadButton',
						label : editor.lang.dlgImgBtnUpload,
						'for' : [ 'Upload', 'upload' ]
					}
				]
			},
			{
				id : 'advanced',
				label : editor.lang.dlgDivAdvancedTab,
				elements : 
				[
					{
						type : 'hbox',
						widths : [ '50%', '25%', '25%' ],
						children :
						[
							{
								type : 'text',
								id : 'linkId',
								label : editor.lang.dlgGenId
							},
							{
								id : 'cmbLangDir',
								type : 'select',
								label : editor.lang.dlgGenLangDir,
								style : 'width : 100%;',
								items :
								[
									[ editor.lang.dlgGenNotSet, '' ],
									[ editor.lang.dlgGenLangDirLtr, 'ltr' ],
									[ editor.lang.dlgGenLangDirRtl, 'rtl' ]
								]
							},
							{
								type : 'text',
								id : 'txtLangCode',
								label : editor.lang.dlgGenLangCode
							}
						]
					},
					{
						type : 'text',
						id : 'txtGenLongDescr',
						label : editor.lang.dlgGenLongDescr
					},
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								type : 'text',
								id : 'txtGenClass',
								label : editor.lang.dlgGenClass
							},
							{
								type : 'text',
								id : 'txtGenTitle',
								label : editor.lang.dlgGenTitle
							},
						]
					},
					{
						type : 'text',
						id : 'txtdlgGenStyle',
						label : editor.lang.dlgGenStyle
					}
				]
			}
		]
	};
};

CKEDITOR.dialog.add( 'image', function( editor ){
		return imageDialog( editor, 'image' )
	}
);

CKEDITOR.dialog.add( 'imagebutton', function( editor ){
		return imageDialog( editor, 'imagebutton' )
	}
);
