/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */
CKEDITOR.dialog.add( 'textfield', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	return {
		title : editor.lang.textFieldProp,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 230,
		onOk: function( data )
		{
			for( var name in this.changedAttibutes )
			{
				this.editObj.setAttribute(name, this.changedAttibutes[ name ] );
			}
			
			if( this.editMode == false )
			{
				editor.insertElement( this.editObj );
			}
			return true;
		},
		onCancel: function()
		{
		},
		onShow: function()
		{
			this.editMode = false;
			
			/*
			Check selection.
			Fill this.editObj if the BUTTON element is selected.
			*/
			
			if( this.editMode == false )	//New object.
			{
				this.editObj = editor.document.createElement( 'input' );
			}
			
			this.changedAttibutes = new Array();
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.textFieldProp,
				title : editor.lang.textFieldProp,
				accessKey : 'I',
				elements : [
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								id : 'txtName',
								type : 'text',
								label : editor.lang.dlgTextName,
								'default' : '',
								accessKey : 'N',
								validate: function( data )
								{
									addChange( 'name', this );
									return true;
								}
							},
							{
								id : 'txtValue',
								type : 'text',
								label : editor.lang.dlgTextValue,
								'default' : '',
								accessKey : 'V',
								validate: function( data )
								{
									addChange( 'value', this );
									return true;
								}
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								id : 'txtTextCharWidth',
								type : 'text',
								label : editor.lang.dlgTextCharWidth,
								'default' : '',
								accessKey : 'C',
								style : 'width:50px',
								validate: function( data )
								{
									if ( this.getValue() != '' )
									{
										var charWidth = parseInt( this.getValue(), 10 );
										if ( isNaN( charWidth ) )
										{
											this.select();
											return false;
										}
										addChange( 'width', this );
									}
									return true;
								}
							},
							{
								id : 'txtMaxChars',
								type : 'text',
								label : editor.lang.dlgTextMaxChars,
								'default' : '',
								accessKey : 'M',
								style : 'width:50px',
								validate: function( data )
								{
									if ( this.getValue() != '' )
									{
										var maxChars = parseInt( this.getValue(), 10 );
										if ( isNaN( maxChars ) )
										{
											this.select();
											return false;
										}
										addChange( 'maxlength', this );
									}
									return true;
								}
							}
						]
					},
					{
						id : 'txtType',
						type : 'select',
						label : editor.lang.dlgTextType,
						'default' : 'text',
						accessKey : 'M',
						items :
						[
							[ editor.lang.dlgTextTypeText, 'text' ],
							[ editor.lang.dlgTextTypePass, 'pass' ],
						],
						validate: function( data )
						{
							addChange( 'type', this );
							return true;
						}
					}
				]
			}
		]
	};
});
