/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */
CKEDITOR.dialog.add( 'form', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	return {
		title : editor.lang.formProp,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 230,
		onOk: function( data )
		{
			for( var name in this.changedAttibutes )
			{
				this.editObj.setAttribute(name, this.changedAttibutes[ name ] );
			}
	
			if( this.editMode == false )	//New object.
			{
				this.restoreSelection();
				editor.insertElement( this.editObj );
			}
			return true;
		},
		onShow: function()
		{
		
			this.editMode = false;
			
			/*
			Check selection.
			Fill this.editObj if FORM element is selected.
			*/
			
			if( this.editMode == false )
			{
				this.editObj = editor.document.createElement( 'form' );
			}
			
			this.changedAttibutes = new Array();
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.formProp,
				title : editor.lang.formProp,
				accessKey : 'I',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.dlgFormName,
						'default' : '',
						accessKey : 'N',
						validate: function( data )
						{
							addChange( 'name', this );
							return true;
						}
					},
					{
						id : 'txtAction',
						type : 'text',
						label : editor.lang.dlgFormAction,
						'default' : '',
						accessKey : 'A',
						validate: function( data )
						{
							addChange( 'action', this );
							return true;
						}
					},
					{
						id : 'txtMethod',
						type : 'select',
						label : editor.lang.dlgFormMethod,
						'default' : 'GET',
						accessKey : 'M',
						items :
						[
							[ 'GET', 'get' ],
							[ 'POST', 'post' ]
						],
						validate: function( data )
						{
							addChange( 'method', this );
							return true;
						}
					}
				]
			}
		]
	};
});
