/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'forms',
{
	init : function( editor )
	{
		var forms = CKEDITOR.plugins.forms;
		editor.ui.addButton( 'Form',
			{
				label : editor.lang.form,
				command : 'form'
			});
		editor.addCommand( 'form', new CKEDITOR.dialogCommand( 'form' ) );

		editor.ui.addButton( 'Checkbox',
			{
				label : editor.lang.checkbox,
				command : 'checkbox'
			});
		editor.addCommand( 'checkbox', new CKEDITOR.dialogCommand( 'checkbox' ) );

		editor.ui.addButton( 'Radio',
			{
				label : editor.lang.radio,
				command : 'radio'
			});
		editor.addCommand( 'radio', new CKEDITOR.dialogCommand( 'radio' ) );

		editor.ui.addButton( 'TextField',
			{
				label : editor.lang.textField,
				command : 'textfield'
			});
		editor.addCommand( 'textfield', new CKEDITOR.dialogCommand( 'textfield' ) );

		editor.ui.addButton( 'Textarea',
			{
				label : editor.lang.textarea,
				command : 'textarea'
			});
		editor.addCommand( 'textarea', new CKEDITOR.dialogCommand( 'textarea' ) );

		editor.ui.addButton( 'Select',
			{
				label : editor.lang.select,
				command : 'select'
			});
		editor.addCommand( 'select', new CKEDITOR.dialogCommand( 'select' ) );

		editor.ui.addButton( 'Button',
			{
				label : editor.lang.button,
				command : 'button'
			});
		editor.addCommand( 'button', new CKEDITOR.dialogCommand( 'button' ) );

		editor.ui.addButton( 'ImageButton',
			{
				label : editor.lang.imageButton,
				command : 'imagebutton'
			});
		editor.addCommand( 'imagebutton', new CKEDITOR.dialogCommand( 'imagebutton' ) );

		editor.ui.addButton( 'HiddenField',
			{
				label : editor.lang.hiddenField,
				command : 'hiddenfield'
			});
		editor.addCommand( 'hiddenfield', new CKEDITOR.dialogCommand( 'hiddenfield' ) );

		CKEDITOR.dialog.add( 'form',		this.path + 'dialogs/form.js' );
		CKEDITOR.dialog.add( 'checkbox',	this.path + 'dialogs/checkbox.js' );
		CKEDITOR.dialog.add( 'radio', 		this.path + 'dialogs/radio.js' );
		CKEDITOR.dialog.add( 'textfield',	this.path + 'dialogs/textfield.js' );
		CKEDITOR.dialog.add( 'textarea',	this.path + 'dialogs/textarea.js' );
		CKEDITOR.dialog.add( 'select',		this.path + 'dialogs/select.js' );
		CKEDITOR.dialog.add( 'button',		this.path + 'dialogs/button.js' );
		CKEDITOR.dialog.add( 'hiddenfield',	this.path + 'dialogs/hiddenfield.js' );
		CKEDITOR.dialog.add( 'imagebutton',	CKEDITOR.plugins.getPath('image') + 'dialogs/image.js' );
	},
	requires : [ 'image' ]
} );

CKEDITOR.plugins.forms =
{
	select :
	{
		// Add a new option to a SELECT object (combo or list).
		addOption : function( combo, optionText, optionValue, documentObject, index )
		{
			combo = this._getObject( combo );
			var oOption;

			if ( documentObject )
				oOption = documentObject.createElement( "OPTION" );
			else
				oOption = document.createElement( "OPTION" );

			if ( oOption.tagName && oOption.tagName.toLowerCase() == 'option' )
			{
				oOptionObj = oOption;
			}
			else if (oOption.$ && oOption.$.tagName && oOption.$.tagName.toLowerCase() == 'option' )
			{
				oOptionObj = oOption.$;
			}
			if ( !isNaN( parseInt( index, 10 ) ) )
				combo.options.add( oOptionObj, index );
			else
				combo.options.add( oOptionObj );

			oOptionObj.innerHTML = optionText.length > 0 ? CKEDITOR.tools.htmlEncode( optionText ) : '';
			oOptionObj.value     = optionValue;

			return oOptionObj;
		},

		// Remove all selected options from a SELECT object.
		removeSelectedOptions : function ( combo )
		{
			combo = this._getObject( combo );

			// Save the selected index
			var iSelectedIndex = combo.selectedIndex;

			var oOptions = combo.options;

			// Remove all selected options.
			for ( var i = oOptions.length - 1 ; i >= 0 ; i-- )
			{
				if ( oOptions[i].selected ) combo.remove(i);
			}

			// Reset the selection based on the original selected index.
			if ( combo.options.length > 0 )
			{
				if ( iSelectedIndex >= combo.options.length ) iSelectedIndex = combo.options.length - 1;
				combo.selectedIndex = iSelectedIndex;
			}
		},

		//Modify option  from a SELECT object.
		modifyOption : function( combo, index, title, value )
		{
			combo = this._getObject( combo );
			if ( index < 0 ) return ;

			combo.options[ index ].innerHTML	= CKEDITOR.tools.htmlEncode( title ) ;
			combo.options[ index ].value		= CKEDITOR.tools.htmlEncode( value ) ;
		},

		// Moves the selected option by a number of steps (also negative).
		changeOptionPosition : function ( combo, steps )
		{
			combo = this._getObject( combo );
			var iActualIndex = combo.selectedIndex;

			if ( iActualIndex < 0 )
				return;

			var iFinalIndex = iActualIndex + steps;

			if ( iFinalIndex < 0 )
				iFinalIndex = 0;

			if ( iFinalIndex > ( combo.options.length - 1 ) )
				iFinalIndex = combo.options.length - 1;

			if ( iActualIndex == iFinalIndex )
				return;

			var oOption = combo.options[ iActualIndex ];
			var sText	= this._htmlDecode( oOption.innerHTML );
			var sValue	= this._htmlDecode( oOption.value );

			combo.remove( iActualIndex );

			oOption = this.addOption( combo, sText, sValue, null, iFinalIndex );
			oOption.selected = true;
		},
		getSelectedIndex : function( combo )
		{
			combo = this._getObject( combo );

			var iIndex = combo.selectedIndex;
			if ( iIndex < 0 ) return ;
			return iIndex;
		},
		setSelectedIndex : function( combo, index )
		{
			combo = this._getObject( combo );

			if ( index < 0 ) return ;
			combo.selectedIndex = index;

			return combo;
		},
		getOptions : function ( combo )
		{
			combo = this._getObject( combo );
			return combo.options;
		},
		_getObject : function ( obj )
		{
			if ( obj ){
				if ( obj.tagName && obj.tagName.toLowerCase() == 'select' )
					return obj;
				else if ( obj.domId && obj.getInputElement().$ )
					return obj.getInputElement().$;
				else if ( obj.$ )
					return obj.$;
			}
			else
				return false;
		},
		_htmlDecode : function( text )
		{
			if ( !text )
				return '';

			text = text.replace( /&gt;/g, '>' );
			text = text.replace( /&lt;/g, '<' );
			text = text.replace( /&amp;/g, '&' );

			return text;
		}
	}
}
