﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @file Special Character plugin
 */

var specialChars =
[
	"!","&quot;","#","$","%","&amp;","\\'","(",")","*","+","-",".","/",
	"0","1","2","3","4","5","6","7","8","9",":",";",
	"&lt;","=","&gt;","?","@",
	"A","B","C","D","E","F","G","H","I","J","K","L","M","N","O",
	"P","Q","R","S","T","U","V","W","X","Y","Z",
	"[","]","^","_","`",
	"a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p",
	"q","r","s","t","u","v","w","x","y","z",
	"{","|","}","~","&euro;","&lsquo;","&rsquo;","&rsquo;","&ldquo;",
	"&rdquo;","&ndash;","&mdash;","&iexcl;","&cent;","&pound;",
	"&curren;","&yen;","&brvbar;","&sect;","&uml;","&copy;","&ordf;",
	"&laquo;","&not;","&reg;","&macr;","&deg;","&plusmn;","&sup2;",
	"&sup3;","&acute;","&micro;","&para;","&middot;","&cedil;",
	"&sup1;","&ordm;","&raquo;","&frac14;","&frac12;","&frac34;",
	"&iquest;","&Agrave;","&Aacute;","&Acirc;","&Atilde;","&Auml;",
	"&Aring;","&AElig;","&Ccedil;","&Egrave;","&Eacute;","&Ecirc;",
	"&Euml;","&Igrave;","&Iacute;","&Icirc;","&Iuml;","&ETH;",
	"&Ntilde;","&Ograve;","&Oacute;","&Ocirc;","&Otilde;","&Ouml;",
	"&times;","&Oslash;","&Ugrave;","&Uacute;","&Ucirc;","&Uuml;",
	"&Yacute;","&THORN;","&szlig;","&agrave;","&aacute;","&acirc;",
	"&atilde;","&auml;","&aring;","&aelig;","&ccedil;","&egrave;",
	"&eacute;","&ecirc;","&euml;","&igrave;","&iacute;","&icirc;",
	"&iuml;","&eth;","&ntilde;","&ograve;","&oacute;","&ocirc;",
	"&otilde;","&ouml;","&divide;","&oslash;","&ugrave;","&uacute;",
	"&ucirc;","&uuml;","&uuml;","&yacute;","&thorn;","&yuml;",
	"&OElig;","&oelig;","&#372;","&#374","&#373","&#375;","&sbquo;",
	"&#8219;","&bdquo;","&hellip;","&trade;","&#9658;","&bull;",
	"&rarr;","&rArr;","&hArr;","&diams;","&asymp;"
];

CKEDITOR.plugins.add( 'specialchar',
{
	init : function( editor, pluginPath )
	{
		editor.addCommand( 'specialchar', new CKEDITOR.dialogCommand( 'specialchar' ) );
		editor.ui.addButton( 'SpecialChar',
			{
				label : editor.lang.specialChar,
				command : 'specialchar'
			});
		CKEDITOR.dialog.add( 'specialchar', CKEDITOR.plugins.specialchar.dialog );
	}
} );


CKEDITOR.plugins.specialchar =
{
	dialog : function( editor )
	{
		return {
			title : editor.lang.dlgSpecialCharTitle,
			minWidth : 400,
			minHeight : 300,
			buttons : [ CKEDITOR.dialog.cancelButton ],
			onLoad :  function()
			{
				html = [ '<table style="width: 100%; height: 100%; border-collapse: separate;" align="center" cellspacing="2" cellpadding="2" border="0">' ];
				html.push( '<tbody>' );

				var cols = 20 ;
				var i = 0 ;

				while ( i < specialChars.length)
				{
					html.push("<tr>") ;
					for( var j = 0 ; j < cols ; j++)
					{
						if (specialChars[i])
						{
							html.push('<td width="1%" value="' + specialChars[i].replace(/&/g, "&amp;") + '" class="DarkBackground SpecialCharsOut Hand">');
							html.push(specialChars[i]);
						}
						else
							html.push("<td class='DarkBackground SpecialCharsOut'>&nbsp;");
						html.push("<\/td>");
						i++;
					}
					html.push("<\/tr>");
				}

				html.push( '</tbody></table>' );
				this.getContentElement( 'info', 'charContainer' ).getElement().setHtml(html.join( '' ));
			},
			contents : [
				{
					id : 'info',
					label : editor.lang.dlgDivGeneralTab,
					title : editor.lang.dlgDivGeneralTab,
					elements : [
						{
							type : 'html',
							id : 'charContainer',
							align : 'left',
							html : '',
							onClick : function( evt )
							{
								var target = evt.data.getTarget();
								var targetName = target.getName();

								if ( targetName == 'td' )
								{
									target = target.$;
									if ( value = target.getAttribute( 'value' ) )
									{
										this.getDialog().restoreSelection();
										editor.insertElement( CKEDITOR.dom.element.createFromHtml( value, editor.document ) );
										this.getDialog().hide();
									}
								}
							}
						}
					]
				}
			]
		};
	}
};
