/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */
CKEDITOR.dialog.add( 'select', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if ( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	return {
		title : editor.lang.selectionFieldProp,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 350,
		onShow: function()
		{
			var parentEditor = this.getParentEditor();
			this.editMode = false;

			/*
			Check selection.
			Fill this.editObj if the SELECT element is selected.
			*/

			var names = this.getContentElement( 'info', 'cmbName' );
			var values = this.getContentElement( 'info', 'cmbValue' );
			var namesOptions = CKEDITOR.plugins.forms.select.getOptions( names );
			var valuesOptions = CKEDITOR.plugins.forms.select.getOptions( values );

			// Reset dialog.
			for ( var i = namesOptions.length-1 ; i >=0 ; i-- )
			{
				namesOptions[i].parentNode.removeChild( namesOptions[i] );
				valuesOptions[i].parentNode.removeChild( valuesOptions[i] );
			}


			if ( this.editMode == true )		//Load existing object.
			{
				this.getContentElement( 'info', 'txtOptValue' ).setValue( this.editObj.getAttribute( "name" ) );
				this.getContentElement( 'info', 'txtOptValue' ).setValue( this.editObj.getAttribute( "value" ) );
				this.getContentElement( 'info', 'txtSize' ).setValue( this.editObj.getAttribute( "size" ) );
				this.getContentElement( 'info', 'chkMulti' ).setValue( this.editObj.getAttribute( "multiple" ) );

				var objOptions = CKEDITOR.plugins.forms.select.getOptions( this.editObj );

				//Load Options into dialog.
				for ( var i = 0 ; i < objOptions.length ; i++ )
				{
					var oText	= objOptions[i].inerHTML;
					var oValue	= objOptions[i].value;

					var oTOption = CKEDITOR.plugins.forms.select.addOption( names, oText, oText, parentEditor.document );
					var oVOption = CKEDITOR.plugins.forms.select.addOption( values, oValue, oValue, parentEditor.document );
				}
			}
			else 	//New object.
				this.editObj = this.getParentEditor().document.createElement( 'select' );

			this.changedAttibutes = new Array();
		},
		onOk: function()
		{

			var objOptions = CKEDITOR.plugins.forms.select.getOptions( this.editObj );

			// Remove all options.
			for ( var i = objOptions.length-1 ; i >= 0 ; i-- )
				objOptions[i].parentNode.removeChild( objOptions[i] );

			var selectValue = this.getContentElement( 'info', 'txtValue' ).getValue();
			var optionsNames = CKEDITOR.plugins.forms.select.getOptions( this.getContentElement( 'info', 'cmbName' ) );
			var optionsValues = CKEDITOR.plugins.forms.select.getOptions( this.getContentElement( 'info', 'cmbValue' ) );

			//Set added/changed attributes
			for( var name in this.changedAttibutes )
				this.editObj.setAttribute(name, this.changedAttibutes[ name ] );

			var parentEditor = this.getParentEditor();

			// Add all available options.
			for ( var i = 0 ; i < optionsNames.length ; i++ )
			{
				var sText	= optionsNames[i].value;
				var sValue	= optionsValues[i].value;
				if ( sValue.length == 0 ) sValue = sText;

				var oOption = CKEDITOR.plugins.forms.select.addOption( this.editObj, sText, sValue, parentEditor.document );
				if ( sValue == selectValue )
				{
					oOption.setAttribute( 'selected', 'selected' );
					oOption.selected = true;
				}
			}

			if ( this.editMode == false )
			{
				this.restoreSelection();
				parentEditor.insertElement( this.editObj );
			}
			return true;
		},
		onCancel: function()
		{
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.dlgSelectSelectInfo,
				title : editor.lang.dlgSelectSelectInfo,
				accessKey : '',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						widths : [ '25%','75%' ],
						labelLayout : 'horizontal',
						label : editor.lang.dlgCheckboxName,
						'default' : '',
						accessKey : 'N',
						align:'center',
						style : 'width:350px',
						validate: function( data )
						{
							addChange( 'name', this );
							return true;
						}
					},
					{
						id : 'txtValue',
						type : 'text',
						widths : [ '25%','75%' ],
						labelLayout : 'horizontal',
						label : editor.lang.dlgSelectValue,
						style : 'width:350px',
						'default' : '',
						accessKey : 'V',
						disabled : true
					},
					{
						type : 'hbox',
						widths : [ '175px', '170px' ],
						align : 'center',
						children :
						[
							{
								id : 'txtSize',
								type : 'text',
								align : 'center',
								labelLayout : 'horizontal',
								label : editor.lang.dlgSelectSize,
								'default' : '',
								accessKey : 'S',
								style : 'width:175px',
								validate: function( data )
								{
									if ( this.getValue() != '' )
									{
										var selectSize = parseInt( this.getValue(), 10 );
										if ( isNaN( selectSize ) )
										{
											this.select();
											return false;
										}
										addChange( 'size', this );
									}
									return true;
								}
							},
							{
								type : 'html',
								align : 'center',
								html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.dlgSelectLines ) + '</span>'
							}
						]
					},
					{
						type : 'html',
						align : 'center',
						html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.dlgSelectOpAvail ) + '</span>'
					},
					{
						type : 'hbox',
						widths : [ '35%', '35%', '15%', '15%' ],
						children :
						[
							{
								id : 'txtOptName',
								type : 'text',
								label : editor.lang.dlgSelectOpText,
								style : 'width:105px'
							},
							{
								id : 'txtOptValue',
								type : 'text',
								label : editor.lang.dlgSelectOpValue,
								style : 'width:105px'
							},
							{
								type : 'button',
								style : '',
								label : editor.lang.dlgSelectBtnAdd,
								title : editor.lang.dlgSelectBtnAdd,
								onClick : function()
								{
									//Add new option.
									var dialog = this.getDialog();
									var name = dialog.getContentElement( 'info', 'txtOptName' );
									var value = dialog.getContentElement( 'info', 'txtOptValue' );

									var names = dialog.getContentElement( 'info', 'cmbName' );
									var values = dialog.getContentElement( 'info', 'cmbValue' );

									CKEDITOR.plugins.forms.select.addOption(names, name.getValue(), name.getValue() );
									CKEDITOR.plugins.forms.select.addOption(values, value.getValue(), value.getValue() );

									name.setValue( "" );
									value.setValue( "" );
								}
							},
							{
								type : 'button',
								label : editor.lang.dlgSelectBtnModify,
								title : editor.lang.dlgSelectBtnModify,
								onClick : function()
								{
									//Modify selected option.
									var dialog = this.getDialog();
									var name = dialog.getContentElement( 'info', 'txtOptName' );
									var value = dialog.getContentElement( 'info', 'txtOptValue' );

									var names = dialog.getContentElement( 'info', 'cmbName' );
									var values = dialog.getContentElement( 'info', 'cmbValue' );

									var iIndex = CKEDITOR.plugins.forms.select.getSelectedIndex( names );
									CKEDITOR.plugins.forms.select.modifyOption( names, iIndex, name.getValue(), name.getValue() );
									CKEDITOR.plugins.forms.select.modifyOption( values, iIndex, value.getValue(), value.getValue() );
								}
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '35%','35%','30%'],
						children :
						[
							{
								type : 'select',
								id : 'cmbName',
								label : '',
								title : '',
								multiple : true,
								size : 5,
								style : 'width:105px',
								items : [],
								onChange : function()
								{
									var dialog = this.getDialog();
									var names = dialog.getContentElement( 'info', 'cmbName' );
									var values = dialog.getContentElement( 'info', 'cmbValue' );

									var name = dialog.getContentElement( 'info', 'txtOptName' );
									var value = dialog.getContentElement( 'info', 'txtOptValue' );

									var iIndex = CKEDITOR.plugins.forms.select.getSelectedIndex( names );
									CKEDITOR.plugins.forms.select.setSelectedIndex( values, iIndex );

									name.setValue( names.getValue() );
									value.setValue( values.getValue() );
								}
							},
							{
								type : 'select',
								id : 'cmbValue',
								label : '',
								title : '',
								multiple : true,
								size : 5,
								style : 'width:105px',
								items : [],
								onChange : function()
								{
									var dialog = this.getDialog();
									var names = dialog.getContentElement( 'info', 'cmbName' );
									var values = dialog.getContentElement( 'info', 'cmbValue' );

									var name = dialog.getContentElement( 'info', 'txtOptName' );
									var value = dialog.getContentElement( 'info', 'txtOptValue' );

									var iIndex = CKEDITOR.plugins.forms.select.getSelectedIndex( values );
									CKEDITOR.plugins.forms.select.setSelectedIndex( names, iIndex );

									name.setValue( names.getValue() );
									value.setValue( values.getValue() );
								}
							},
							{
								type : 'vbox',
								children :
								[
									{
										type : 'button',
										style : 'width:100%;',
										label : editor.lang.dlgSelectBtnUp,
										title : editor.lang.dlgSelectBtnUp,
										onClick : function()
										{
											//Move up.
											var dialog = this.getDialog();
											var names = dialog.getContentElement( 'info', 'cmbName' );
											var values = dialog.getContentElement( 'info', 'cmbValue' );

											CKEDITOR.plugins.forms.select.changeOptionPosition( names, -1 );
											CKEDITOR.plugins.forms.select.changeOptionPosition( values, -1 );
										}
									},
									{
										type : 'button',
										style : 'width:100%;',
										label : editor.lang.dlgSelectBtnDown,
										title : editor.lang.dlgSelectBtnDown,
										onClick : function()
										{
											//Move down.
											var dialog = this.getDialog();
											var names = dialog.getContentElement( 'info', 'cmbName' );
											var values = dialog.getContentElement( 'info', 'cmbValue' );

											CKEDITOR.plugins.forms.select.changeOptionPosition( names, 1 );
											CKEDITOR.plugins.forms.select.changeOptionPosition( values, 1 );
										}
									}
								]
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '40%', '20%', '40%' ],
						children :
						[
							{
								type : 'button',
								label : editor.lang.dlgSelectBtnSetValue,
								title : editor.lang.dlgSelectBtnSetValue,
								onClick : function()
								{
									//Set as default value.
									var dialog = this.getDialog();
									var values = dialog.getContentElement( 'info', 'cmbValue' );
									var txtValue = dialog.getContentElement( 'info', 'txtValue' );
									txtValue.setValue( values.getValue() );
								}
							},
							{
								type : 'button',
								label : editor.lang.dlgSelectBtnDelete,
								title : editor.lang.dlgSelectBtnDelete,
								onClick : function()
								{
									// Delete option.
									var dialog = this.getDialog();
									var names = dialog.getContentElement( 'info', 'cmbName' );
									var values = dialog.getContentElement( 'info', 'cmbValue' );

									CKEDITOR.plugins.forms.select.removeSelectedOptions( names );
									CKEDITOR.plugins.forms.select.removeSelectedOptions( values );

									var name = dialog.getContentElement( 'info', 'txtOptName' );
									var value = dialog.getContentElement( 'info', 'txtOptValue' );
									name.setValue( "" );
									value.setValue( "" );
								}
							},
							{
								id : 'chkMulti',
								type : 'checkbox',
								label : editor.lang.dlgSelectChkMulti,
								'default' : 'url',
								accessKey : 'M',
								validate: function( data )
								{
									// Multiselect checkbox.
									addChange( 'multiple', this );
									return true;
								}
							}
						]
					}
				]
			}
		]
	};
});
