﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'basicstyles',
{
	requires : [ 'styles' ],

	init : function( editor, pluginPath )
	{
		// All buttons use the same code to register. So, to avoid
		// duplications, let's use this tool function.
		var addButtonCommand = function( buttonName, buttonLabel, commandName, styleDefiniton )
		{
			var style = new CKEDITOR.style( styleDefiniton );
			
			editor.attachStyleStateChange( style, function( state )
				{
					var command = editor.getCommand( commandName );
					command.state = state;
					command.fire( 'state' );
				});
		
			editor.addCommand( commandName, new CKEDITOR.styleCommand( style ) );

			editor.ui.addButton( buttonName,
				{
					label : buttonLabel,
					command : commandName
				});
		};

		var coreStyles = editor.config.coreStyles;
		var lang = editor.lang;

		addButtonCommand( 'Bold'		, lang.bold			, 'bold'		, coreStyles.bold );
		addButtonCommand( 'Italic'		, lang.italic		, 'italic'		, coreStyles.italic );
		addButtonCommand( 'Underline'	, lang.underline	, 'underline'	, coreStyles.underline );
		addButtonCommand( 'Strike'		, lang.strike		, 'strike'		, coreStyles.strike );
		addButtonCommand( 'Subscript'	, lang.subscript	, 'subscript'	, coreStyles.subscript );
		addButtonCommand( 'Superscript'	, lang.superscript	, 'superscript'	, coreStyles.superscript );
	}
});

CKEDITOR.config.coreStyles =
{
	// Basic Inline Styles.
	bold			: { element : 'strong', overrides : 'b' },
	italic			: { element : 'em', overrides : 'i' },
	underline		: { element : 'u' },
	strike			: { element : 'strike' },
	subscript		: { element : 'sub' },
	superscript		: { element : 'sup' }
};
