﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview The "sourcearea" plugin. It registers the "source" editing
 *		mode, which displays the raw data being edited in the editor.
 */

CKEDITOR.plugins.add( 'sourcearea',
{
	requires : [ 'editingblock' ],

	init : function( editor, pluginPath )
	{
		var sourcearea = CKEDITOR.plugins.sourcearea;

		editor.on( 'editingBlockReady', function()
			{
				var textarea;

				editor.addMode( 'source',
					{
						load : function( holderElement, data )
						{
							// Create the source area <textarea>.
							textarea = new CKEDITOR.dom.element( 'textarea' );
							textarea.setAttribute( 'dir', 'ltr' );
							if ( !CKEDITOR.env.ie )
							{
								textarea.on( 'mousedown', function( evt )
									{
										evt = evt.data.$;
										if ( evt.stopPropagation )
											evt.stopPropagation();
									} );
							}
							textarea.addClass( 'cke_source' );
							textarea.setStyles({
								width	: '100%',
								height	: '100%',
								resize	: 'none',
								outline	: 'none',
								'text-align' : 'left' });

							// Set the <textarea> value.
							this.loadData( data );

							// Reset the holder element and append the
							// <textarea> to it.
							holderElement.setHtml( '' );
							holderElement.append( textarea );
						},

						loadData : function( data )
						{
							textarea.setValue( data );
						},

						getData : function()
						{
							return textarea.getValue();
						},

						getSnapshotData : function()
						{
							return textarea.getValue();
						},

						unload : function( holderElement )
						{
							textarea = null;
						},

						focus : function()
						{
							textarea.focus();
						}
					});
			});

		editor.addCommand( 'source', sourcearea.commands.source );
		editor.ui.addButton( 'Source',
			{
				label : editor.lang.source,
				command : 'source'
			});

		editor.on( 'mode', function()
			{
				var command = editor.getCommand( 'source' );
				command.state = ( editor.mode == 'source' ? CKEDITOR.TRISTATE_ON : CKEDITOR.TRISTATE_OFF );
				command.fire( 'state' );
			});
	}
});

/**
 * Holds the definition of commands an UI elements included with the sourcearea
 * plugin.
 * @example
 */
CKEDITOR.plugins.sourcearea =
{
	commands :
	{
		source :
		{
			exec : function( editor )
			{
				editor.setMode( editor.mode == 'source' ? 'wysiwyg' : 'source' );
			}
		}
	}
};
