/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.requestcycle;

import javax.servlet.http.HttpServletRequest;

import net.fckeditor.connector.Dispatcher;
import net.fckeditor.handlers.Command;
import net.fckeditor.handlers.ResourceType;
import net.fckeditor.tool.Utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Holds basic parameters and associated methods for each request.
 *
 * @version $Id: Context.java 2737 2008-11-28 20:52:43Z mosipov $
 */
public class Context {
	// This is just a helper class which has no relevance for the logger
	private static final Logger logger = LoggerFactory.getLogger(Dispatcher.class);
	
	private String typeStr;
	private String commandStr;
	private String currentFolderStr;
	
	protected Context(final HttpServletRequest request) {
		commandStr = request.getParameter("Command");
		typeStr = request.getParameter("Type");
		currentFolderStr = request.getParameter("CurrentFolder");
		
		// if this is a QuickUpload request, 'commandStr' and 'currentFolderStr'
		// are empty
		if (Utils.isEmpty(commandStr) && Utils.isEmpty(currentFolderStr)) {
			commandStr = "QuickUpload";
			currentFolderStr = "/";
		}
		
		// checks to meet specs in http://docs.fckeditor.net/FCKeditor_2.x/Developers_Guide/Server_Side_Integration#File_Browser_Requests
		if (currentFolderStr != null && !currentFolderStr.startsWith("/"))
			currentFolderStr = "/".concat(currentFolderStr);
	}
	
	/**
	 * @return the typeStr
	 */
	public String getTypeStr() {
		return typeStr;
	}
	
	public ResourceType getDefaultResourceType() {
		return ResourceType.getDefaultResourceType(typeStr);
	}
	
	public ResourceType getResourceType() {
		return ResourceType.getResourceType(typeStr);
	}
	
	/**
	 * @return the commandStr
	 */
	public String getCommandStr() {
		return commandStr;
	}
	
	public Command getCommand() {
		return Command.valueOf(commandStr);
	}
	
	/**
	 * @return the currentFolderStr
	 */
	public String getCurrentFolderStr() {
		return currentFolderStr;
	}
	
	public void logBaseParameters() {
		logger.debug("Parameter Command: {}", commandStr);
		logger.debug("Parameter Type: {}", typeStr);
		logger.debug("Parameter CurrentFolder: {}", currentFolderStr);
	}

}
