package net.fckeditor.requestcycle.impl;

import javax.servlet.http.HttpServletRequest;

import net.fckeditor.handlers.PropertiesLoader;
import net.fckeditor.requestcycle.UserPathBuilder;

/**
 * This implementation always returns the UserFilesPath from the properties file
 * absolute to the server root URL.
 * 
 * @version $Id: ServerRootPathBuilder.java 2739 2008-11-28 23:29:05Z mosipov $
 * 
 */
public class ServerRootPathBuilder implements UserPathBuilder {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * net.fckeditor.requestcycle.UserPathBuilder#getUserFilesAbsolutePath(javax
	 * .servlet.http.HttpServletRequest)
	 */
	public String getUserFilesAbsolutePath(final HttpServletRequest request) {
		return PropertiesLoader.getUserFilesAbsolutePath();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * net.fckeditor.requestcycle.UserPathBuilder#getUserFilesPath(javax.servlet
	 * .http.HttpServletRequest)
	 */
	public String getUserFilesPath(final HttpServletRequest request) {
		return PropertiesLoader.getUserFilesPath();
	}

}
