/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.connector.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletContext;

import net.fckeditor.connector.Connector;
import net.fckeditor.connector.exception.FolderAlreadyExistsException;
import net.fckeditor.connector.exception.InvalidCurrentFolderException;
import net.fckeditor.connector.exception.InvalidNewFolderNameException;
import net.fckeditor.handlers.ConnectorHandler;
import net.fckeditor.handlers.RequestCycleHandler;
import net.fckeditor.handlers.ResourceType;
import net.fckeditor.requestcycle.ThreadLocalData;
import net.fckeditor.tool.UtilsFile;

import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;

/**
 * TODO Review documentation
 * Implementation of the {@link Connector} for the file system. All path are
 * interpreted as sub-directories of the
 * {@link ConnectorHandler#getUserFilesPath()}.<br>
 * 
 * @version $Id: AbstracLocalFileSystemConnector.java 2741 2008-11-29 14:06:19Z mosipov $
 */
public abstract class AbstracLocalFileSystemConnector implements Connector {

	protected static ServletContext servletContext;

	/*
	 * (non-Javadoc)
	 * 
	 * @seenet.fckeditor.connector.Connector#fileUpload(net.fckeditor.handlers.
	 * ResourceType, java.lang.String, java.lang.String, java.io.InputStream)
	 */
	public String fileUpload(final ResourceType type,
			final String currentFolder, final String fileName,
			final InputStream inputStream) throws SecurityException,
			InvalidCurrentFolderException, IOException {
		String absolutePath = getRealUserFilesAbsolutePath(RequestCycleHandler
				.getUserFilesAbsolutePath(ThreadLocalData.getRequest()));
		File typeDir = getOrCreateResourceTypeDir(absolutePath, type);
		File currentDir = new File(typeDir, currentFolder);
		if (!currentDir.exists() || !currentDir.isDirectory())
			throw new InvalidCurrentFolderException();
		File newFile = new File(currentDir, fileName);
		File fileToSave = UtilsFile.getUniqueFile(newFile.getAbsoluteFile());
		
		// TODO maybe there is no need to catch and rethrow the exceptions, we may just pass them as-is
		try {
			IOUtils.copyLarge(inputStream, new FileOutputStream(fileToSave));
		} catch (SecurityException e) {
			// not explicitly thrown by anyone but in case that a
			// SecurityManager is deployed, this could restrict writing on disk
			throw e;
		} catch (IOException e) {
			throw e;
		}
		return fileToSave.getName();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * net.fckeditor.connector.Connector#createFolder(net.fckeditor.handlers
	 * .ResourceType, java.lang.String, java.lang.String)
	 */
	public void createFolder(final ResourceType type,
			final String currentFolder, final String newFolder)
			throws InvalidCurrentFolderException, SecurityException,
			InvalidNewFolderNameException, FolderAlreadyExistsException {
		String absolutePath = getRealUserFilesAbsolutePath(RequestCycleHandler
				.getUserFilesAbsolutePath(ThreadLocalData.getRequest()));
		File typeDir = getOrCreateResourceTypeDir(absolutePath, type);
		File currentDir = new File(typeDir, currentFolder);
		if (!currentDir.exists() || !currentDir.isDirectory())
			throw new InvalidCurrentFolderException();
		File newDir = new File(currentDir, newFolder);
		// TODO maybe there is no need to catch and rethrow the exceptions, we may just pass them as-is
		if (newDir.exists())
			throw new FolderAlreadyExistsException();
		try {
			if (!newDir.mkdir())
				throw new InvalidNewFolderNameException();
		} catch (SecurityException e) {
			throw e;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seenet.fckeditor.connector.Connector#getFiles(net.fckeditor.handlers.
	 * ResourceType, java.lang.String)
	 */
	public List<Map<String, Object>> getFiles(ResourceType type,
			String currentFolder) throws InvalidCurrentFolderException,
			SecurityException {
		String absolutePath = getRealUserFilesAbsolutePath(RequestCycleHandler
				.getUserFilesAbsolutePath(ThreadLocalData.getRequest()));
		File typeDir = getOrCreateResourceTypeDir(absolutePath, type);
		File currentDir = new File(typeDir, currentFolder);
		if (!currentDir.exists() || !currentDir.isDirectory())
			throw new InvalidCurrentFolderException();

		// collect files
		List<Map<String, Object>> files;
		Map<String, Object> fileMap;
		// TODO maybe there is no need to catch and rethrow the exceptions, we may just pass them as-is
		try {
			File[] fileList = currentDir
					.listFiles((FileFilter) FileFileFilter.FILE);
			files = new ArrayList<Map<String, Object>>(fileList.length);
			for (File file : fileList) {
				fileMap = new HashMap<String, Object>(2);
				fileMap.put(Connector.KEY_NAME, file.getName());
				fileMap.put(Connector.KEY_SIZE, file.length());
				files.add(fileMap);
			}
			return files;
		} catch (SecurityException e) {
			throw e;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seenet.fckeditor.connector.Connector#getFolders(net.fckeditor.handlers.
	 * ResourceType, java.lang.String)
	 */
	public List<String> getFolders(final ResourceType type,
			final String currentFolder) throws InvalidCurrentFolderException,
			SecurityException {
		String absolutePath = getRealUserFilesAbsolutePath(RequestCycleHandler
				.getUserFilesAbsolutePath(ThreadLocalData.getRequest()));
		File typeDir = getOrCreateResourceTypeDir(absolutePath, type);
		File currentDir = new File(typeDir, currentFolder);
		if (!currentDir.exists() || !currentDir.isDirectory())
			throw new InvalidCurrentFolderException();

		// TODO maybe there is no need to catch and rethrow the exceptions, we may just pass them as-is
		try {
			String[] fileList = currentDir.list(DirectoryFileFilter.DIRECTORY);
			return Arrays.asList(fileList);
		} catch (SecurityException e) {
			throw e;
		}
	}

	protected abstract String getRealUserFilesAbsolutePath(String path);

	private static File getOrCreateResourceTypeDir(final String baseDir,
			final ResourceType type) throws SecurityException {
		File dir = new File(baseDir, type.getPath());
		if (!dir.exists())
			dir.mkdirs();
		return dir;
	}
}
