﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.themes.add( 'default',
{
	build : function( editor, themePath )
	{
		var name = editor.name,
			element = editor.element,
			elementMode = editor.elementMode;

		if ( !element || elementMode == CKEDITOR.ELEMENT_MODE_NONE )
			return;

		if ( elementMode == CKEDITOR.ELEMENT_MODE_REPLACE )
			element.hide();

		// Get the HTML for the predefined spaces.
		var topHtml			= editor.fire( 'themeSpace', { space : 'top', html : '' } ).html;
		var contentsHtml	= editor.fire( 'themeSpace', { space : 'contents', html : '' } ).html;
		var bottomHtml		= editor.fireOnce( 'themeSpace', { space : 'bottom', html : '' } ).html;

		var height	= contentsHtml && editor.config.height;
		var width	= editor.config.width;

		// The editor height is considered only if the contents space got filled.
		if ( !contentsHtml )
			height = 'auto';
		else if ( !isNaN( height ) )
			height += 'px';

		if ( !isNaN( width ) )
			width += 'px';

		// Using a <div> as the outer element container can make IE goes crazy.
		// The fact is that a <textarea> is an inline element. We aim to
		// replace it with our structure, but <div> is a block element and it
		// seems to be the cause of it. Using a <span>, which is inline just
		// like <textarea>, makes it work.
		// <table> is also a block element and should not go inside a <span>,
		// not even in the places where <textarea> is valid. But this doesn't
		// bring any evident problem as it seems that tables are treated
		// differently by the browsers ("semi-inline").
		var container = CKEDITOR.dom.element.createFromHtml( [
			'<span id="cke_', name, '" onmousedown="return false;" class="cke_container cke_skin_', editor.config.skin, ' ', CKEDITOR.env.browserCssClass,
				' cke_', editor.lang.dir, '" dir="', editor.lang.dir, '">' +
				'<table class="cke_editor" border="0" cellspacing="0" cellpadding="0" style="width:', width, ';height:', height, '"><tbody>' +
					'<tr', topHtml		? '' : ' style="display:none"', '><td id="cke_top_'		, name, '" class="cke_top">'		, topHtml		, '</td></tr>' +
					'<tr', contentsHtml	? '' : ' style="display:none"', '><td id="cke_contents_', name, '" class="cke_contents" style="height:100%">'	, contentsHtml	, '</td></tr>' +
					'<tr', bottomHtml	? '' : ' style="display:none"', '><td id="cke_bottom_'	, name, '" class="cke_bottom">'		, bottomHtml	, '</td></tr>' +
				'</tbody></table>' +
			'</span>' ].join('') );

		container.getChild( [0, 0, 0] ).unselectable();
		container.getChild( [0, 0, 2] ).unselectable();

		if ( elementMode == CKEDITOR.ELEMENT_MODE_REPLACE )
			container.insertAfter( element );
		else
			element.append( container );

		/**
		 * The DOM element that holds the main editor interface.
		 * @name CKEDITOR.editor.prototype.container
		 * @type CKEDITOR.dom.element
		 * @example
		 * var editor = CKEDITOR.instances.editor1;
		 * alert( <b>editor.container</b>.getName() );  "span"
		 */
		editor.container = container;

		editor.fireOnce( 'themeLoaded' );
		editor.fireOnce( 'uiReady' );
	},

	buildDialog : function( editor )
	{
		var name = editor.name,
			element = editor.element,
			dialogId = CKEDITOR.tools.getNextNumber(),
			cover = null;

		if ( !editor._.dialogCover )
		{
			cover = editor._.dialogCover = CKEDITOR.dom.element.createFromHtml( [
						'<div id="cke_dialog_cover"></div>'
					].join('') );
		}

		var container = CKEDITOR.dom.element.createFromHtml( [
				'<div class="cke_skin_', editor.config.skin, ' ', CKEDITOR.env.browserCssClass,
					' ', 'cke_', editor.lang.dir,
					'" ', 'dir="', editor.lang.dir, '"><div id="cke_dialog_%d" class="cke_dialog" style="position:',
					( CKEDITOR.env.ie && CKEDITOR.env.version < 7 ? 'absolute;' : 'fixed;' ),
					'">',
					'<div>',
						'<div id="cke_dialog_tl_%d" class="cke_dialog_tl">',
							'<div id="cke_dialog_tl_resize_%d" class="cke_dialog_tl_resize"></div>',
						'</div>',
						'<div id="cke_dialog_t_%d" class="cke_dialog_t">',
							'<div id="cke_dialog_t_resize_%d" class="cke_dialog_t_resize"></div>',
						'</div>',
						'<div id="cke_dialog_tr_%d" class="cke_dialog_tr">',
							'<div id="cke_dialog_tr_resize_%d" class="cke_dialog_tr_resize"></div>',
						'</div>',
					'</div>',
					'<div>',
						'<div id="cke_dialog_l_%d" class="cke_dialog_l">',
							'<div id="cke_dialog_l_resize_%d" class="cke_dialog_l_resize"></div>',
						'</div>',
						'<div id="cke_dialog_c_%d" class="cke_dialog_c">',
							'<div id="cke_dialog_title_%d" class="cke_dialog_title">',
								'<div id="cke_dialog_close_button_%d" class="cke_dialog_close_button"></div>',
							'</div>',
							'<table id="cke_dialog_tabs_%d" class="cke_dialog_tabs" cellpadding="0" border="0" cellspacing="0"><tbody><tr>',
							'<td class="head_filler"></td>',
							'<td class="tail_filler"></td>',
							'</tr></tbody></table>',
							'<div id="cke_dialog_contents_%d" class="cke_dialog_contents"></div>',
							'<div id="cke_dialog_footer_%d" class="cke_dialog_footer"></div>',
						'</div>',
						'<div id="cke_dialog_r_%d" class="cke_dialog_r">',
							'<div id="cke_dialog_r_resize_%d" class="cke_dialog_r_resize"></div>',
						'</div>',
					'</div>',
					'<div>',
						'<div id="cke_dialog_bl_%d" class="cke_dialog_bl">',
							'<div id="cke_dialog_bl_resize_%d" class="cke_dialog_bl_resize"></div>',
						'</div>',
						'<div id="cke_dialog_b_%d" class="cke_dialog_b">',
							'<div id="cke_dialog_b_resize_%d" class="cke_dialog_b_resize"></div>',
						'</div>',
						'<div id="cke_dialog_br_%d" class="cke_dialog_br">',
							'<div id="cke_dialog_br_resize_%d" class="cke_dialog_br_resize"></div>',
						'</div>',
					'</div>',
				'</div></div>'
			].join( '' ).replace( /%d/g, dialogId ) );

		container.getChild( [0, 1, 1, 0] ).unselectable();

		return container;
	},

	destroy : function( editor )
	{
		var container = editor.container;

		if ( container )
			container.remove();

		if ( editor.elementMode == CKEDITOR.ELEMENT_MODE_REPLACE )
			editor.element.show();
	}
});

CKEDITOR.editor.prototype.getThemeSpace = function( spaceName )
{
	var spacePrefix = 'cke_' + spaceName;
	var space = this._[ spacePrefix ] ||
		( this._[ spacePrefix ] = CKEDITOR.document.getById( spacePrefix + '_' + this.name ) );
	return space;
};
