﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * FCKToolbarPanelButton Class: represents a special button in the toolbar
 * that shows a panel when pressed. ToolbarPanelButtons can also have a secondary
 * command that runs as a default action when the button is pressed.
 */


var FCKToolbarPanelButton = function( commandName, label, tooltip, style, icon, buttonCommandName)
{
	this.CommandName = commandName ;
	this.ButtonCommandName = buttonCommandName || commandName;
	this.ContextSensitive = true ;
	var oIcon ;

	if ( icon == null )
		oIcon = FCKConfig.SkinPath + 'toolbar/' + commandName.toLowerCase() + '.gif' ;
	else if ( typeof( icon ) == 'number' )
		oIcon = [ FCKConfig.SkinPath + 'fck_strip.gif', 16, icon ] ;

	var oUIButton = this._UIButton = new FCKToolbarButtonUI( commandName, label, tooltip, oIcon, style ) ;
	oUIButton._FCKToolbarPanelButton = this ;
	oUIButton.ShowArrow = true ;
	oUIButton.OnClick = FCKToolbarPanelButton_OnButtonClick ;
}

FCKToolbarPanelButton.prototype.TypeName = 'FCKToolbarPanelButton' ;

FCKToolbarPanelButton.prototype.Create = function( parentElement )
{

	this._UIButton.Create( parentElement ) ;

	var oPanel = FCK.ToolbarSet.CurrentInstance.Commands.GetCommand( this.CommandName )._Panel ;
	oPanel._FCKToolbarPanelButton = this ;

	var eLineDiv = oPanel.Document.body.appendChild( oPanel.Document.createElement( 'div' ) ) ;
	eLineDiv.style.position = 'absolute' ;
	eLineDiv.style.top = '0px' ;

	var eLine = this.LineImg = eLineDiv.appendChild( oPanel.Document.createElement( 'IMG' ) ) ;
	eLine.className = 'TB_ConnectionLine' ;
//	eLine.style.backgroundColor = 'Red' ;
	eLine.src = FCK_SPACER_PATH ;

	oPanel.OnHide = FCKToolbarPanelButton_OnPanelHide ;
}

/*
	Events
*/

function FCKToolbarPanelButton_OnButtonClick( toolbarButton, ev )
{
	var oButton = this._FCKToolbarPanelButton ;
	var e = oButton._UIButton.MainElement ;

	var eSrc = (ev ? ev.originalTarget : window.event.srcElement);
	if (eSrc && eSrc.src && eSrc.clientHeight > 6)		//see if we've landed on the icon
	{
		FCK.ToolbarSet.CurrentInstance.Commands.GetCommand( oButton.ButtonCommandName ).Execute( 0, e.offsetHeight - 1, e, false ) ;
	}
	else	//we're on the arrow, so drop down
	{
		oButton.LineImg.style.width = ( e.offsetWidth - 2 ) + 'px' ;
		if (oButton._UIButton.MainElement.parentElement)
		{
			oButton._UIButton.MainElement.oldClassName =
				oButton._UIButton.MainElement.parentElement.className;
			oButton._UIButton.MainElement.parentElement.className += "Menu";
		}
		oButton._UIButton.ChangeState( FCK_TRISTATE_ON ) ;
		FCK.ToolbarSet.CurrentInstance.Commands.GetCommand( oButton.CommandName ).Execute( 0, e.offsetHeight - 1, e, true ) ; // -1 to be over the border
	}
}

function FCKToolbarPanelButton_OnPanelHide()
{
	var oMenuButton = this._FCKToolbarPanelButton ;
	if (oMenuButton._UIButton.MainElement.parentElement)
	{	
		oMenuButton._UIButton.MainElement.parentElement.className =
			oMenuButton._UIButton.MainElement.oldClassName;
	}
	oMenuButton._UIButton.ChangeState( FCK_TRISTATE_OFF ) ;
	FCKToolbarPanelButton.prototype.RefreshState;
}

// The Panel Button works like a normal button so the refresh state functions
// defined for the normal button can be reused here.
FCKToolbarPanelButton.prototype.RefreshState	= FCKToolbarButton.prototype.RefreshState ;
FCKToolbarPanelButton.prototype.Enable			= FCKToolbarButton.prototype.Enable ;
FCKToolbarPanelButton.prototype.Disable			= FCKToolbarButton.prototype.Disable ;
