/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'link',
{
	init : function( editor, pluginPath )
	{
		// Add the link and unlink buttons.
		editor.addCommand( 'link', new CKEDITOR.dialogCommand( 'link' ) );
		editor.addCommand( 'unlink', new CKEDITOR.unlinkCommand() );
		editor.ui.addButton( 'Link',
			{
				label : editor.lang.link,
				command : 'link'
			} );
		editor.ui.addButton( 'Unlink',
			{
				label : editor.lang.unlink,
				command : 'unlink'
			} );
		CKEDITOR.dialog.add( 'link', this.path + 'dialogs/link.js' );

		// Register selection change handler for the unlink button.
		editor.on( 'selectionChange', function( evt )
			{
				var command = editor.getCommand( 'unlink' ),
					element = evt.data.path.lastElement;
				if ( element.getName() == 'a' && element.getAttribute( 'href' ) )
					command.state = CKEDITOR.TRISTATE_OFF;
				else
					command.state = CKEDITOR.TRISTATE_DISABLED;
				command.fire( 'state' );
			} );
	}
} );

CKEDITOR.unlinkCommand = function(){};
CKEDITOR.unlinkCommand.prototype =
{
	/** @ignore */
	exec : function( editor )
	{
		// TODO: There seems to be no way to remove the <a> tag via style system yet.
	}
};
