/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */
CKEDITOR.dialog.add( 'checkbox', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if ( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	return {
		title : editor.lang.checkboxProp,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 230,
		onOk : function()
		{
			this.changedAttibutes[ 'type' ] = 'checkbox';

			for ( var name in this.changedAttibutes )
				this.editObj.setAttribute( name, this.changedAttibutes[ name ] );

			if ( this.editMode == false )
			{
				this.restoreSelection();
				editor.insertElement( this.editObj );
			}
			return true;
		},
		onShow : function()
		{
			this.editMode = false;

			/*
			Check selection.
			Fill this.editObj if the BUTTON element is selected.
			*/

			if ( this.editMode == false )	//New object.
				this.editObj = editor.document.createElement( 'input' );

			this.getContentElement( 'info', 'txtName' ).focus();
			this.changedAttibutes = new Array();
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.checkboxProp,
				title : editor.lang.checkboxProp,
				accessKey : 'I',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.dlgCheckboxName,
						'default' : '',
						accessKey : 'N',
						validate: function()
						{
							addChange( 'name', this );
							return true;
						}
					},
					{
						id : 'txtValue',
						type : 'text',
						label : editor.lang.dlgCheckboxValue,
						'default' : '',
						accessKey : 'V',
						validate: function()
						{
							addChange( 'value', this );
							return true;
						}
					},
					{
						id : 'cmbSelected',
						type : 'checkbox',
						label : editor.lang.dlgCheckboxSelected,
						'default' : 'url',
						accessKey : 'S',
						validate: function()
						{
							addChange( 'selected', this );
							return true;
						}
					}
				]
			}
		]
	};
});
