/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */
CKEDITOR.dialog.add( 'textarea', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if ( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	return {
		title : editor.lang.extareaProp,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 230,
		onOk : function( data )
		{
			for ( var name in this.changedAttibutes )
				this.editObj.setAttribute(name, this.changedAttibutes[ name ] );

			if ( this.editMode == false )
			{
				this.restoreSelection();
				editor.insertElement( this.editObj );
			}
			return true;
		},
		onShow : function()
		{
			this.editMode = false;

			/*
			Check selection.
			Fill this.editObj if the TEXTAREA element is selected.
			*/

			if ( this.editMode == false )	//New object.
				this.editObj = editor.document.createElement( 'textarea' );

			this.getContentElement( 'info', 'txtName' ).focus();
			this.changedAttibutes = new Array();
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.extareaProp,
				title : editor.lang.extareaProp,
				accessKey : 'I',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.dlgTextareaName,
						'default' : '',
						accessKey : 'N',
						validate: function()
						{
							addChange( 'name', this );
							return true;
						}
					},
					{
						id : 'txtColumns',
						type : 'text',
						label : editor.lang.dlgTextareaCols,
						'default' : '',
						accessKey : 'C',
						style : 'width:50px',
						validate: function()
						{
							if ( this.getValue() != '' )
							{
								var maxChars = parseInt( this.getValue(), 10 );
								if ( isNaN( maxChars ) )
								{
									this.select();
									return false;
								}
								addChange( 'cols', this );
							}
							return true;
						}
					},
					{
						id : 'txtRows',
						type : 'text',
						label : editor.lang.dlgTextareaRows,
						'default' : '',
						accessKey : 'R',
						style : 'width:50px',
						validate: function()
						{
							if ( this.getValue() != '' )
							{
								var charWidth = parseInt( this.getValue(), 10 );
								if ( isNaN( charWidth ) )
								{
									this.select();
									return false;
								}
								addChange( 'rows', this );
							}
							return true;
						}
					}
				]
			}
		]
	};
});
