/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

imageDialog = function( editor, dialogType )
{
	var regexSize = /^\s*(\d+)px\s*$/i ;
	var uploadAction = 'nowhere.php';
	var imageDialog = ( dialogType == 'image' );

	var addChange = function( name, input, object ){
		var dialog = input.getDialog();
		if ( input.isChanged() || ( dialog.editMode[ object ] == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ object ][ name ] = input.getValue();
			return true;
		}
		return false;
	};

	// Function called in onShow to load selected element.
	var loadElements = function( editor, selection, ranges, element )
	{
		this.editObj[ 'image' ] = false;
		this.editMode[ 'image' ] = false;		// Default:  Create a new Image
		this.saveSelection();
		var imgType = 'input';

		//a=element.getChildren();for(i in a){alert(i+'--'+a[i])}
	
		if ( element.$.tagName.toLowerCase() == 'a' )
		{
			this.editMode[ 'link' ] = true;
			var linkChildren = element.getChildren();
			if ( linkChildren.count() == 1 ){		// 1 child.
				var childTagName = linkChildren.getItem(0).$.tagName.toLowerCase();
				if ( childTagName == 'img' || childTagName == 'input' )
				{
					this.editMode[ 'image' ] = true;
					this.editObj[ 'image' ] = linkChildren.getItem(0);
				}
			}

			this.editObj[ 'link' ] = element;

			if ( imageDialog )
			{
				imgType = 'img';

				// Fill out all fields.
				if ( !readAttribute.apply( this, [ 'Link', '_cke_saved_href', 'txtUrl', element ] ) )
					readAttribute.apply( this, [ 'Link', 'href', 'txtUrl', element ] )
				readAttribute.apply( this, [ 'Link', 'target', 'cmbTarget', element ] );
			}
		}

		if ( element.$.tagName.toLowerCase() == 'img' || element.$.tagName.toLowerCase() == 'input' || this.editObj[ 'image' ] )
		{
			this.editMode[ 'image' ] = true;
			if ( !this.editObj[ 'image' ] )
			{
				this.editObj[ 'image' ] = element;
			}
		//	alert('tag: '+element.$.tagName.toLowerCase());
			readAttribute.apply( this, [ 'info', 'alt', 'txtAlt' ] );
			readAttribute.apply( this, [ 'info', 'width', 'txtWidth' ] );
			readAttribute.apply( this, [ 'info', 'height', 'txtHeight' ] );
			readAttribute.apply( this, [ 'info', 'border', 'txtBorder' ] );
			readAttribute.apply( this, [ 'info', 'hspace', 'txtHSpace' ] );
			readAttribute.apply( this, [ 'info', 'vspace', 'txtVSpace' ] );
			readAttribute.apply( this, [ 'info', 'align', 'cmbAlign' ] );
			readAttribute.apply( this, [ 'advanced', 'id', 'linkId' ] );
			readAttribute.apply( this, [ 'advanced', 'dir', 'cmbLangDir' ] );
			readAttribute.apply( this, [ 'advanced', 'lang', 'txtLangCode' ] );
			readAttribute.apply( this, [ 'advanced', 'longdesc', 'txtGenLongDescr' ] );
			readAttribute.apply( this, [ 'advanced', 'class', 'txtGenClass' ] );
			readAttribute.apply( this, [ 'advanced', 'style', 'txtdlgGenStyle' ] );	
			readAttribute.apply( this, [ 'advanced', 'title', 'txtGenTitle' ] );
		}

		// Fill out all fields.
		if ( !readAttribute.apply( this, [ 'info', '_cke_saved_url', 'txtUrl' ] ) )
			readAttribute.apply( this, [ 'info', 'src', 'txtUrl' ] )

		return false;
	};
	
	var readAttribute = function( page, attribute, input, object )
	{
		if( !object )
			object = this.editObj[ 'image' ];

		var attributeValue = object.getAttribute( attribute );
		if ( attributeValue == null )
			this.setValueOf( page, input, "" );
		else
			this.setValueOf( page, input, attributeValue );

		return attributeValue;
	}

	return {
		title : ( imageDialog ) ? editor.lang.dlgImgTitle : editor.lang.imageButtonProp,
		minWidth : 450,
		minHeight : 400,
		onOk : function( data )
		{
			var imgType = imageDialog?'img':'input';
			var useLink = false;
			var removeObj = false;

			if ( this.editMode[ 'image' ] )
			{
				//a=this.editObj[ 'image' ].getParent();for(i in a){alert(i+'--'+a[i])}
				var imgTagName = this.editObj[ 'image' ].$.tagName.toLowerCase();
				
				if ( imageDialog && imgTagName == 'input' )		// Image dialog and Input element
				{
					if ( confirm( 'Do you want to transform the selected image button on a simple image?' ) )
					{
						// Replace INPUT-> IMG
						removeObj = this.editObj[ 'image' ] ;
						this.editObj[ 'image' ] = editor.document.createElement( 'img' );
						removeObj.insertBeforeMe( this.editObj[ 'image' ] );
						removeObj.getParent().remove( removeObj );
						imgTagName = 'img';
					}
				}
				else if ( !imageDialog && imgTagName == 'img' )		// ImageButton dialog and Image element
				{
					if ( confirm( 'Do you want to transform the selected image on a image button?' ) )
					{
						// Replace IMG -> INPUT
						removeObj = this.editObj[ 'image' ] ;
						this.editObj[ 'image' ] = editor.document.createElement( 'input' );
						this.editObj[ 'image' ].setAttribute ( 'type' ,'image' );
						removeObj.insertBeforeMe( this.editObj[ 'image' ] );
						removeObj.getParent().remove( removeObj );
						imgTagName = 'input';
					}
				}
			}
			else	// Create a new image.
			{
				if ( imgType == 'img' )
					this.editObj[ 'image' ] = editor.document.createElement( 'img' );
				else
				{
					this.editObj[ 'image' ] = editor.document.createElement( 'input' );
					this.editObj[ 'image' ].setAttribute ( 'type' ,'image' );
				}
			}

			// Create a new link.
			if ( this.editMode[ 'link' ] == false )
				this.editObj[ 'link' ] = editor.document.createElement( 'a' );

			// Set image attributes.
			this.editObj[ 'image' ].setAttributes( this.changedAttibutes[ 'image' ] );

			// Set link attributes.
			this.changedAttibutes[ 'link' ][ 'href' ] =  'javascript:void(0)/*' + CKEDITOR.tools.getNextNumber() + '*/';
			this.editObj[ 'link' ].setAttributes( this.changedAttibutes[ 'link' ] );
			
			if ( this.editObj[ 'link' ].getAttribute( '_cke_saved_href' ) )
			{
				useLink = true;
				alert('jest link');
			}

			// Insert a new Image.
			if ( this.editMode[ 'image' ] == false )
			{
				// It doesn't work with IE.
				this.restoreSelection();
				this.clearSavedSelection();
				
				if ( useLink )
					//Insert a new Link.
					if ( this.editMode[ 'link' ] == false )
					{
						this.editObj[ 'link' ].append( this.editObj[ 'image' ], false );
						editor.insertElement( this.editObj[ 'link' ] );
					}
					else 	//Link already exists, image not.
						this.editObj[ 'link' ].append( this.editObj[ 'image' ], false );
				else
					editor.insertElement( this.editObj[ 'image' ] );
			}
			else		// Image already exists.	
			{
				//Add a new link element.
				if ( this.editMode[ 'link' ] == false && this.changedAttibutes[ 'link' ][ '_cke_saved_href' ] )
				{
					this.editObj[ 'image' ].insertBeforeMe( this.editObj[ 'link' ] );	
					this.editObj[ 'image' ].appendTo( this.editObj[ 'link' ] );	
				
				}
				//Remove Link, Image exists.
				else if ( this.editMode[ 'link' ] == true && !this.changedAttibutes[ 'link' ][ '_cke_saved_href' ] )
				{
					//Remove link.
					//ohoho. later...
					/*
						a=this.editObj[ 'image' ];
						for(i in a)
						{
							alert(i+"---" + a[i] )
						}
					*/
				}
				else {};	//Image and Link already exists. Do nothing.
			}
	
			return true;
		},
		onShow : function()
		{
			// Default: create a new element.
			this.editObj = new Array();
			
			this.editMode = new Array();
			this.editMode[ 'link' ] = false;
			this.editMode[ 'image' ] = false;
			
			this.changedAttibutes = new Array();			
			this.changedAttibutes[ 'link' ] = new Array();
			this.changedAttibutes[ 'image' ] = new Array();
			
			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			// Check selection. Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				element = false;
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );
				rangeRoot = ranges[0].getCommonAncestor( true );
				
				elementImg = rangeRoot.getAscendant( 'img', true );
				elementA = rangeRoot.getAscendant( 'a', true );
				elementInput = rangeRoot.getAscendant( 'input', true );
				
				if ( elementImg )
					element = elementImg;
				else
					if ( elementA && elementA.getAttribute( 'href' ) )
						element = elementA;
					else
						if ( elementInput && elementInput.getAttribute( 'type' ) 
						&& elementInput.getAttribute( 'type' ) == 'image' )
							element = elementInput;
				
				if ( element )
				{
					loadElements.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( element );
					this.saveSelection();
				}
			}

			this.getContentElement( 'info', 'txtUrl' ).focus();
		},		
		onLoad : function( )
		{
			if ( !imageDialog )
				this.hidePage( 'Link' );		//Hide Link tab.

			if ( editor.config.imageUpload == false )
				this.hidePage( 'Upload' );		//Hide Upload tab.
		},	
		contents : [
			{
				id : 'info',
				label : editor.lang.dlgImgInfoTab,
				accessKey : 'I',
				elements :
				[
					{
						type : 'vbox',
						padding : 0,
						children :
						[
							{
								type : 'html',
								html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.dlgImgURL ) + '</span>'
							},
							{
								type : 'hbox',
								widths : [ '280px', '110px' ],
								align : 'right',
								children :
								[
									{
										id : 'txtUrl',
										type : 'text',
										label : '',
										validate: function()
										{
											addChange( 'src', this, 'image' );
											addChange( '_cke_saved_url', this, 'image' );
											return true;
										}
									},
									{
										type : 'button',
										id : 'browse',
										align : 'center',
										label : editor.lang.browseServer,
										onClick : function()
										{
											this.getDialog().setValueOf( "info", "txtUrl", "http://www.fckeditor.net/images/demo_screenshot.gif" );
											
										}
									}
								]
							}
						]
					},
					{
						id : 'txtAlt',
						type : 'text',
						label : editor.lang.dlgImgAlt,
						accessKey : 'A',
						validate: function()
						{
							addChange( 'alt', this, 'image' );
							return true;
						}
					},
					{
						type : 'hbox',
						widths : [ '140px', '240px' ],
						children :
						[
							{
								type : 'vbox',
								padding : 10,
								children :
								[
									{
										type : 'hbox',
										widths : [ '70%', '30%' ],
										children :
										[
											{
												type : 'vbox',
												padding : 1,
												children :
												[
													{
														type : 'text',
														id : 'txtWidth',
														labelLayout : 'horizontal',
														label : editor.lang.dlgImgWidth,
														validate: function()
														{
															var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
															var isValid = func.apply( this );
															if ( isValid )
																addChange( 'width', this, 'image' );
															return isValid;
														}
													},
													{
														type : 'text',
														id : 'txtHeight',
														labelLayout : 'horizontal',
														label : editor.lang.dlgImgHeight,
														validate: function()
														{
															var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
															var isValid = func.apply( this );
															if ( isValid )
																addChange( 'height', this, 'image' );
															return isValid;
														}
													}
												]
											},
											{
												type : 'html',
												style : 'position:relative;top:-10px;height:20px',	
												html : '<div>'+
													'<div onclick="" title="' + editor.lang.dlgImgLockRatio + '" onmouseout="this.className = (true ? \'BtnLocked\' : \'BtnUnlocked\' );" '+ 'onmouseover="this.className = (true ? \'BtnLocked\' : \'BtnUnlocked\' ) + \' BtnOver\';" class="BtnLocked" id="btnLockSizes"></div>' +
													'<div onclick="" title="' + editor.lang.dlgBtnResetSize + '" onmouseout="this.className=\'BtnReset\';" onmouseover="this.className=\'BtnReset BtnOver\';" class="BtnReset" id="btnResetSize"></div>'+
													'</div>'
											}
										]
									},
									{
										type : 'vbox',
										padding : 1,
										children :
										[
											{
												type : 'text',
												id : 'txtBorder',
												labelLayout : 'horizontal',
												label : editor.lang.dlgImgBorder,
												validate: function()
												{
													var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
													var isValid = func.apply( this );
													if ( isValid )
														addChange( 'border', this, 'image' );
													return isValid;
												}
											},
											{
												type : 'text',
												id : 'txtHSpace',
												labelLayout : 'horizontal',
												label : editor.lang.dlgImgHSpace,
												validate: function()
												{
													var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
													var isValid = func.apply( this );
													if ( isValid )
														addChange( 'hspace', this, 'image' );
													return isValid;
												}
											},
											{
												type : 'text',
												id : 'txtVSpace',
												labelLayout : 'horizontal',
												label : editor.lang.dlgImgVSpace,
												validate: function()
												{
													var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
													var isValid = func.apply( this );
													if ( isValid )
														addChange( 'vspace', this, 'image' );
													return isValid;
												}
											},
											{
												id : 'cmbAlign',
												type : 'select',
												labelLayout : 'horizontal',
												widths : [ '35%','65%' ],
												style : 'width:100%',
												label : editor.lang.dlgImgAlign,
												items :
												[
													[ editor.lang.dlgGenNotSet , ''],
													[ editor.lang.dlgImgAlignLeft , 'left'],
													[ editor.lang.dlgImgAlignAbsBottom , 'absBottom'],
													[ editor.lang.dlgImgAlignAbsMiddle , 'absMiddle'],
													[ editor.lang.dlgImgAlignBaseline , 'baseline'],
													[ editor.lang.dlgImgAlignBottom , 'bottom'],
													[ editor.lang.dlgImgAlignMiddle , 'middle'],
													[ editor.lang.dlgImgAlignRight , 'right'],
													[ editor.lang.dlgImgAlignTextTop , 'textTop'],
													[ editor.lang.dlgImgAlignTop , 'top']
												],
												validate: function()
												{
													addChange( 'align', this, 'image' );
													return true;
												}
											}
										]
									}
								]
							},
							{
								type : 'vbox',
								height : '250px',
								children :
								[
									{
										type : 'html',
										style : 'width:95%;',
										html: '<div>' + CKEDITOR.tools.htmlEncode( editor.lang.dlgImgPreview ) +
											'<div id="ImagePreviewBox" style="border: 1px solid black;height:160px"></div>'+
											'</div>'
									}
								]
							}
						]
					}
				]
			},
			{
				id : 'Link',
				label : editor.lang.linkTitle,
				padding : 0,
				elements :
				[
					{
						id : 'txtUrl',
						type : 'text',
						label : editor.lang.dlgImgURL,
						style : 'width: 100%',
						validate: function()
						{
							addChange( '_cke_saved_href', this, 'link' );
							return true;
						}
					},
					{
						type : 'button',
						id : 'browse',
						style : 'float:right',
						label : editor.lang.browseServer,
						onClick : function()
						{
							this.getDialog().setValueOf( "Link", "txtUrl", "http://www.fckeditor.net/" );
							
						}
					},
					{
						id : 'cmbTarget',
						type : 'select',
						label : editor.lang.linkTarget,
						items :
						[
							[ editor.lang.linkTargetNotSet , ''],
							[ editor.lang.linkTargetNew , '_blank'],
							[ editor.lang.linkTargetTop , '_top'],
							[ editor.lang.linkTargetSelf , '_self'],
							[ editor.lang.linkTargetParent , '_parent']
						],
						validate: function()
						{
							addChange( 'target', this, 'link' );
							return true;
						}
					}
				]
			},
			{
				id : 'Upload',
				label : editor.lang.dlgImgUpload,
				elements :
				[
					{
						type : 'file',
						id : 'upload',
						label : editor.lang.dlgImgBtnUpload,
						action : uploadAction,
						size : 38
					},
					{
						type : 'fileButton',
						id : 'uploadButton',
						label : editor.lang.dlgImgBtnUpload,
						'for' : [ 'Upload', 'upload' ]
					}
				]
			},
			{
				id : 'advanced',
				label : editor.lang.dlgDivAdvancedTab,
				elements :
				[
					{
						type : 'hbox',
						widths : [ '50%', '25%', '25%' ],
						children :
						[
							{
								type : 'text',
								id : 'linkId',
								label : editor.lang.dlgGenId,
								validate : function()
								{
									addChange( 'id', this, 'image' );
									return true;
								}
							},
							{
								id : 'cmbLangDir',
								type : 'select',
								label : editor.lang.dlgGenLangDir,
								style : 'width : 100%;',
								items :
								[
									[ editor.lang.dlgGenNotSet, '' ],
									[ editor.lang.dlgGenLangDirLtr, 'ltr' ],
									[ editor.lang.dlgGenLangDirRtl, 'rtl' ]
								],
								validate : function()
								{
									addChange( 'dir', this, 'image' );
									return true;
								}
							},
							{
								type : 'text',
								id : 'txtLangCode',
								label : editor.lang.dlgGenLangCode,
								validate : function()
								{
									addChange( 'lang', this, 'image' );
									return true;
								}
							}
						]
					},
					{
						type : 'text',
						id : 'txtGenLongDescr',
						label : editor.lang.dlgGenLongDescr,
						validate : function()
						{
							addChange( 'longdesc', this, 'image' );
							return true;
						}
					},
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								type : 'text',
								id : 'txtGenClass',
								label : editor.lang.dlgGenClass,
								validate : function()
								{
									addChange( 'class', this, 'image' );
									return true;
								}
							},
							{
								type : 'text',
								id : 'txtGenTitle',
								label : editor.lang.dlgGenTitle,
								validate : function()
								{
									addChange( 'title', this, 'image' );
									return true;
								}
							},
						]
					},
					{
						type : 'text',
						id : 'txtdlgGenStyle',
						label : editor.lang.dlgGenStyle,
						validate : function()
						{				
							addChange( 'style', this, 'image' );
							return true;
						}
					}
				]
			}
		]
	};
};

CKEDITOR.dialog.add( 'image', function( editor ){
		return imageDialog( editor, 'image' )
	}
);

CKEDITOR.dialog.add( 'imagebutton', function( editor ){
		return imageDialog( editor, 'imagebutton' )
	}
);
