/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.handlers;

import javax.servlet.http.HttpServletRequest;

import net.fckeditor.requestcycle.UserAction;
import net.fckeditor.requestcycle.UserPathBuilder;
import net.fckeditor.tool.Utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Handler for classes which implement the interfaces from package
 * {@link net.fckeditor.requestcycle}.
 * 
 * @version $Id: RequestCycleHandler.java 2796 2008-12-22 22:40:36Z mosipov $
 */
public class RequestCycleHandler {
	private static Logger logger = LoggerFactory
			.getLogger(RequestCycleHandler.class);
	private static UserAction userAction = null;
	private static UserPathBuilder userPathBuilder = null;

	static {
		// If there are more objects to instantiate in future, we could solve
		// the following by reflection!

		// 1. try to instantiate the UserAction object
		String className = PropertiesLoader.getUserActionImpl();
		if (Utils.isEmpty(className))
			logger.error("Empty UserAction implementation class name provided");
		else {
			try {
				Class<?> clazz = Class.forName(className);
				userAction = (UserAction) clazz.newInstance();
				logger.info("UserAction initialized to {}", className);
			} catch (Exception e) {
				logger
						.error(
								"UserAction implementation {} could not be instantiated",
								className);
				// TODO should be throw a RuntimeException here
			}
		}

		// 2. try to instantiate the UserPathBuilder object
		className = PropertiesLoader.getUserPathsBuilderImpl();
		if (Utils.isEmpty(className))
			logger
					.error("Empty UserPathsBuilder implementation class name provided");
		else {
			try {
				Class<?> clazz = Class.forName(className);
				userPathBuilder = (UserPathBuilder) clazz.newInstance();
				logger.info("UserPathsBuilder initialized to {}", className);
			} catch (Exception e) {
				logger
						.error(
								"UserPathsBuilder implementation {} could not be instantiated",
								className);
				// TODO should be throw a RuntimeException here
			}
		}
	}

	/**
	 * Just a wrapper to {@link UserAction#isEnabledForFileBrowsing()}.
	 * 
	 * @return {@link UserAction#isEnabledForFileBrowsing()} or false if
	 *         {@link UserAction} isn't set.
	 */
	public static boolean isEnabledForFileBrowsing(
			final HttpServletRequest request) {
		return (userAction != null && userAction
				.isEnabledForFileBrowsing(request));
	}

	/**
	 * Just a wrapper to {@link UserAction#isEnabledForFileUpload()}.
	 * 
	 * @return {@link UserAction#isEnabledForFileUpload()} or false if
	 *         {@link UserAction} isn't set.
	 */
	public static boolean isEnabledForFileUpload(
			final HttpServletRequest request) {
		return (userAction != null && userAction
				.isEnabledForFileUpload(request));
	}

	/**
	 * Just a wrapper to {@link UserAction#isEnabledForFolderCreation()}.
	 * 
	 * @return {@link UserAction#isEnabledForFolderCreation()} or false if
	 *         {@link UserAction} isn't set.
	 */
	public static boolean isCreateFolderEnabled(
			final HttpServletRequest request) {
		return (userAction != null && userAction
				.isCreateFolderEnabled(request));
	}

	/**
	 * Getter for the <code>UserFilesPath</code>.<br />
	 * Method is used by other handlers only!
	 * 
	 * @param request
	 * @return {@link UserPathBuilder#getUserFilesPath()} or <code>null</code>
	 *         if <code>userPathBuilder</code> is <code>null</code>.
	 */
	public static String getUserFilesPath(final HttpServletRequest request) {
		return (userPathBuilder != null) ? userPathBuilder
				.getUserFilesPath(request) : null;
	}

	/**
	 * 
	 * @param request
	 * @return
	 */
	public static String getUserFilesAbsolutePath(
			final HttpServletRequest request) {
		return (userPathBuilder != null) ? userPathBuilder
				.getUserFilesAbsolutePath(request) : null;
	}
}
