/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

imageDialog = function( editor, dialogType )
{
	var regexSize = /^\s*(\d+)(px)?\s*$/i;
	var uploadAction = 'nowhere.php';
	var imageDialog = ( dialogType == 'image' );

	var addChange = function( name, input, object ){
		var dialog = input.getDialog();
		
		if ( input.isChanged() || ( dialog.editMode[ object ] == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ object ][ name ] = input.getValue();
			return true;
		}
		return false;
	};

	var onUrlChange = function( input )
	{
		var dialog = input.getDialog();
		var editor = dialog.getParentEditor();

		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		updateOriginal( dialog, true );
		updatePreview( dialog );
	}

	var onSizeChange = function( input )
	{
		var dialog = input.getDialog();
		var editor = dialog.getParentEditor();

		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		// Only if ratio locked
		if ( dialog.imageLockRatio )
		{
			var oImageOriginal = dialog.editObj[ 'imageOriginal' ];
			if ( oImageOriginal && oImageOriginal.getCustomData( 'isReady' ) == 'true' )
			{
				var value = input.getValue();
				if ( input.id == 'txtHeight' ){
					dialog.allowOnChange = false;
					if ( value != '' && value != 0 )
						value = Math.round( oImageOriginal.$.height * ( value  / oImageOriginal.$.width ) );
					// Image loaded but with unknow size.
					if ( !isNaN( value ) )
						dialog.setValueOf( 'info', 'txtWidth', value );
					dialog.allowOnChange = true;
				}
				else		//input.id = txtWidth.
				{
					dialog.allowOnChange = false;
					if ( value != '' && value != 0 )
						value = Math.round( oImageOriginal.$.height * ( value  / oImageOriginal.$.width ) );
					if ( !isNaN( value ) )
						dialog.setValueOf( 'info', 'txtHeight', value );
					dialog.allowOnChange = true;
				}
			}
		}
		updatePreview( dialog );
	}

	var updatePreview = function( dialog )
	{
		return 0;
	}

	var updateOriginal = function( dialog, forceResetSize )
	{
		var editor = dialog.getParentEditor();
		var url = dialog.getContentElement( 'info', 'txtUrl' ).getValue()

		dialog.editObj[ 'imageOriginal' ].setCustomData( 'isReady', 'false' );
		if ( dialog.editObj && url.length>0 )
		{
			dialog.editObj[ 'imageOriginal' ].on( 'load', function()
				{
					//Image is ready.
					this.editObj[ 'imageOriginal' ].setCustomData( 'isReady', 'true' );
					this.editObj[ 'imageOriginal' ].removeListener( 'load' );
					if ( forceResetSize ){
						resetSize( this );
					}
				}, dialog );
			dialog.editObj[ 'imageOriginal' ].setAttribute( 'src', url );
		}
	}

	var switchLockRatio = function( dialog )
	{
		dialog.imageLockRatio = !dialog.imageLockRatio;
		return 0;
	}

	var resetSize = function( dialog )
	{
		var oImageOriginal = dialog.editObj[ 'imageOriginal' ];
		if ( oImageOriginal && oImageOriginal.getCustomData( 'isReady' ) == 'true' )
		{
			dialog.allowOnChange = false;
			dialog.setValueOf( 'info', 'txtWidth', oImageOriginal.$.width );
			dialog.setValueOf( 'info', 'txtHeight', oImageOriginal.$.height );
			dialog.allowOnChange = true;
		}
		updatePreview( dialog );
	}
	var readSize = function( dialog )
	{
		var heightText = '';
		var widthText = '';

		// Read height.
		if ( dialog.editObj[ 'image' ].getAttribute( 'height' ) )
		{
			var aMatchH  =  dialog.editObj[ 'image' ].getAttribute( 'height' ).match( regexSize );
			if ( aMatchH )
			{
				dialog.imageDimenstions[ 'height' ] = aMatchH[1];
				heightText = aMatchH[1];
			}
		}

		// Read width.
		if ( dialog.editObj[ 'image' ].getAttribute( 'width' ) )
		{
			var aMatchW  =  dialog.editObj[ 'image' ].getAttribute( 'width' ).match( regexSize );
			if ( aMatchW )
			{
				dialog.imageDimenstions[ 'width' ] = aMatchW[1];
				widthText = aMatchW[1];
			}
		}

		//TODO: read styles
		
		var allow = dialog.allowOnChange;
		dialog.allowOnChange = false;
		dialog.setValueOf( 'info', 'txtHeight', heightText );
		dialog.setValueOf( 'info', 'txtWidth', widthText );
		dialog.allowOnChange = allow;
	}

	// Function called in onShow to load selected element.
	var loadElements = function( editor, selection, ranges, element )
	{
		this.editObj[ 'image' ] = false;
		this.editMode[ 'image' ] = false;		// Default:  Create a new Image
		this.saveSelection();

		this.setValueOf( "Link", "txtUrl", "" );
		this.setValueOf( "Link", "cmbTarget", "" );

		// Link is selected.
		if ( element.$.tagName.toLowerCase() == 'a' )
		{
			this.editObj[ 'link' ] = element;
			this.editMode[ 'link' ] = true;

			// Look for Image element.
			var linkChildren = element.getChildren();
			if ( linkChildren.count() == 1 ){		// 1 child.
				var childTagName = linkChildren.getItem( 0 ).$.tagName.toLowerCase();
				if ( childTagName == 'img' || childTagName == 'input' )
				{
					this.editMode[ 'image' ] = true;
					this.editObj[ 'image' ] = linkChildren.getItem( 0 );
				}
			}

			if ( imageDialog )
			{
				// Fill out all fields.
				readAttribute.apply( this, [ 'Link', 'target', 'cmbTarget', element ] );
				if ( !readAttribute.apply( this, [ 'Link', '_cke_saved_href', 'txtUrl', element ] ) )
					readAttribute.apply( this, [ 'Link', 'href', 'txtUrl', element ] )
			}
		}

		if ( element.$.tagName.toLowerCase() == 'img' || element.$.tagName.toLowerCase() == 'input' || this.editObj[ 'image' ] )
		{
			this.editMode[ 'image' ] = true;
			if ( !this.editObj[ 'image' ] )
				this.editObj[ 'image' ] = element;

			updateOriginal( this, true );
			readSize( this );

			var imgObject = this.editObj[ 'image' ];
			
			// Fill out all fields.
			if ( !readAttribute.apply( this, [ 'info', '_cke_saved_url', 'txtUrl', imgObject ] ) )
				readAttribute.apply( this, [ 'info', 'src', 'txtUrl', imgObject ] )
	
			readAttribute.apply( this, [ 'info', 'alt', 'txtAlt', imgObject ] );
			readAttribute.apply( this, [ 'info', 'border', 'txtBorder', imgObject  ] );
			readAttribute.apply( this, [ 'info', 'hspace', 'txtHSpace', imgObject ] );
			readAttribute.apply( this, [ 'info', 'vspace', 'txtVSpace', imgObject ] );
			readAttribute.apply( this, [ 'info', 'align', 'cmbAlign', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'id', 'linkId', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'dir', 'cmbLangDir', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'lang', 'txtLangCode', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'longdesc', 'txtGenLongDescr', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'class', 'txtGenClass', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'style', 'txtdlgGenStyle', imgObject ] );	
			readAttribute.apply( this, [ 'advanced', 'title', 'txtGenTitle', imgObject ] );
		}

		return false;
	};
	
	var readAttribute = function( page, attribute, input, object )
	{
		var attributeValue = object.getAttribute( attribute );
		if ( attributeValue == null )
			this.setValueOf( page, input, "" );
		else
			this.setValueOf( page, input, attributeValue );

		return attributeValue;
	}

	return {
		title : ( imageDialog ) ? editor.lang.dlgImgTitle : editor.lang.imageButtonProp,
		minWidth : 450,
		minHeight : 400,
		onOk : function()
		{
			this.allowOnChange = true;
			
			var useLink = false;
			var removeObj = false;

			// Edit existing Image.
			if ( this.editMode[ 'image' ] )
			{
				var imgTagName = this.editObj[ 'image' ].$.tagName.toLowerCase();
				
				// Image dialog and Input element.
				if ( imageDialog && imgTagName == 'input' && confirm( editor.lang.dlgImgButton2Img ) )
				{
					// Replace INPUT-> IMG
					removeObj = this.editObj[ 'image' ];
					this.editObj[ 'image' ] = editor.document.createElement( 'img' );
					removeObj.insertBeforeMe( this.editObj[ 'image' ] );
					removeObj.remove( false );
					imgTagName = 'img';
				}
				// ImageButton dialog and Image element.
				else if ( !imageDialog && imgTagName == 'img' && confirm( editor.lang.dlgImgImg2Button ))
				{
					// Replace IMG -> INPUT
					removeObj = this.editObj[ 'image' ];
					this.editObj[ 'image' ] = editor.document.createElement( 'input' );
					this.editObj[ 'image' ].setAttribute ( 'type' ,'image' );
					removeObj.insertBeforeMe( this.editObj[ 'image' ] );
					removeObj.remove( false );
					imgTagName = 'input';
				}
			}
			else	// Create a new image.
			{
				// Image dialog -> create IMG element.
				if ( imageDialog )
					this.editObj[ 'image' ] = editor.document.createElement( 'img' );
				else
				{
					this.editObj[ 'image' ] = editor.document.createElement( 'input' );
					this.editObj[ 'image' ].setAttribute ( 'type' ,'image' );
				}
			}

			// Create a new link.
			if ( this.editMode[ 'link' ] == false )
				this.editObj[ 'link' ] = editor.document.createElement( 'a' );

			// Set image attributes.
			this.editObj[ 'image' ].setAttributes( this.changedAttibutes[ 'image' ] );

			// Set link attributes.
			this.changedAttibutes[ 'link' ][ 'href' ] =  'javascript:void(0)/*' + CKEDITOR.tools.getNextNumber() + '*/';
			this.editObj[ 'link' ].setAttributes( this.changedAttibutes[ 'link' ] );
			
			if ( this.editObj[ 'link' ].getAttribute( '_cke_saved_href' ) 
				&& this.editObj[ 'link' ].getAttribute( '_cke_saved_href' ) != '' )
				useLink = true;

			// Insert a new Image.
			if ( this.editMode[ 'image' ] == false )
			{
				// It doesn't work with IE.
				this.restoreSelection();
				this.clearSavedSelection();
				
				if ( useLink )
					//Insert a new Link.
					if ( this.editMode[ 'link' ] == false )
					{
						this.editObj[ 'link' ].append( this.editObj[ 'image' ], false );
						editor.insertElement( this.editObj[ 'link' ] );
					}
					else 	//Link already exists, image not.
						this.editObj[ 'link' ].append( this.editObj[ 'image' ], false );
				else
					editor.insertElement( this.editObj[ 'image' ] );
			}
			else		// Image already exists.	
			{
				//Add a new link element.
				if ( this.editMode[ 'link' ] == false && this.changedAttibutes[ 'link' ][ '_cke_saved_href' ] )
				{
					this.editObj[ 'image' ].insertBeforeMe( this.editObj[ 'link' ] );	
					this.editObj[ 'image' ].appendTo( this.editObj[ 'link' ] );	
				}
				//Remove Link, Image exists.
				else if ( this.editMode[ 'link' ] == true && !this.changedAttibutes[ 'link' ][ '_cke_saved_href' ] )
					this.editObj[ 'link' ].remove( true );
			}

			this.allowOnChange = false;		// Don't load onChange before onShow.

			return true;
		},
		onShow : function()
		{
			//Don't call onShow before onShow.
			this.allowOnChange = false;

			this.editObj = new Array();
			this.editObj[ 'image' ] = false;
			this.editObj[ 'link' ] = false;
			this.editObj[ 'imageOriginal' ] = false;		//TODO: move it to preview area
			
			// Default: create a new element.
			this.editMode = new Array();
			this.editMode[ 'link' ] = false;
			this.editMode[ 'image' ] = false;

			this.changedAttibutes = new Array();			
			this.changedAttibutes[ 'link' ] = new Array();
			this.changedAttibutes[ 'image' ] = new Array();

			this.imageDimenstions  = new Array ();
			this.imageDimenstions['width'] = 0;
			this.imageDimenstions['height'] = 0;
			this.imageLockRatio = true;

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			// Copy of the image
			this.editObj[ 'imageOriginal' ] = editor.document.createElement( 'img' );
			this.editObj[ 'imageOriginal' ].setCustomData( 'isReady', 'false' );
			
			
			// Check selection. Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				element = false;
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );
				rangeRoot = ranges[0].getCommonAncestor( true );
				
				elementImg = rangeRoot.getAscendant( 'img', true );
				elementA = rangeRoot.getAscendant( 'a', true );
				elementInput = rangeRoot.getAscendant( 'input', true );
				
				if ( elementImg )
					element = elementImg;
				else
					if ( elementA && elementA.getAttribute( 'href' ) )
						element = elementA;
					else
						if ( elementInput && elementInput.getAttribute( 'type' ) 
						&& elementInput.getAttribute( 'type' ) == 'image' )
							element = elementInput;
				
				if ( element )
				{
					loadElements.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( element );
					this.saveSelection();
					this.pushDefault();
				}
			}
			updateOriginal( this, false );
			updatePreview( this );

			this.allowOnChange = true;

			this.getContentElement( 'info', 'txtUrl' ).focus();
		},		
		onLoad : function( )
		{
			if ( !imageDialog )
				this.hidePage( 'Link' );		//Hide Link tab.

			if ( editor.config.imageUpload == false )
				this.hidePage( 'Upload' );		//Hide Upload tab.
		},	
		onHide : function()
		{
			// Don't call onChange before onShow.
			this.allowOnChange = false;

			// Pop the default values from default value set that are pushed in onShow().
			this.popDefault();
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.dlgImgInfoTab,
				accessKey : 'I',
				elements :
				[
					{
						type : 'vbox',
						padding : 0,
						children :
						[
							{
								type : 'html',
								html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.dlgImgURL ) + '</span>'
							},
							{
								type : 'hbox',
								widths : [ '280px', '110px' ],
								align : 'right',
								children :
								[
									{
										id : 'txtUrl',
										type : 'text',
										label : '',
										validate: function()
										{
											addChange( 'src', this, 'image' );
											addChange( '_cke_saved_url', this, 'image' );
											return true;
										},
										onChange : function(){
											onUrlChange( this );
										}
									},
									{
										type : 'button',
										id : 'browse',
										align : 'center',
										label : editor.lang.browseServer,
										onClick : function()
										{
											this.getDialog().setValueOf( "info", "txtUrl", "http://www.fckeditor.net/images/demo_screenshot.gif" );
										}
									}
								]
							}
						]
					},
					{
						id : 'txtAlt',
						type : 'text',
						label : editor.lang.dlgImgAlt,
						accessKey : 'A',
						validate: function()
						{
							addChange( 'alt', this, 'image' );
							return true;
						}
					},
					{
						type : 'hbox',
						widths : [ '140px', '240px' ],
						children :
						[
							{
								type : 'vbox',
								padding : 10,
								children :
								[
									{
										type : 'hbox',
										widths : [ '70%', '30%' ],
										children :
										[
											{
												type : 'vbox',
												padding : 1,
												children :
												[
													{
														type : 'text',
														id : 'txtWidth',
														labelLayout : 'horizontal',
														label : editor.lang.dlgImgWidth,
														onChange : function()
														{
															onSizeChange( this );
														},
														validate: function()
														{
															var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
															var isValid = func.apply( this );
															if ( isValid )
																addChange( 'width', this, 'image' );
															return isValid;
														}
													},
													{
														type : 'text',
														id : 'txtHeight',
														labelLayout : 'horizontal',
														label : editor.lang.dlgImgHeight,
														onChange : function()
														{
															onSizeChange( this );
														},
														validate: function()
														{
															var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
															var isValid = func.apply( this );
															if ( isValid )
																addChange( 'height', this, 'image' );
															return isValid;
														}
													}
												]
											},
											{
												type : 'html',
												style : 'position:relative;top:-10px;height:20px',	
												html : '<div>'+
													'<div onclick="" title="' + editor.lang.dlgImgLockRatio + '" onmouseout="this.className = (true ? \'BtnLocked\' : \'BtnUnlocked\' );" '+ 'onmouseover="this.className = (true ? \'BtnLocked\' : \'BtnUnlocked\' ) + \' BtnOver\';" class="BtnLocked" id="btnLockSizes"></div>' +
													'<div onclick="" title="' + editor.lang.dlgBtnResetSize + '" onmouseout="this.className=\'BtnReset\';" onmouseover="this.className=\'BtnReset BtnOver\';" class="BtnReset" id="btnResetSize"></div>'+
													'</div>'
											}
										]
									},
									{
										type : 'vbox',
										padding : 1,
										children :
										[
											{
												type : 'text',
												id : 'txtBorder',
												labelLayout : 'horizontal',
												label : editor.lang.dlgImgBorder,
												validate: function()
												{
													var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
													var isValid = func.apply( this );
													if ( isValid )
														addChange( 'border', this, 'image' );
													return isValid;
												}
											},
											{
												type : 'text',
												id : 'txtHSpace',
												labelLayout : 'horizontal',
												label : editor.lang.dlgImgHSpace,
												validate: function()
												{
													var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
													var isValid = func.apply( this );
													if ( isValid )
														addChange( 'hspace', this, 'image' );
													return isValid;
												}
											},
											{
												type : 'text',
												id : 'txtVSpace',
												labelLayout : 'horizontal',
												label : editor.lang.dlgImgVSpace,
												validate: function()
												{
													var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
													var isValid = func.apply( this );
													if ( isValid )
														addChange( 'vspace', this, 'image' );
													return isValid;
												}
											},
											{
												id : 'cmbAlign',
												type : 'select',
												labelLayout : 'horizontal',
												widths : [ '35%','65%' ],
												style : 'width:100%',
												label : editor.lang.dlgImgAlign,
												items :
												[
													[ editor.lang.dlgGenNotSet , ''],
													[ editor.lang.dlgImgAlignLeft , 'left'],
													[ editor.lang.dlgImgAlignAbsBottom , 'absBottom'],
													[ editor.lang.dlgImgAlignAbsMiddle , 'absMiddle'],
													[ editor.lang.dlgImgAlignBaseline , 'baseline'],
													[ editor.lang.dlgImgAlignBottom , 'bottom'],
													[ editor.lang.dlgImgAlignMiddle , 'middle'],
													[ editor.lang.dlgImgAlignRight , 'right'],
													[ editor.lang.dlgImgAlignTextTop , 'textTop'],
													[ editor.lang.dlgImgAlignTop , 'top']
												],
												validate: function()
												{
													addChange( 'align', this, 'image' );
													return true;
												}
											}
										]
									}
								]
							},
							{
								type : 'vbox',
								height : '250px',
								children :
								[
									{
										type : 'html',
										style : 'width:95%;',
										html: '<div>' + CKEDITOR.tools.htmlEncode( editor.lang.dlgImgPreview ) +
											'<div id="ImagePreviewBox" style="border: 1px solid black;height:160px"></div>'+
											'</div>'
									}
								]
							}
						]
					}
				]
			},
			{
				id : 'Link',
				label : editor.lang.linkTitle,
				padding : 0,
				elements :
				[
					{
						id : 'txtUrl',
						type : 'text',
						label : editor.lang.dlgImgURL,
						style : 'width: 100%',
						validate: function()
						{
							addChange( '_cke_saved_href', this, 'link' );
							return true;
						}
					},
					{
						type : 'button',
						id : 'browse',
						style : 'float:right',
						label : editor.lang.browseServer,
						onClick : function()
						{
							this.getDialog().setValueOf( "Link", "txtUrl", "http://www.fckeditor.net/" );
							
						}
					},
					{
						id : 'cmbTarget',
						type : 'select',
						label : editor.lang.linkTarget,
						items :
						[
							[ editor.lang.linkTargetNotSet , ''],
							[ editor.lang.linkTargetNew , '_blank'],
							[ editor.lang.linkTargetTop , '_top'],
							[ editor.lang.linkTargetSelf , '_self'],
							[ editor.lang.linkTargetParent , '_parent']
						],
						validate: function()
						{
							addChange( 'target', this, 'link' );
							return true;
						}
					}
				]
			},
			{
				id : 'Upload',
				label : editor.lang.dlgImgUpload,
				elements :
				[
					{
						type : 'file',
						id : 'upload',
						label : editor.lang.dlgImgBtnUpload,
						action : uploadAction,
						size : 38
					},
					{
						type : 'fileButton',
						id : 'uploadButton',
						label : editor.lang.dlgImgBtnUpload,
						'for' : [ 'Upload', 'upload' ]
					}
				]
			},
			{
				id : 'advanced',
				label : editor.lang.dlgDivAdvancedTab,
				elements :
				[
					{
						type : 'hbox',
						widths : [ '50%', '25%', '25%' ],
						children :
						[
							{
								type : 'text',
								id : 'linkId',
								label : editor.lang.dlgGenId,
								validate : function()
								{
									addChange( 'id', this, 'image' );
									return true;
								}
							},
							{
								id : 'cmbLangDir',
								type : 'select',
								label : editor.lang.dlgGenLangDir,
								style : 'width : 100%;',
								items :
								[
									[ editor.lang.dlgGenNotSet, '' ],
									[ editor.lang.dlgGenLangDirLtr, 'ltr' ],
									[ editor.lang.dlgGenLangDirRtl, 'rtl' ]
								],
								validate : function()
								{
									addChange( 'dir', this, 'image' );
									return true;
								}
							},
							{
								type : 'text',
								id : 'txtLangCode',
								label : editor.lang.dlgGenLangCode,
								validate : function()
								{
									addChange( 'lang', this, 'image' );
									return true;
								}
							}
						]
					},
					{
						type : 'text',
						id : 'txtGenLongDescr',
						label : editor.lang.dlgGenLongDescr,
						validate : function()
						{
							addChange( 'longdesc', this, 'image' );
							return true;
						}
					},
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								type : 'text',
								id : 'txtGenClass',
								label : editor.lang.dlgGenClass,
								validate : function()
								{
									addChange( 'class', this, 'image' );
									return true;
								}
							},
							{
								type : 'text',
								id : 'txtGenTitle',
								label : editor.lang.dlgGenTitle,
								validate : function()
								{
									addChange( 'title', this, 'image' );
									return true;
								}
							},
						]
					},
					{
						type : 'text',
						id : 'txtdlgGenStyle',
						label : editor.lang.dlgGenStyle,
						validate : function()
						{				
							addChange( 'style', this, 'image' );
							return true;
						}
					}
				]
			}
		]
	};
};

CKEDITOR.dialog.add( 'image', function( editor ){
		return imageDialog( editor, 'image' )
	}
);

CKEDITOR.dialog.add( 'imagebutton', function( editor ){
		return imageDialog( editor, 'imagebutton' )
	}
);
