/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

imageDialog = function( editor, dialogType )
{
	var uploadAction = 'nowhere.php';
	var regexSize = /^\s*(\d+)((px)|\%)?\s*$/i;
	var imageDialog = ( dialogType == 'image' );
	var previewAreaHtml = '<div>' + CKEDITOR.tools.htmlEncode( editor.lang.dlgImgPreview ) +'<br>'+
		'<div id="ImagePreviewLoader" style="display:none"><div class="loading">&nbsp;</div></div>'+
		'<div id="ImagePreviewBox">'+
		'<a href="javascript:void(0)" target="_blank" onclick="return false;" id="previewLink"><img id="previewImage" src="" /></a>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Maecenas feugiat consequat diam. Maecenas metus. Vivamus diam purus, cursus a, commodo non, facilisis vitae, nulla. Aenean dictum lacinia tortor. Nunc iaculis, nibh non iaculis aliquam, orci felis euismod neque, sed ornare massa mauris sed velit. Nulla pretium mi et risus. Fusce mi pede, tempor id, cursus ac, ullamcorper nec, enim. Sed tortor. Curabitur molestie. Duis velit augue, condimentum at, ultrices a, luctus ut, orci. Donec pellentesque egestas eros. Integer cursus, augue in cursus faucibus, eros pede bibendum sem, in tempus tellus justo quis ligula. Etiam eget tortor. Vestibulum rutrum, est ut placerat elementum, lectus nisl aliquam velit, tempor aliquam eros nunc nonummy metus. In eros metus, gravida a, gravida sed, lobortis id, turpis. Ut ultrices, ipsum at venenatis fringilla, sem nulla lacinia tellus, eget aliquet turpis mauris non enim. Nam turpis. Suspendisse lacinia. Curabitur ac tortor ut ipsum egestas elementum. Nunc imperdiet gravida mauris.' +
		'</div>'+'</div>';

	var addChange = function( name, input, object ){
		var dialog = input.getDialog();
		
		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		if ( input.isChanged() || ( dialog.editMode[ object ] == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ object ][ name ] = input.getValue();
			return true;
		}
		return false;
	};

	var onUrlChange = function( input )
	{
		var dialog = input.getDialog();

		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		updateOriginal( dialog, true );	// true = reset size.
		updatePreview( dialog );
	}

	var onSizeChange = function( input )
	{
		var dialog = input.getDialog();
		var value = input.getValue();

		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		// Check value
		var aMatch  =  value.match( regexSize );
		if ( aMatch )
		{
			// % is allowed - > unlock ratio.
			if ( aMatch[2] == '%' )
				switchLockRatio( dialog, false );	// Unlock.
			value = aMatch[1];
		}

		// Only if ratio is locked
		if ( dialog.imageLockRatio )
		{
			var oImageOriginal = dialog.editObj[ 'imageOriginal' ];
			if ( oImageOriginal && oImageOriginal.getCustomData( 'isReady' ) == 'true' )
			{
				if ( input.id == 'txtHeight' ){
					dialog.allowOnChange = false;
					if ( value != '' && value != 0 )
						value = Math.round( oImageOriginal.$.width * ( value  / oImageOriginal.$.height ) );
					if ( !isNaN( value ) )
						dialog.setValueOf( 'info', 'txtWidth', value );
					dialog.allowOnChange = true;
				}
				else		//input.id = txtWidth.
				{
					dialog.allowOnChange = false;
					if ( value != '' && value != 0 )
						value = Math.round( oImageOriginal.$.height * ( value  / oImageOriginal.$.width ) );
					if ( !isNaN( value ) )
						dialog.setValueOf( 'info', 'txtHeight', value );
					dialog.allowOnChange = true;
				}
			}
		}
		updatePreview( dialog );
	}

	var onChange = function( input, attribute )
	{
		var dialog = input.getDialog();

		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		updatePreview( dialog );
	}

	var updatePreview = function( dialog )
	{
		if ( !dialog.editObj[ 'imagePreview' ] )
			return 1;

		var url = dialog.getContentElement( 'info', 'txtUrl' ).getValue();

		// New url
		if ( url != dialog.editObj[ 'imagePreview' ].getAttribute( 'src' ) )
			dialog.editObj[ 'imagePreview' ].setAttribute( 'src', url );
		
		var width = 0;
		var height = 0;
		var oImageOriginal = dialog.editObj[ 'imageOriginal' ];
			
		width = dialog.getValueOf( 'info', 'txtWidth' );
		height = dialog.getValueOf( 'info', 'txtHeight' );

		if ( width == '' && oImageOriginal )
			width = oImageOriginal.$.width;
		if ( height == '' && oImageOriginal )
			height = oImageOriginal.$.height;

		dialog.editObj[ 'imagePreview' ].setStyle( 'width', width + 'px');
		dialog.editObj[ 'imagePreview' ].setStyle( 'height', height + 'px');

		// Read attributes
		var border = dialog.getValueOf( 'info', 'txtBorder' );
		var hspace = dialog.getValueOf( 'info', 'txtHSpace' );
		var vspace = dialog.getValueOf( 'info', 'txtVSpace' );
		var align = dialog.getValueOf( 'info', 'cmbAlign' );
		var title = dialog.getValueOf( 'info', 'txtTitle' );
		
		// Validate values
		border = parseInt( border, 10 );
		hspace = parseInt( hspace, 10 );
		vspace = parseInt( vspace, 10 );

		border = isNaN( border ) ? 0 : border;
		hspace = isNaN( hspace ) ? 0 : hspace;
		vspace = isNaN( vspace ) ? 0 : vspace;

		// TODO. Doesn't work becouse of a:active{border 0px} from reset.css
		dialog.editObj[ 'imagePreview' ].setAttribute( 'border', border );
		dialog.editObj[ 'imagePreview' ].setAttribute( 'hspace', hspace );
		dialog.editObj[ 'imagePreview' ].setAttribute( 'vspace', vspace );

		dialog.editObj[ 'imagePreview' ].setAttribute( 'align', align );
		dialog.editObj[ 'imagePreview' ].setAttribute( 'align', title );

		dialog.editObj[ 'imagePreview' ].setStyle( 'border', border + 'px solid black' );
		dialog.editObj[ 'imagePreview' ].setStyle( 'margin-top', vspace + 'px' );
		dialog.editObj[ 'imagePreview' ].setStyle( 'margin-bottom', vspace + 'px' );
		dialog.editObj[ 'imagePreview' ].setStyle( 'margin-left', hspace + 'px' );
		dialog.editObj[ 'imagePreview' ].setStyle( 'margin-right', hspace + 'px' );
		return 0;
	}

	var updateOriginal = function( dialog, forceResetSize )
	{
		var editor = dialog.getParentEditor();
		var url = dialog.getContentElement( 'info', 'txtUrl' ).getValue()

		dialog.editObj[ 'imageOriginal' ].setCustomData( 'isReady', 'false' );
		if ( dialog.editObj && url.length > 0 )
		{
			// Show loader
			var loader = CKEDITOR.document.getById( 'ImagePreviewLoader' );
			if ( loader )
				loader.setStyle('display', '');

			dialog.editObj[ 'imageOriginal' ].on( 'load', function()
				{
					// Image is ready.
					this.editObj[ 'imageOriginal' ].setCustomData( 'isReady', 'true' );
					this.editObj[ 'imageOriginal' ].removeListener( 'load' );

					// Hide loader
					var loader = CKEDITOR.document.getById( 'ImagePreviewLoader' );
					if ( loader )
						loader.setStyle('display', 'none' );
			
					// New image -> new domensions
					if ( forceResetSize ){
						resetSize( this );
					}
				}, dialog );
			dialog.editObj[ 'imageOriginal' ].setAttribute( 'src', url );
		}
	}

	var switchLockRatio = function( dialog, value )
	{
 		if ( value != undefined )
			dialog.imageLockRatio = value
		else
			dialog.imageLockRatio = !dialog.imageLockRatio;

		var ratioButton = CKEDITOR.document.getById( 'btnLockSizes' );
		if ( dialog.imageLockRatio )
			ratioButton.removeClass( 'BtnUnlocked' );
		else
			ratioButton.addClass( 'BtnUnlocked' );

		return dialog.imageLockRatio;
	}

	var resetSize = function( dialog )
	{
		var oImageOriginal = dialog.editObj[ 'imageOriginal' ];
		if ( oImageOriginal && oImageOriginal.getCustomData( 'isReady' ) == 'true' )
		{
			dialog.allowOnChange = false;
			dialog.setValueOf( 'info', 'txtWidth', oImageOriginal.$.width );
			dialog.setValueOf( 'info', 'txtHeight', oImageOriginal.$.height );
			dialog.allowOnChange = true;
		}
		updatePreview( dialog );
	}
	var readSize = function( dialog )
	{
		var heightText = '';
		var widthText = '';

		// Read height.
		if ( dialog.editObj[ 'image' ].getAttribute( 'height' ) )
		{
			var aMatchH  =  dialog.editObj[ 'image' ].getAttribute( 'height' ).match( regexSize );
			if ( aMatchH )
			{
				// % is allowed.
				if ( aMatchH[2] == '%' )
					aMatchH[1] += '%';
				heightText = aMatchH[1];
			}
		}

		// Read width.
		if ( dialog.editObj[ 'image' ].getAttribute( 'width' ) )
		{
			var aMatchW  =  dialog.editObj[ 'image' ].getAttribute( 'width' ).match( regexSize );
			if ( aMatchW )
			{
				// % is allowed.
				if ( aMatchW[2] == '%' )
					aMatchW[1] += '%';
				widthText = aMatchW[1];
			}
		}

		// Refresh LockRatio button
		var btnLockSizes = CKEDITOR.document.getById( 'btnLockSizes' );
		if ( dialog.imageLockRatio )
			btnLockSizes.removeClass( 'BtnUnlocked' );
		else
			btnLockSizes.addClass( 'BtnUnlocked' );

		//TODO: read styles
		
		var allow = dialog.allowOnChange;
		dialog.allowOnChange = false;
		dialog.setValueOf( 'info', 'txtHeight', heightText );
		dialog.setValueOf( 'info', 'txtWidth', widthText );
		dialog.allowOnChange = allow;
	}

	// Function called in onShow to load selected element.
	var loadElements = function( editor, selection, ranges, element )
	{
		this.editObj[ 'image' ] = false;
		this.editMode[ 'image' ] = false;		// Default:  Create a new Image
		this.saveSelection();

		this.setValueOf( "Link", "txtUrl", "" );
		this.setValueOf( "Link", "cmbTarget", "" );

		// Link is selected.
		if ( element.$.tagName.toLowerCase() == 'a' )
		{
			this.editObj[ 'link' ] = element;
			this.editMode[ 'link' ] = true;

			// Look for Image element.
			var linkChildren = element.getChildren();
			if ( linkChildren.count() == 1 ){		// 1 child.
				var childTagName = linkChildren.getItem( 0 ).$.tagName.toLowerCase();
				if ( childTagName == 'img' || childTagName == 'input' )
				{
					this.editMode[ 'image' ] = true;
					this.editObj[ 'image' ] = linkChildren.getItem( 0 );
				}
			}

			if ( imageDialog )
			{
				// Fill out all fields.
				readAttribute.apply( this, [ 'Link', 'target', 'cmbTarget', element ] );
				if ( !readAttribute.apply( this, [ 'Link', '_cke_saved_href', 'txtUrl', element ] ) )
					readAttribute.apply( this, [ 'Link', 'href', 'txtUrl', element ] )
			}
		}

		if ( element.$.tagName.toLowerCase() == 'img' || element.$.tagName.toLowerCase() == 'input' || this.editObj[ 'image' ] )
		{
			this.editMode[ 'image' ] = true;
			if ( !this.editObj[ 'image' ] )
				this.editObj[ 'image' ] = element;

			updateOriginal( this, true );
			readSize( this );

			var imgObject = this.editObj[ 'image' ];

			// Fill out all fields.
			if ( !readAttribute.apply( this, [ 'info', '_cke_saved_url', 'txtUrl', imgObject ] ) )
				readAttribute.apply( this, [ 'info', 'src', 'txtUrl', imgObject ] )
	
			readAttribute.apply( this, [ 'info', 'alt', 'txtAlt', imgObject ] );
			readAttribute.apply( this, [ 'info', 'border', 'txtBorder', imgObject  ] );
			readAttribute.apply( this, [ 'info', 'hspace', 'txtHSpace', imgObject ] );
			readAttribute.apply( this, [ 'info', 'vspace', 'txtVSpace', imgObject ] );
			readAttribute.apply( this, [ 'info', 'align', 'cmbAlign', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'id', 'linkId', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'dir', 'cmbLangDir', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'lang', 'txtLangCode', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'longdesc', 'txtGenLongDescr', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'class', 'txtGenClass', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'style', 'txtdlgGenStyle', imgObject ] );	
			readAttribute.apply( this, [ 'advanced', 'title', 'txtGenTitle', imgObject ] );
		}
		updatePreview( this );

		return false;
	};
	
	var readAttribute = function( page, attribute, input, object )
	{
		var attributeValue = object.getAttribute( attribute );
		if ( attributeValue == null )
			this.setValueOf( page, input, "" );
		else
			this.setValueOf( page, input, attributeValue );

		return attributeValue;
	}

	return {
		title : ( imageDialog ) ? editor.lang.dlgImgTitle : editor.lang.imageButtonProp,
		minWidth : 450,
		minHeight : 400,
		onOk : function()
		{
			this.allowOnChange = true;

			var useLink = false;
			var removeObj = false;

			// Edit existing Image.
			if ( this.editMode[ 'image' ] )
			{
				var imgTagName = this.editObj[ 'image' ].$.tagName.toLowerCase();

				// Image dialog and Input element.
				if ( imageDialog && imgTagName == 'input' && confirm( editor.lang.dlgImgButton2Img ) )
				{
					// Replace INPUT-> IMG
					removeObj = this.editObj[ 'image' ];
					this.editObj[ 'image' ] = editor.document.createElement( 'img' );
					removeObj.insertBeforeMe( this.editObj[ 'image' ] );
					removeObj.remove( false );
					imgTagName = 'img';
				}
				// ImageButton dialog and Image element.
				else if ( !imageDialog && imgTagName == 'img' && confirm( editor.lang.dlgImgImg2Button ))
				{
					// Replace IMG -> INPUT
					removeObj = this.editObj[ 'image' ];
					this.editObj[ 'image' ] = editor.document.createElement( 'input' );
					this.editObj[ 'image' ].setAttribute ( 'type' ,'image' );
					removeObj.insertBeforeMe( this.editObj[ 'image' ] );
					removeObj.remove( false );
					imgTagName = 'input';
				}
			}
			else	// Create a new image.
			{
				// Image dialog -> create IMG element.
				if ( imageDialog )
					this.editObj[ 'image' ] = editor.document.createElement( 'img' );
				else
				{
					this.editObj[ 'image' ] = editor.document.createElement( 'input' );
					this.editObj[ 'image' ].setAttribute ( 'type' ,'image' );
				}
			}

			// Create a new link.
			if ( this.editMode[ 'link' ] == false )
				this.editObj[ 'link' ] = editor.document.createElement( 'a' );

			// Set image attributes.
			this.editObj[ 'image' ].setAttributes( this.changedAttibutes[ 'image' ] );

			// Set link attributes.
			this.changedAttibutes[ 'link' ][ 'href' ] =  'javascript:void(0)/*' + CKEDITOR.tools.getNextNumber() + '*/';
			this.editObj[ 'link' ].setAttributes( this.changedAttibutes[ 'link' ] );

			if ( this.editObj[ 'link' ].getAttribute( '_cke_saved_href' ) 
				&& this.editObj[ 'link' ].getAttribute( '_cke_saved_href' ) != '' )
				useLink = true;

			// Insert a new Image.
			if ( this.editMode[ 'image' ] == false )
			{
				// It doesn't work with IE.
				this.restoreSelection();
				this.clearSavedSelection();
				
				if ( useLink )
					//Insert a new Link.
					if ( this.editMode[ 'link' ] == false )
					{
						this.editObj[ 'link' ].append( this.editObj[ 'image' ], false );
						editor.insertElement( this.editObj[ 'link' ] );
					}
					else 	//Link already exists, image not.
						this.editObj[ 'link' ].append( this.editObj[ 'image' ], false );
				else
					editor.insertElement( this.editObj[ 'image' ] );
			}
			else		// Image already exists.	
			{
				//Add a new link element.
				if ( this.editMode[ 'link' ] == false && this.changedAttibutes[ 'link' ][ '_cke_saved_href' ] )
				{
					this.editObj[ 'image' ].insertBeforeMe( this.editObj[ 'link' ] );	
					this.editObj[ 'image' ].appendTo( this.editObj[ 'link' ] );	
				}
				//Remove Link, Image exists.
				else if ( this.editMode[ 'link' ] == true && !this.changedAttibutes[ 'link' ][ '_cke_saved_href' ] )
					this.editObj[ 'link' ].remove( true );
			}
			this.allowOnChange = false;		// Don't load onChange before onShow.

			return true;
		},
		onShow : function()
		{
			//Don't call onShow before onShow.
			this.allowOnChange = false;

			this.editObj = new Array();
			this.editObj[ 'image' ] = false;
			this.editObj[ 'link' ] = false;
			this.editObj[ 'imageOriginal' ] = false;
			this.editObj[ 'imagePreview' ] = false;

			// Default: create a new element.
			this.editMode = new Array();
			this.editMode[ 'link' ] = false;
			this.editMode[ 'image' ] = false;

			this.changedAttibutes = new Array();
			this.changedAttibutes[ 'link' ] = new Array();
			this.changedAttibutes[ 'image' ] = new Array();

			this.imageLockRatio = true;

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			// Copy of the image
			this.editObj[ 'imageOriginal' ] = editor.document.createElement( 'img' );
			this.editObj[ 'imageOriginal' ].setCustomData( 'isReady', 'false' );

			// Preview
			this.editObj[ 'imagePreview' ] = CKEDITOR.document.getById( 'previewImage' );
			this.editObj[ 'linkPreview' ] = CKEDITOR.document.getById( 'previewLink' );

			// Check selection. Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				element = false;
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );
				rangeRoot = ranges[0].getCommonAncestor( true );
				
				elementImg = rangeRoot.getAscendant( 'img', true );
				elementA = rangeRoot.getAscendant( 'a', true );
				elementInput = rangeRoot.getAscendant( 'input', true );
				
				if ( elementImg )
					element = elementImg;
				else
					if ( elementA && elementA.getAttribute( 'href' ) )
						element = elementA;
					else
						if ( elementInput && elementInput.getAttribute( 'type' ) 
						&& elementInput.getAttribute( 'type' ) == 'image' )
							element = elementInput;
				
				if ( element )
				{
					loadElements.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( element );
					this.saveSelection();
					this.pushDefault();
				}
			}
			updateOriginal( this, false );
			updatePreview( this );

			this.allowOnChange = true;

			this.getContentElement( 'info', 'txtUrl' ).focus();
		},		
		onLoad : function()
		{
			if ( !imageDialog )
				this.hidePage( 'Link' );		//Hide Link tab.

			if ( editor.config.imageUpload == false )
				this.hidePage( 'Upload' );		//Hide Upload tab.

			// Activate Reset button
			var resetButton= CKEDITOR.document.getById( 'btnResetSize' );
			if ( resetButton )
			{
				resetButton.on( 'click', function()
					{
						resetSize( this );
					}, this );
				resetButton.on( 'mouseover', function()
					{
						this.addClass( 'BtnOver' );
					}, resetButton );
				resetButton.on( 'mouseout', function()
					{
						this.removeClass( 'BtnOver' );
					}, resetButton );
			}

			// Activate (Un)LockRatio button
			var ratioButton= CKEDITOR.document.getById( 'btnLockSizes' );
			if ( ratioButton )
			{
				ratioButton.on( 'click', function()
					{
						var btnLockSizes = CKEDITOR.document.getById( 'btnLockSizes' );
						switchLockRatio( this );
					}, this );
				ratioButton.on( 'mouseover', function()
					{
						this.addClass( 'BtnOver' );
					}, ratioButton );
				ratioButton.on( 'mouseout', function()
					{
						this.removeClass( 'BtnOver' );
					}, ratioButton );
			}
		},	
		onHide : function()
		{
			if ( this.editObj[ 'imagePreview' ] )
				this.editObj[ 'imagePreview' ].setAttribute( 'src', '' );

			this.editObj[ 'imagePreview' ] = false;
			this.editObj[ 'imageOriginal' ].remove();

			// Don't call onChange before onShow.
			this.allowOnChange = false;

			// Pop the default values from default value set that are pushed in onShow().
			this.popDefault();
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.dlgImgInfoTab,
				accessKey : 'I',
				elements :
				[
					{
						type : 'vbox',
						padding : 0,
						children :
						[
							{
								type : 'html',
								html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.dlgImgURL ) + '</span>'
							},
							{
								type : 'hbox',
								widths : [ '280px', '110px' ],
								align : 'right',
								children :
								[
									{
										id : 'txtUrl',
										type : 'text',
										label : '',
										validate: function()
										{
											addChange( 'src', this, 'image' );
											addChange( '_cke_saved_url', this, 'image' );
											return true;
										},
										onChange : function(){
											onUrlChange( this );
										}
									},
									{
										type : 'button',
										id : 'browse',
										align : 'center',
										label : editor.lang.browseServer,
										onClick : function()
										{
											this.getDialog().setValueOf( "info", "txtUrl", "http://www.fckeditor.net/images/demo_screenshot.gif" );
										}
									}
								]
							}
						]
					},
					{
						id : 'txtAlt',
						type : 'text',
						label : editor.lang.dlgImgAlt,
						accessKey : 'A',
						onChange : function()
						{
							onChange( this, 'title' );
						},
						validate: function()
						{
							addChange( 'alt', this, 'image' );
							return true;
						}
					},
					{
						type : 'hbox',
						widths : [ '140px', '240px' ],
						children :
						[
							{
								type : 'vbox',
								padding : 10,
								children :
								[
									{
										type : 'hbox',
										widths : [ '70%', '30%' ],
										children :
										[
											{
												type : 'vbox',
												padding : 1,
												children :
												[
													{
														type : 'text',
														id : 'txtWidth',
														labelLayout : 'horizontal',
														label : editor.lang.dlgImgWidth,
														onChange : function()
														{
															onSizeChange( this );
														},
														validate: function()
														{
															// TODO Check content -  integer or percent.
															//var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
															//var isValid = func.apply( this );
															isValid = true;
															if ( isValid )
																addChange( 'width', this, 'image' );
															return isValid;
														}
													},
													{
														type : 'text',
														id : 'txtHeight',
														labelLayout : 'horizontal',
														label : editor.lang.dlgImgHeight,
														onChange : function()
														{
															onSizeChange( this );
														},
														validate: function()
														{
															// TODO Check content -  integer or percent.
															//var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
															//var isValid = func.apply( this );
															isValid = true;
															if ( isValid )
																addChange( 'height', this, 'image' );
															return isValid;
														}
													}
												]
											},
											{
												type : 'html',
												style : 'position:relative;top:-10px;height:20px',	
												html : '<div>'+
													'<div onclick="" title="' + editor.lang.dlgImgLockRatio + 
													'" class="BtnLocked" id="btnLockSizes"></div>' +
													'<div onclick="" title="' + editor.lang.dlgBtnResetSize + 
													'" class="BtnReset" id="btnResetSize"></div>'+
													'</div>'
											}
										]
									},
									{
										type : 'vbox',
										padding : 1,
										children :
										[
											{
												type : 'text',
												id : 'txtBorder',
												labelLayout : 'horizontal',
												label : editor.lang.dlgImgBorder,
												onChange : function()
												{
													onChange( this, 'border' );
												},
												validate: function()
												{
													var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
													var isValid = func.apply( this );
													if ( isValid )
														addChange( 'border', this, 'image' );
													return isValid;
												}
											},
											{
												type : 'text',
												id : 'txtHSpace',
												labelLayout : 'horizontal',
												label : editor.lang.dlgImgHSpace,
												onChange : function()
												{
													onChange( this, 'hspace' );
												},
												validate: function()
												{
													var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
													var isValid = func.apply( this );
													if ( isValid )
														addChange( 'hspace', this, 'image' );
													return isValid;
												}
											},
											{
												type : 'text',
												id : 'txtVSpace',
												labelLayout : 'horizontal',
												label : editor.lang.dlgImgVSpace,
												onChange : function()
												{
													onChange( this, 'vspace' );
												},
												validate: function()
												{
													var func = CKEDITOR.dialog.validate.integer( editor.lang.dlgImgTypeNumber );
													var isValid = func.apply( this );
													if ( isValid )
														addChange( 'vspace', this, 'image' );
													return isValid;
												}
											},
											{
												id : 'cmbAlign',
												type : 'select',
												labelLayout : 'horizontal',
												widths : [ '35%','65%' ],
												style : 'width:100%',
												label : editor.lang.dlgImgAlign,
												items :
												[
													[ editor.lang.dlgGenNotSet , ''],
													[ editor.lang.dlgImgAlignLeft , 'left'],
													[ editor.lang.dlgImgAlignAbsBottom , 'absBottom'],
													[ editor.lang.dlgImgAlignAbsMiddle , 'absMiddle'],
													[ editor.lang.dlgImgAlignBaseline , 'baseline'],
													[ editor.lang.dlgImgAlignBottom , 'bottom'],
													[ editor.lang.dlgImgAlignMiddle , 'middle'],
													[ editor.lang.dlgImgAlignRight , 'right'],
													[ editor.lang.dlgImgAlignTextTop , 'textTop'],
													[ editor.lang.dlgImgAlignTop , 'top']
												],
												onChange : function()
												{
													onChange( this, 'align' );
												},
												validate: function()
												{
													addChange( 'align', this, 'image' );
													return true;
												}
											}
										]
									}
								]
							},
							{
								type : 'vbox',
								height : '250px',
								children :
								[
									{
										type : 'html',
										style : 'width:95%;',
										html : previewAreaHtml
									}
								]
							}
						]
					}
				]
			},
			{
				id : 'Link',
				label : editor.lang.linkTitle,
				padding : 0,
				elements :
				[
					{
						id : 'txtUrl',
						type : 'text',
						label : editor.lang.dlgImgURL,
						style : 'width: 100%',
						validate: function()
						{
							addChange( '_cke_saved_href', this, 'link' );
							return true;
						}
					},
					{
						type : 'button',
						id : 'browse',
						style : 'float:right',
						label : editor.lang.browseServer,
						onClick : function()
						{
							this.getDialog().setValueOf( "Link", "txtUrl", "http://www.fckeditor.net/" );
							
						}
					},
					{
						id : 'cmbTarget',
						type : 'select',
						label : editor.lang.linkTarget,
						items :
						[
							[ editor.lang.linkTargetNotSet , ''],
							[ editor.lang.linkTargetNew , '_blank'],
							[ editor.lang.linkTargetTop , '_top'],
							[ editor.lang.linkTargetSelf , '_self'],
							[ editor.lang.linkTargetParent , '_parent']
						],
						validate: function()
						{
							addChange( 'target', this, 'link' );
							return true;
						}
					}
				]
			},
			{
				id : 'Upload',
				label : editor.lang.dlgImgUpload,
				elements :
				[
					{
						type : 'file',
						id : 'upload',
						label : editor.lang.dlgImgBtnUpload,
						action : uploadAction,
						size : 38
					},
					{
						type : 'fileButton',
						id : 'uploadButton',
						label : editor.lang.dlgImgBtnUpload,
						'for' : [ 'Upload', 'upload' ]
					}
				]
			},
			{
				id : 'advanced',
				label : editor.lang.dlgDivAdvancedTab,
				elements :
				[
					{
						type : 'hbox',
						widths : [ '50%', '25%', '25%' ],
						children :
						[
							{
								type : 'text',
								id : 'linkId',
								label : editor.lang.dlgGenId,
								validate : function()
								{
									addChange( 'id', this, 'image' );
									return true;
								}
							},
							{
								id : 'cmbLangDir',
								type : 'select',
								label : editor.lang.dlgGenLangDir,
								style : 'width : 100%;',
								items :
								[
									[ editor.lang.dlgGenNotSet, '' ],
									[ editor.lang.dlgGenLangDirLtr, 'ltr' ],
									[ editor.lang.dlgGenLangDirRtl, 'rtl' ]
								],
								validate : function()
								{
									addChange( 'dir', this, 'image' );
									return true;
								}
							},
							{
								type : 'text',
								id : 'txtLangCode',
								label : editor.lang.dlgGenLangCode,
								validate : function()
								{
									addChange( 'lang', this, 'image' );
									return true;
								}
							}
						]
					},
					{
						type : 'text',
						id : 'txtGenLongDescr',
						label : editor.lang.dlgGenLongDescr,
						validate : function()
						{
							addChange( 'longdesc', this, 'image' );
							return true;
						}
					},
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								type : 'text',
								id : 'txtGenClass',
								label : editor.lang.dlgGenClass,
								validate : function()
								{
									addChange( 'class', this, 'image' );
									return true;
								}
							},
							{
								type : 'text',
								id : 'txtGenTitle',
								label : editor.lang.dlgGenTitle,
								validate : function()
								{
									addChange( 'title', this, 'image' );
									return true;
								}
							},
						]
					},
					{
						type : 'text',
						id : 'txtdlgGenStyle',
						label : editor.lang.dlgGenStyle,
						validate : function()
						{				
							addChange( 'style', this, 'image' );
							return true;
						}
					}
				]
			}
		]
	};
};

CKEDITOR.dialog.add( 'image', function( editor ){
		return imageDialog( editor, 'image' )
	}
);

CKEDITOR.dialog.add( 'imagebutton', function( editor ){
		return imageDialog( editor, 'imagebutton' )
	}
);
