/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.dialog.add( 'specialchar', function( editor )
{
	return {
		title : editor.lang.specialChar.title,
		minWidth : 400,
		minHeight : 300,
		buttons : [ CKEDITOR.dialog.cancelButton ],
		onLoad :  function()
		{
			html = [ '<table style="width: 100%; height: 100%; border-collapse: separate;" align="center" cellspacing="2" cellpadding="2" border="0">' ];
			html.push( '<tbody>' );

			var cols = 20 ;
			var i = 0 ;

			while ( i < specialChars.length)
			{
				html.push("<tr>") ;
				for( var j = 0 ; j < cols ; j++)
				{
					if (specialChars[i])
					{
						html.push('<td width="1%" value="' + specialChars[i].replace(/&/g, "&amp;") + '" class="DarkBackground SpecialCharsOut Hand">');
						html.push(specialChars[i]);
					}
					else
						html.push("<td class='DarkBackground SpecialCharsOut'>&nbsp;");
					html.push("<\/td>");
					i++;
				}
				html.push("<\/tr>");
			}

			html.push( '</tbody></table>' );
			this.getContentElement( 'info', 'charContainer' ).getElement().setHtml(html.join( '' ));
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.common.generalTab,
				title : editor.lang.common.generalTab,
				elements : [
					{
						type : 'html',
						id : 'charContainer',
						align : 'left',
						html : '',
						onClick : function( evt )
						{
							var target = evt.data.getTarget();
							var targetName = target.getName();

							if ( targetName == 'td' )
							{
								target = target.$;
								if ( value = target.getAttribute( 'value' ) )
								{
									this.getDialog().restoreSelection();
									editor.insertElement( CKEDITOR.dom.element.createFromHtml( value, editor.document ) );
									this.getDialog().hide();
								}
							}
						}
					}
				]
			}
		]
	};
} );

