/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */


findDialog = function( editor, startupPage )
{
	var characterCursor = function( cursorOrTextNode, offset )
	{
		if ( arguments.length < 2 )
			return;

		var isCursor = ( cursorOrTextNode instanceof characterCursor );
		CKEDITOR.tools.extend( this._ || ( this._ = {} ),
			{
				'textNode' : isCursor ? cursorOrTextNode._.textNode : cursorOrTextNode,
				'offset' : isCursor ? cursorOrTextNode._.offset : offset,
				'stopFlag' : false
			} );
		this._.walker = new CKEDITOR.dom.domWalker( this._.textNode );
		CKEDITOR.event.implementOn( this );
	};

	CKEDITOR.tools.extend( characterCursor,
		{
		} );

	characterCursor.prototype = {
		'next' : function()
		{
		},

		'back' : function()
		{
		},

		'forward' : function()
		{
		},

		'reverse' : function()
		{
		},

		'stop' : function()
		{
		},

		'stopped' : function()
		{
		},

		'setPosition' : function( textNode, offset )
		{
		}
	};

	var characterRange = function()
	{
	};

	return {
		title : editor.lang.findAndReplace.title,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 225,
		buttons : [ CKEDITOR.dialog.cancelButton ],		//Cancel button only.
		contents : [
			{
				id : 'find',
				label : editor.lang.findAndReplace.find,
				title : editor.lang.findAndReplace.find,
				accessKey : '',
				elements : [
					{
						type : 'hbox',
						widths : [ '230px', '90px' ],
						children :
						[
							{
								type : 'text',
								id : 'txtFindFind',
								label : editor.lang.findAndReplace.findWhat,
								isChanged : false,
								labelLayout : 'horizontal',
								accessKey : 'F',
							},
							{
								type : 'button',
								align : 'left',
								style : 'width:100%',
								label : editor.lang.findAndReplace.find,
								onClick : function()
								{
									alert( editor.lang.findAndReplace.notFoundMsg );
								}
							},
						]
					},
					{
						type : 'checkbox',
						id : 'txtFindCaseChk',
						isChanged : false,
						label : editor.lang.findAndReplace.matchCase,
					},
					{
						type : 'checkbox',
						id : 'txtFindWordChk',
						isChanged : false,
						label : editor.lang.findAndReplace.matchWord,
					},
				]
			},
			{
				id : 'replace',
				label : editor.lang.findAndReplace.replace,
				accessKey : 'M',
				elements : [
					{
						type : 'hbox',
						widths : [ '230px', '90px' ],
						children :
						[
							{
								type : 'text',
								id : 'txtFindReplace',
								label : editor.lang.findAndReplace.findWhat,
								isChanged : false,
								labelLayout : 'horizontal',
								accessKey : 'F',
							},
							{
								type : 'button',
								align : 'left',
								style : 'width:100%',
								label : editor.lang.findAndReplace.replace,
								onClick : function()
								{
									alert( editor.lang.findAndReplace.notFoundMsg );
								}
							},
						]
					},
					{
						type : 'hbox',
						widths : [ '230px', '90px' ],
						children :
						[
							{
								type : 'text',
								id : 'txtReplace',
								label : editor.lang.findAndReplace.replaceWith,
								isChanged : false,
								labelLayout : 'horizontal',
								accessKey : 'R',
							},
							{
								type : 'button',
								align : 'left',
								style : 'width:100%',
								label : editor.lang.findAndReplace.replaceAll,
								isChanged : false,
								onClick : function()
								{
									alert( editor.lang.findAndReplace.notFoundMsg );
								}
							},
						]
					},
					{
						type : 'checkbox',
						id : 'txtReplaceCaseChk',
						isChanged : false,
						label : editor.lang.findAndReplace.matchCase,
					},
					{
						type : 'checkbox',
						id : 'txtReplaceWordChk',
						isChanged : false,
						label : editor.lang.findAndReplace.matchWord,
					},
				]
			}
		],
		onShow : function()
		{
			if ( startupPage == 'replace' )
				this.getContentElement( 'replace', 'txtFindReplace' ).focus();
			else
				this.getContentElement( 'find', 'txtFindFind' ).focus();
		}
	};
};

CKEDITOR.dialog.add( 'find', function( editor ){
		return findDialog( editor, 'find' )
	}
);

CKEDITOR.dialog.add( 'replace', function( editor ){
		return findDialog( editor, 'replace' )
	}
);
