/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.dialog.add( 'specialchar', function( editor )
{
	return {
		title : editor.lang.specialChar.title,
		minWidth : 450,
		minHeight : 350,
		buttons : [ CKEDITOR.dialog.cancelButton ],
		onLoad :  function()
		{
			html = [ '<table style="width: 320px; height: 100%; border-collapse: separate;" align="center" cellspacing="2" cellpadding="2" border="0">' ];
			html.push( '<tbody>' );

			var cols = 17 ;
			var i = 0 ;

			while ( i < specialChars.length)
			{
				html.push("<tr>") ;
				for( var j = 0 ; j < cols ; j++)
				{
					if (specialChars[i])
					{
						html.push('<td width="1%" title=' + specialChars[i].replace(/&/g, "&amp;") + ' value="' + specialChars[i].replace(/&/g, "&amp;") + '" class="DarkBackground SpecialCharsOut Hand">');
						html.push(specialChars[i]);
					}
					else
						html.push("<td class='DarkBackground'>&nbsp;");
					html.push("<\/td>");
					i++;
				}
				html.push("<\/tr>");
			}

			html.push( '</tbody></table>' );
			this.getContentElement( 'info', 'charContainer' ).getElement().setHtml( html.join( '' ) );
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.common.generalTab,
				title : editor.lang.common.generalTab,
				elements : [
					{
						type : 'hbox',
						align : 'top',
						widths : [ '300px', '90px' ],
						children :
						[
							{
								type : 'hbox',
								align : 'top',
								padding : 0,
								widths : [ '350px' ],
								children :
								[
									{
										type : 'html',
										id : 'charContainer',
										html : '',
										onMouseover : function( evt )
										{
											var dialog = this.getDialog();
											var htmlPreview = dialog.getContentElement( 'info', 'htmlPreview' ).getElement();
											var preview = dialog.getContentElement( 'info', 'charPreview' ).getElement();
											var target = evt.data.getTarget();
											var targetName = target.getName();

											if ( targetName == 'td' )
												if ( value = target.$.getAttribute( 'value' ) )
												{
													preview.setHtml( value );
													target.addClass( "LightBackground" );
													htmlPreview.setHtml( CKEDITOR.tools.htmlEncode( value ) );
												}
										},
										onMouseout : function( evt )
										{
											var dialog = this.getDialog();
											var preview = dialog.getContentElement( 'info', 'charPreview' ).getElement();
											var htmlPreview = dialog.getContentElement( 'info', 'htmlPreview' ).getElement();
											var target = evt.data.getTarget();
											var targetName = target.getName();
											preview.setHtml( '&nbsp;' );
											htmlPreview.setHtml( '&nbsp;' );

											if ( targetName == 'td' )
												target.removeClass( "LightBackground" );
										},			
										onClick : function( evt )
										{
											var target = evt.data.getTarget();
											var targetName = target.getName();
											var editor = this.getDialog().getParentEditor();
											if ( targetName == 'td' )
											{
												target = target.$;
												if ( value = target.getAttribute( 'value' ) )
												{
													this.getDialog().restoreSelection();
													editor.insertElement( CKEDITOR.dom.element.createFromHtml( value ) );
													this.getDialog().hide();
												}
											}
										}
									}
								]
							},
							{
								type : 'vbox',
								align : 'top',
								children :
								[
									{
										type : 'html',
										html : '<div></div>',
									},
									{
										type : 'html',
										id : 'charPreview',
										style : 'border:1px solid #eeeeee;background-color:#EAEAD1;font-size:28px;height:40px;padding-top:9px;font-family:\'Microsoft Sans Serif\',Arial,Helvetica,Verdana;text-align:center;',
										html : '<div>&nbsp;</div>',
									},
									{
										type : 'html',
										id : 'htmlPreview',
										style : 'border:1px solid #eeeeee;background-color:#EAEAD1;font-size:14px;height:20px;padding-top:2px;font-family:\'Microsoft Sans Serif\',Arial,Helvetica,Verdana;text-align:center;',
										html : '<div>&nbsp;</div>',
									}
								]
							}
						]
					}
				]
			}
		]
	};
} );

