/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileoverview The "fakeobjects" plugin. It handles placeholder DOM nodes
 * 	in WYSIWYG mode.
 */

(function()
{
	CKEDITOR.plugins.add( 'fakeobjects',
		{
			init : function( editor, pluginPath )
			{
				var flashExtensionRegex = /\.swf($|#|\?)/i,
					objectTypes =
					{
						flash : {
							match : function( nodeName, attributes )
							{
								return nodeName == 'embed' && ( attributes.type == 'application/x-shockwave-flash' || flashExtensionRegex.test( attributes.src || '' ) );
							},

							cssClass : 'flash'
						}
					},
					makeTagOpenerHtml = function( tagName, attributes )
					{
						var attribStr = [], html = [ '<' + tagName ];
						for ( var i in attributes )
							attribStr.push( i + '="' + CKEDITOR.tools.htmlEncode( attributes[i] ) + '"');
						if ( attribStr.length > 0 )
							html.push( ' ', attribStr.join( ' ' ) );
						html.push( '>' );
						return html.join( '' );
					},
					protectedHtmlRegex = /<img(?=\s).*?\s_cke_protected_html=((?:(?:\s*)("|').*?\2)|(?:[^"'][^ >]+))(?:"[^"]*"|'[^']*'|[^<])*>(?:<\/img>)?/gi,
					protectHtmlRestore_ReplaceTags = function( htmlTag, s1 )
					{
						return decodeURIComponent( s1.substr( 1, s1.length - 2 ) );
					},
					namespace =
					{
						protectElement : function( element )
						{
							var $ = element.$.cloneNode( true ),
								doc = $.ownerDocument,
								temp = doc.createElement( 'div' ),
								html;

							// Get the object's HTML code.
							temp.appendChild( $ );
							html = temp.innerHTML;

							// Get the fake element's CSS class.
							var cssClass = 'unknown';
							for ( var i in objectTypes )
							{
								if ( objectTypes[i].match( element.getName(), element.$ ) )
								{
									cssClass = '_cke_fakeobject' + ' ' + objectTypes[i].cssClass;
									break;
								}
							}

							// Make the fake element.
							var fakeRawElement = doc.createElement( 'img' );
							img.className = cssClass;
							img.src = CKEDITOR.getUrl( 
									'_source/' +		// TODO: Remove this in release package
									'skins/' + editor.config.skin + '/images/spacer.gif' );
							img.style.cssText = $.style.cssText;
							return new CKEDITOR.dom.element( fakeRawElement );
						},

						protectHtml : function( html )
						{
							var parser = new CKEDITOR.htmlParser(),
								tagDepth = 0, processedHtml = [],
								protectedHtml = [], inProtection = false;

							parser.onTagOpen = function( tagName, attributes )
							{
								if ( inProtection )
								{
									protectedHtml.push( makeTagOpenerHtml( tagName, attributes ) );
									return;
								}

								for ( var i in objectTypes )
								{
									if ( objectTypes[i].match( tagName, attributes ) )
									{
										inProtection = true;
										tagDepth = 1;
										processedHtml.push( '<img src="',
											CKEDITOR.getUrl(
												'_source/' +	// TODO: Remove for release package
												'skins/' + editor.config.skin + '/images/spacer.gif' ),
											'" ',
											'class="_cke_fakeobject ' + objectTypes[i].cssClass + '" ',
											'_cke_protected_html="');
										arguments.callee.call( this, tagName, attributes );
										return;
									}
								}

								processedHtml.push( makeTagOpenerHtml( tagName, attributes ) );
							};

							parser.onText = function( text )
							{
								inProtection ? protectedHtml.push( text ) : processedHtml.push( text );
							};

							parser.onComment = function( comment )
							{
								inProtection ? protectedHtml.push( '<!--' + comment + '-->' ) : processedHtml.push( '<!--' + comment + '-->' );
							};

							parser.onTagClose = function( tagName )
							{
								if ( inProtection )
								{
									tagDepth--;
									protectedHtml.push( '</' + tagName + '>' );
									if ( tagDepth < 1 )
									{
										inProtection = false;
										processedHtml.push( encodeURIComponent( protectedHtml.join( '' ) ), '" />' );
									}
								}
								else
									processedHtml.push( '</' + tagName + '>' );
							};

							parser.parse( html );
							return processedHtml.join( '' );
						},

						restoreHtml : function( html )
						{
							return html.replace( protectedHtmlRegex, protectHtmlRestore_ReplaceTags );
						},

						addObjectType : function( typeName, typeHandler )
						{
							objectTypes.typeName = typeHandler;
						}
					};

				CKEDITOR.plugins.fakeobjects = namespace;
			}
		} );
})();
