/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */
CKEDITOR.dialog.add( 'form', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if ( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	// Function called in onShow to load selected element.
	var loadLink = function( editor, selection, ranges, element )
	{
		this.saveSelection();
		this.editObj = element;
		this.editMode = true;

		// Fill out all fields.
		readAttribute.apply( this, [ 'info', 'name', 'txtName' ] );
		readAttribute.apply( this, [ 'info', 'action', 'txtAction' ] );
		readAttribute.apply( this, [ 'info', 'method', 'cmbMethod' ] );
		readAttribute.apply( this, [ 'info', 'encoding', 'cmbEncoding' ] );
		readAttribute.apply( this, [ 'info', 'target', 'cmbTarget' ] );
		readAttribute.apply( this, [ 'info', 'id', 'txtId' ] );

		return false;
	};
	
	var readAttribute = function( page, attribute, input )
	{
		var attributeValue = this.editObj.getAttribute( attribute );
		this.setValueOf( page, input, attributeValue );

		return attributeValue;
	}

	return {
		title : editor.lang.form.title,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 270,
		onOk : function( data )
		{
			this.editObj.setAttributes( this.changedAttibutes );

			if ( this.editMode == false )
			{
				// It doesn't work with IE.
				this.restoreSelection();
				this.clearSavedSelection();
				editor.insertElement( this.editObj );
			}
			return true;
		},
		onShow : function()
		{
			// Default: create a new element.
			this.editMode = false;
			
			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();
				
			// Check selection. Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );

				var rangeRoot = ranges[0].getCommonAncestor( true );
				var element = rangeRoot.getAscendant( 'form', true );
				if ( element )
				{
					loadLink.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( element );
				}
			}

			if( this.editMode == false )
				this.editObj = editor.document.createElement( 'form' );

			this.getContentElement( 'info', 'txtName' ).focus();
			this.changedAttibutes = new Array();
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.form.title,
				title : editor.lang.form.title,
				accessKey : 'I',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.common.name,
						'default' : '',
						accessKey : 'N',
						validate: function()
						{
							addChange( 'name', this );
							return true;
						}
					},
					{
						id : 'txtAction',
						type : 'text',
						label : editor.lang.form.action,
						'default' : '',
						accessKey : 'A',
						validate: function()
						{
							addChange( 'action', this );
							return true;
						}
					},
					{
						type : 'hbox',
						widths : [ '45%', '55%' ],
						children :
						[
							{
								id : 'txtId',
								type : 'text',
								label : editor.lang.common.id,
								'default' : '',
								accessKey : 'I',
								validate: function()
								{
									addChange( 'id', this );
									return true;
								}
							},
							{
								id : 'cmbEncoding',
								type : 'select',
								label : editor.lang.form.encoding,
								style : 'width:100%',
								accessKey : 'E',
								'default' : 'text/plain',
								items :
								[
									[ 'text/plain' ],
									[ 'multipart/form-data' ],
									[ 'application/x-www-form-urlencoded' ]
								],
								validate: function()
								{
									addChange( 'encoding', this );
									return true;
								}
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '45%', '55%' ],
						children :
						[
							{
								id : 'cmbTarget',
								type : 'select',
								label : editor.lang.form.target,
								style : 'width:100%',
								accessKey : 'M',
								'default' : '',
								items :
								[
									[ editor.lang.form.targetNotSet, '' ],
									[ editor.lang.form.targetNew, '_blank' ],
									[ editor.lang.form.targetTop, '_top' ],
									[ editor.lang.form.targetSelf, '_self' ],
									[ editor.lang.form.targetParent, '_parent' ]
								],
								validate: function()
								{
									addChange( 'target', this );
									return true;
								}
							},
							{
								id : 'cmbMethod',
								type : 'select',
								label : editor.lang.form.method,
								accessKey : 'M',
								'default' : 'GET',
								items :
								[
									[ 'GET', 'get' ],
									[ 'POST', 'post' ]
								],
								validate: function()
								{
									addChange( 'method', this );
									return true;
								}
							}
						]
					}
				]
			}
		]
	};
});
