/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

imageDialog = function( editor, dialogType )
{
	// Load image preview.
	var showPreview = editor.config.pluginConfig.image.showPreview;
	var regexSize = /^\s*(\d+)((px)|\%)?\s*$/i;
	var regexValidSize = /^(\d+)\%?$|^$/i;
	var imageDialog = ( dialogType == 'image' );
	var previewAreaHtml = '<div>' + CKEDITOR.tools.htmlEncode( editor.lang.image.preview ) +'<br>'+
		'<div id="ImagePreviewLoader" style="display:none"><div class="loading">&nbsp;</div></div>'+
		'<div id="ImagePreviewBox">'+
		'<a href="javascript:void(0)" target="_blank" onclick="return false;" id="previewLink"><img id="previewImage" src="" /></a>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Maecenas feugiat consequat diam. Maecenas metus. Vivamus diam purus, cursus a, commodo non, facilisis vitae, nulla. Aenean dictum lacinia tortor. Nunc iaculis, nibh non iaculis aliquam, orci felis euismod neque, sed ornare massa mauris sed velit. Nulla pretium mi et risus. Fusce mi pede, tempor id, cursus ac, ullamcorper nec, enim. Sed tortor. Curabitur molestie. Duis velit augue, condimentum at, ultrices a, luctus ut, orci. Donec pellentesque egestas eros. Integer cursus, augue in cursus faucibus, eros pede bibendum sem, in tempus tellus justo quis ligula. Etiam eget tortor. Vestibulum rutrum, est ut placerat elementum, lectus nisl aliquam velit, tempor aliquam eros nunc nonummy metus. In eros metus, gravida a, gravida sed, lobortis id, turpis. Ut ultrices, ipsum at venenatis fringilla, sem nulla lacinia tellus, eget aliquet turpis mauris non enim. Nam turpis. Suspendisse lacinia. Curabitur ac tortor ut ipsum egestas elementum. Nunc imperdiet gravida mauris.' +
		'</div>'+'</div>';

	var addChange = function( name, input, object, getMyValue ){
		var dialog = input.getDialog();

		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		var value;
		if ( getMyValue )
			value = getMyValue.apply( input );
		else
			value = input.getValue();

		if ( value == null )		// Didn't passed validation
			return false;

		if ( value != '' || input.isChanged() )
			dialog.changedAttibutes[ object ][ name ] = value;

		return true;
	}
	var onImgLoad = function()
	{
		// Image is ready.
		this.editObj[ 'imageOriginal' ].setCustomData( 'isReady', 'true' );
		this.editObj[ 'imageOriginal' ].removeListener( 'load', onImgLoad );
		this.editObj[ 'imageOriginal' ].removeListener( 'error', onImgLoadError );
		this.editObj[ 'imageOriginal' ].removeListener( 'abort', onImgLoadError );

		// Hide loader
		CKEDITOR.document.getById( 'ImagePreviewLoader' ).setStyle( 'display', 'none' );

		// New image -> new domensions
		if ( this.forceResetSize ){
			resetSize( this );
		}
	}
	var onImgLoadError = function()
	{
		// Error. Image is not loaded.
		this.editObj[ 'imageOriginal' ].removeListener( 'load', onImgLoad );
		this.editObj[ 'imageOriginal' ].removeListener( 'error', onImgLoadError );
		this.editObj[ 'imageOriginal' ].removeListener( 'abort', onImgLoadError );

		// Set Error image.
		var noimage = CKEDITOR.getUrl(
			'_source/' +	// TODO: Add @-Packager.RemoveLine to the final build process.
			'skins/' + editor.config.skin + '/images/dialog.noimage.gif' );

		if ( showPreview && this.editObj[ 'imagePreview' ] )
			this.editObj[ 'imagePreview' ].setAttribute( 'src', noimage );

		// Hide loader
		CKEDITOR.document.getById( 'ImagePreviewLoader' ).setStyle( 'display', 'none' );
		switchLockRatio( this, false );	// Unlock.
	}
	var onUrlChange = function( input )
	{
		var dialog = input.getDialog();

		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		updateOriginal( dialog, true );	// true = reset size.
		updatePreview( dialog );
	}

	var onSizeChange = function( input )
	{
		var dialog = input.getDialog();
		var value = input.getValue();

		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		// Check value
		var aMatch  =  value.match( regexSize );
		if ( aMatch )
		{
			// % is allowed - > unlock ratio.
			if ( aMatch[2] == '%' )
				switchLockRatio( dialog, false );	// Unlock.
			value = aMatch[1];
		}

		// Only if ratio is locked
		if ( dialog.imageLockRatio )
		{
			var oImageOriginal = dialog.editObj[ 'imageOriginal' ];
			if ( oImageOriginal && oImageOriginal.getCustomData( 'isReady' ) == 'true' )
			{
				if ( input.id == 'txtHeight' ){
					dialog.allowOnChange = false;
					if ( value != '' && value != 0 )
						value = Math.round( oImageOriginal.$.width * ( value  / oImageOriginal.$.height ) );
					if ( !isNaN( value ) )
						dialog.setValueOf( 'info', 'txtWidth', value );
					dialog.allowOnChange = true;
				}
				else		//input.id = txtWidth.
				{
					dialog.allowOnChange = false;
					if ( value != '' && value != 0 )
						value = Math.round( oImageOriginal.$.height * ( value  / oImageOriginal.$.width ) );
					if ( !isNaN( value ) )
						dialog.setValueOf( 'info', 'txtHeight', value );
					dialog.allowOnChange = true;
				}
			}
		}
		updatePreview( dialog );
	}

	var onChange = function( input, attribute )
	{
		var dialog = input.getDialog();

		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		updatePreview( dialog );
	}

	var updatePreview = function( dialog )
	{
		if ( !dialog.editObj[ 'imagePreview' ] )
			return 1;

		var oImageOriginal = dialog.editObj[ 'imageOriginal' ];
		if ( oImageOriginal && oImageOriginal.getCustomData( 'isReady' ) == 'true' && showPreview )
		{
			var width = dialog.getValueOf( 'info', 'txtWidth' );
			var height = dialog.getValueOf( 'info', 'txtHeight' );

			if ( width == '' && oImageOriginal )
				width = oImageOriginal.$.width;
			if ( height == '' && oImageOriginal )
				height = oImageOriginal.$.height;

			dialog.editObj[ 'imagePreview' ].setStyle( 'width', width + 'px');
			dialog.editObj[ 'imagePreview' ].setStyle( 'height', height + 'px');
		}

		// Read attributes
		var border = dialog.getValueOf( 'info', 'txtBorder' );
		var hspace = dialog.getValueOf( 'info', 'txtHSpace' );
		var vspace = dialog.getValueOf( 'info', 'txtVSpace' );
		var align = dialog.getValueOf( 'info', 'cmbAlign' );
		var alt = dialog.getValueOf( 'info', 'txtAlt' );
		var title = dialog.getValueOf( 'advanced', 'txtGenTitle' );

		// Validate values
		border = parseInt( border, 10 );
		hspace = parseInt( hspace, 10 );
		vspace = parseInt( vspace, 10 );

		border = isNaN( border ) ? 0 : border;
		hspace = isNaN( hspace ) ? 0 : hspace;
		vspace = isNaN( vspace ) ? 0 : vspace;

		// TODO. Doesn't work becouse of a:active{border 0px} from reset.css
		dialog.editObj[ 'imagePreview' ].setAttribute( 'border', border );
		dialog.editObj[ 'imagePreview' ].setAttribute( 'hspace', hspace );
		dialog.editObj[ 'imagePreview' ].setAttribute( 'vspace', vspace );

		dialog.editObj[ 'imagePreview' ].setAttribute( 'align', align );
		dialog.editObj[ 'imagePreview' ].setAttribute( 'title', title );
		dialog.editObj[ 'imagePreview' ].setAttribute( 'alt', alt );
		
		dialog.editObj[ 'imagePreview' ].setStyle( 'border', border + 'px solid black' );
		dialog.editObj[ 'imagePreview' ].setStyle( 'margin-top', vspace + 'px' );
		dialog.editObj[ 'imagePreview' ].setStyle( 'margin-bottom', vspace + 'px' );
		dialog.editObj[ 'imagePreview' ].setStyle( 'margin-left', hspace + 'px' );
		dialog.editObj[ 'imagePreview' ].setStyle( 'margin-right', hspace + 'px' );
		return 0;
	}

	var updateOriginal = function( dialog, forceResetSize )
	{
		var editor = dialog.getParentEditor();

		var url = dialog.getContentElement( 'info', 'txtUrl' ).getValue()
		if ( dialog.editObj && url.length > 0 )
		{
			dialog.editObj[ 'imageOriginal' ].setCustomData( 'isReady', 'false' );
			// Show loader
			var loader = CKEDITOR.document.getById( 'ImagePreviewLoader' );
			this.forceResetSize = forceResetSize;
			if ( loader && showPreview )
				loader.setStyle( 'display', '' );

			if ( showPreview )		// Load image preview
			{
				dialog.editObj[ 'imagePreview' ].removeStyle( 'width' );
				dialog.editObj[ 'imagePreview' ].removeStyle( 'height' );
				dialog.editObj[ 'imagePreview' ].setAttribute( 'src', url );
			}
			dialog.editObj[ 'imageOriginal' ].on( 'load', onImgLoad, dialog );
			dialog.editObj[ 'imageOriginal' ].on( 'error', onImgLoadError, dialog );
			dialog.editObj[ 'imageOriginal' ].on( 'abort', onImgLoadError, dialog );
			dialog.editObj[ 'imageOriginal' ].setAttribute( 'src', url );
		}
	}

	var switchLockRatio = function( dialog, value )
	{
		var oImageOriginal = dialog.editObj[ 'imageOriginal' ];
		if ( oImageOriginal && oImageOriginal.getCustomData( 'isReady' ) == 'true' )
		{
	 		if ( value != undefined )
				dialog.imageLockRatio = value
			else
				dialog.imageLockRatio = !dialog.imageLockRatio;
		}
		else
			dialog.imageLockRatio = false;
		
		var ratioButton = CKEDITOR.document.getById( 'btnLockSizes' );
		if ( dialog.imageLockRatio )
			ratioButton.removeClass( 'BtnUnlocked' );
		else
			ratioButton.addClass( 'BtnUnlocked' );

		return dialog.imageLockRatio;
	}

	var resetSize = function( dialog )
	{
		var oImageOriginal = dialog.editObj[ 'imageOriginal' ];
		if ( oImageOriginal && oImageOriginal.getCustomData( 'isReady' ) == 'true' )
		{
			dialog.allowOnChange = false;
			dialog.setValueOf( 'info', 'txtWidth', oImageOriginal.$.width );
			dialog.setValueOf( 'info', 'txtHeight', oImageOriginal.$.height );
			dialog.allowOnChange = true;
		}
		updatePreview( dialog );
	}
	var readSize = function( dialog )
	{
		var heightText = '';
		var widthText = '';

		// Read height.
		if ( dialog.editObj[ 'image' ].getAttribute( 'height' ) )
		{
			var aMatchH  =  dialog.editObj[ 'image' ].getAttribute( 'height' ).match( regexSize );
			if ( aMatchH )
			{
				// % is allowed.
				if ( aMatchH[2] == '%' )
				{
					aMatchH[1] += '%';
					switchLockRatio( dialog, false );	// Unlock ratio
				}
				heightText = aMatchH[1];
			}
		}

		// Read width.
		if ( dialog.editObj[ 'image' ].getAttribute( 'width' ) )
		{
			var aMatchW  =  dialog.editObj[ 'image' ].getAttribute( 'width' ).match( regexSize );
			if ( aMatchW )
			{
				// % is allowed.
				if ( aMatchW[2] == '%' )
				{
					aMatchW[1] += '%';
					switchLockRatio( dialog, false );	// Unlock ratio
				}
				widthText = aMatchW[1];
			}
		}

		// Refresh LockRatio button
		var btnLockSizes = CKEDITOR.document.getById( 'btnLockSizes' );
		if ( dialog.imageLockRatio )
			btnLockSizes.removeClass( 'BtnUnlocked' );
		else
			btnLockSizes.addClass( 'BtnUnlocked' );

		// Read styles.
		var aMatchW  =  dialog.editObj[ 'image' ].$.style.width.match( regexSize );
		if ( aMatchW )
		{
			// % is allowed.
			if ( aMatchW[2] == '%' )
			{
				aMatchW[1] += '%';
				switchLockRatio( dialog, false );	// Unlock ratio
			}
			widthText = aMatchW[1];
			dialog.changedAttibutes[ 'image' ][ 'width' ] = widthText;
			dialog.dimensionsInStyle[ 'width' ] = true;
		}
		var aMatchH  =  dialog.editObj[ 'image' ].$.style.height.match( regexSize );
		if ( aMatchH )
		{
			// % is allowed.
			if ( aMatchH[2] == '%' )
			{
				aMatchH[1] += '%';
				switchLockRatio( dialog, false );	// Unlock ratio
			}
			heightText = aMatchH[1];
			dialog.changedAttibutes[ 'image' ][ 'height' ] = heightText;
			dialog.dimensionsInStyle[ 'height' ] = true;
		}

		var allow = dialog.allowOnChange;
		dialog.allowOnChange = false;
		dialog.setValueOf( 'info', 'txtHeight', heightText );
		dialog.setValueOf( 'info', 'txtWidth', widthText );
		dialog.allowOnChange = allow;
	}

	// Function called in onShow to load selected element.
	var loadElements = function( editor, selection, ranges, element )
	{
		this.editObj[ 'image' ] = false;
		this.editMode[ 'image' ] = false;		// Default:  Create a new Image
		this.saveSelection();

		this.setValueOf( "Link", "txtUrl", "" );
		this.setValueOf( "Link", "cmbTarget", "" );

		// Link is selected.
		if ( element.$.tagName.toLowerCase() == 'a' )
		{
			this.editObj[ 'link' ] = element;
			this.editMode[ 'link' ] = true;

			// Look for Image element.
			var linkChildren = element.getChildren();
			if ( linkChildren.count() == 1 ){		// 1 child.
				var childTagName = linkChildren.getItem( 0 ).$.tagName.toLowerCase();
				if ( childTagName == 'img' || childTagName == 'input' )
				{
					this.editObj[ 'image' ] = linkChildren.getItem( 0 );
					if ( this.editObj[ 'image' ].$.tagName.toLowerCase() == 'img' )
						this.editMode[ 'image' ] = 'img';
					else if ( this.editObj[ 'image' ].$.tagName.toLowerCase() == 'input' )
						this.editMode[ 'image' ] = 'input';
				}
			}

			if ( imageDialog )
			{
				// Fill out all fields.
				readAttribute.apply( this, [ 'Link', 'target', 'cmbTarget', element ] );
				if ( !readAttribute.apply( this, [ 'Link', '_cke_saved_href', 'txtUrl', element ] ) )
					readAttribute.apply( this, [ 'Link', 'href', 'txtUrl', element ] )
			}
		}

		if ( element.$.tagName.toLowerCase() == 'img' )
			this.editMode[ 'image' ] = 'img';
		else if ( element.$.tagName.toLowerCase() == 'input' )
			this.editMode[ 'image' ] = 'input';

		if ( this.editMode[ 'image' ] || this.editObj[ 'image' ] )
		{
			if ( !this.editObj[ 'image' ] )
				this.editObj[ 'image' ] = element;

			updateOriginal( this, true );
			readSize( this );

			var imgObject = this.editObj[ 'image' ];

			// Fill out all fields.
			if ( !readAttribute.apply( this, [ 'info', '_cke_saved_url', 'txtUrl', imgObject ] ) )
				readAttribute.apply( this, [ 'info', 'src', 'txtUrl', imgObject ] )
	
			readAttribute.apply( this, [ 'info', 'alt', 'txtAlt', imgObject ] );
			readAttribute.apply( this, [ 'info', 'border', 'txtBorder', imgObject  ] );
			readAttribute.apply( this, [ 'info', 'hspace', 'txtHSpace', imgObject ] );
			readAttribute.apply( this, [ 'info', 'vspace', 'txtVSpace', imgObject ] );
			readAttribute.apply( this, [ 'info', 'align', 'cmbAlign', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'id', 'linkId', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'dir', 'cmbLangDir', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'lang', 'txtLangCode', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'longdesc', 'txtGenLongDescr', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'class', 'txtGenClass', imgObject ] );
			readAttribute.apply( this, [ 'advanced', 'style', 'txtdlgGenStyle', imgObject ] );	
			readAttribute.apply( this, [ 'advanced', 'title', 'txtGenTitle', imgObject ] );
		}
		updatePreview( this );

		return false;
	};
	
	var readAttribute = function( page, attribute, input, object )
	{
		var attributeValue = object.getAttribute( attribute );
		if ( attributeValue == null )
			this.setValueOf( page, input, "" );
		else
			this.setValueOf( page, input, attributeValue );

		return attributeValue;
	}

	return {
		title : ( imageDialog ) ? editor.lang.image.title : editor.lang.image.titleButton,
		minWidth : 450,
		minHeight : 400,
		onOk : function()
		{
			this.allowOnChange = true;

			var useLink = false;
			var removeObj = false;

			// Edit existing Image.
			if ( this.editMode[ 'image' ] )
			{
				var imgTagName = this.editMode[ 'image' ];

				// Image dialog and Input element.
				if ( imageDialog && imgTagName == 'input' && confirm( editor.lang.image.button2Img ) )
				{
					// Replace INPUT-> IMG
					removeObj = this.editObj[ 'image' ];
					this.editObj[ 'image' ] = editor.document.createElement( 'img' );
					removeObj.insertBeforeMe( this.editObj[ 'image' ] );
					removeObj.remove( false );
					imgTagName = 'img';
				}
				// ImageButton dialog and Image element.
				else if ( !imageDialog && imgTagName == 'img' && confirm( editor.lang.image.img2Button ))
				{
					// Replace IMG -> INPUT
					removeObj = this.editObj[ 'image' ];
					this.editObj[ 'image' ] = editor.document.createElement( 'input' );
					this.editObj[ 'image' ].setAttribute ( 'type' ,'image' );
					removeObj.insertBeforeMe( this.editObj[ 'image' ] );
					removeObj.remove( false );
					imgTagName = 'input';
				}
			}
			else	// Create a new image.
			{
				// Image dialog -> create IMG element.
				if ( imageDialog )
					this.editObj[ 'image' ] = editor.document.createElement( 'img' );
				else
				{
					this.editObj[ 'image' ] = editor.document.createElement( 'input' );
					this.editObj[ 'image' ].setAttribute ( 'type' ,'image' );
				}
			}

			// Create a new link.
			if ( this.editMode[ 'link' ] == false )
				this.editObj[ 'link' ] = editor.document.createElement( 'a' );

			// Set image attributes.
			this.editObj[ 'image' ].setAttributes( this.changedAttibutes[ 'image' ] );

			// Set STYLE dimensions.
			if ( this.dimensionsInStyle[ 'width' ] == true )
				this.editObj[ 'image' ].setStyle( 'width',  this.changedAttibutes[ 'image' ][ 'width' ] + 'px' );
			if ( this.dimensionsInStyle[ 'height' ] == true )
				this.editObj[ 'image' ].setStyle( 'height',  this.changedAttibutes[ 'image' ][ 'height' ] + 'px' );

			// Set link attributes.
			this.changedAttibutes[ 'link' ][ 'href' ] =  'javascript:void(0)/*' + CKEDITOR.tools.getNextNumber() + '*/';
			this.editObj[ 'link' ].setAttributes( this.changedAttibutes[ 'link' ] );

			if ( this.editObj[ 'link' ].getAttribute( '_cke_saved_href' ) 
				&& this.editObj[ 'link' ].getAttribute( '_cke_saved_href' ) != '' )
				useLink = true;

			// Insert a new Image.
			if ( this.editMode[ 'image' ] == false )
			{
				// It doesn't work with IE.
				this.restoreSelection();
				this.clearSavedSelection();
				
				if ( useLink )
					//Insert a new Link.
					if ( this.editMode[ 'link' ] == false )
					{
						this.editObj[ 'link' ].append( this.editObj[ 'image' ], false );
						editor.insertElement( this.editObj[ 'link' ] );
					}
					else 	//Link already exists, image not.
						this.editObj[ 'link' ].append( this.editObj[ 'image' ], false );
				else
					editor.insertElement( this.editObj[ 'image' ] );
			}
			else		// Image already exists.	
			{
				//Add a new link element.
				if ( this.editMode[ 'link' ] == false && this.changedAttibutes[ 'link' ][ '_cke_saved_href' ] )
				{
					this.editObj[ 'image' ].insertBeforeMe( this.editObj[ 'link' ] );	
					this.editObj[ 'image' ].appendTo( this.editObj[ 'link' ] );	
				}
				//Remove Link, Image exists.
				else if ( this.editMode[ 'link' ] == true && !this.changedAttibutes[ 'link' ][ '_cke_saved_href' ] && editor.config.pluginConfig.image.removeLinkByEmptyURL == true )
					this.editObj[ 'link' ].remove( true );
			}
			this.allowOnChange = false;		// Don't load onChange before onShow.

			return true;
		},
		onShow : function()
		{
			//Don't call onShow before onShow.
			this.allowOnChange = false;

			this.editObj = new Array();
			this.editObj[ 'image' ] = false;
			this.editObj[ 'link' ] = false;
			this.editObj[ 'imageOriginal' ] = false;
			this.editObj[ 'imagePreview' ] = false;

			// Default: create a new element.
			this.editMode = new Array();
			this.editMode[ 'link' ] = false;
			this.editMode[ 'image' ] = false;

			this.changedAttibutes = new Array();
			this.changedAttibutes[ 'link' ] = new Array();
			this.changedAttibutes[ 'image' ] = new Array();

			this.imageLockRatio = true;
			this.dimensionsInStyle = new Array();
			this.dimensionsInStyle[ 'width' ] = false;
			this.dimensionsInStyle[ 'height' ] = false;
			this.forceResetSize = false;

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			// Copy of the image
			this.editObj[ 'imageOriginal' ] = editor.document.createElement( 'img' );
			this.editObj[ 'imageOriginal' ].setCustomData( 'isReady', 'false' );

			// Preview
			this.editObj[ 'imagePreview' ] = CKEDITOR.document.getById( 'previewImage' );
			this.editObj[ 'linkPreview' ] = CKEDITOR.document.getById( 'previewLink' );

			//Hide loader.
			CKEDITOR.document.getById( 'ImagePreviewLoader' ).setStyle( 'display', 'none' );
			
			// Check selection. Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				element = false;
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );
				rangeRoot = ranges[0].getCommonAncestor( true );
				
				elementImg = rangeRoot.getAscendant( 'img', true );
				elementA = rangeRoot.getAscendant( 'a', true );
				elementInput = rangeRoot.getAscendant( 'input', true );
				
				if ( elementImg && !elementImg.getAttribute( '_cke_protected_html' ) )
					element = elementImg;
				else
					if ( elementA && elementA.getAttribute( 'href' ) )
						element = elementA;
					else
						if ( elementInput && elementInput.getAttribute( 'type' ) 
						&& elementInput.getAttribute( 'type' ) == 'image' )
							element = elementInput;
				
				if ( element )
				{
					loadElements.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( element );
					this.saveSelection();
				}
			}
			updateOriginal( this, false );
			updatePreview( this );

			if ( !showPreview )		
			{
				// Show sample image
				var defaultImage = CKEDITOR.getUrl(
					'_source/' +	// TODO: Add @-Packager.RemoveLine to the final build process.
					'skins/' + editor.config.skin + '/images/dialog.noimage.gif' );
				this.editObj[ 'imagePreview' ].setAttribute( 'src', defaultImage );
			}

			this.allowOnChange = true;
			this.pushDefault();
			this.getContentElement( 'info', 'txtUrl' ).focus();
		},		
		onLoad : function()
		{
			if ( !imageDialog )
				this.hidePage( 'Link' );		//Hide Link tab.

			if ( editor.config.pluginConfig.image.uploadTab == false )
				this.hidePage( 'Upload' );		//Hide Upload tab.

			if ( editor.config.pluginConfig.image.showAdvancedTab == false )
				this.hidePage( 'advanced' );		//Hide Advanded tab.

			if ( editor.config.pluginConfig.image.browseServer == false )
				this.getContentElement( 'info', 'browse' ).getElement().hide();

			// Activate Reset button
			var resetButton= CKEDITOR.document.getById( 'btnResetSize' );
			if ( resetButton )
			{
				resetButton.on( 'click', function()
					{
						resetSize( this );
					}, this );
				resetButton.on( 'mouseover', function()
					{
						this.addClass( 'BtnOver' );
					}, resetButton );
				resetButton.on( 'mouseout', function()
					{
						this.removeClass( 'BtnOver' );
					}, resetButton );
			}

			// Activate (Un)LockRatio button
			var ratioButton= CKEDITOR.document.getById( 'btnLockSizes' );
			if ( ratioButton )
			{
				ratioButton.on( 'click', function()
					{
						var btnLockSizes = CKEDITOR.document.getById( 'btnLockSizes' );
						switchLockRatio( this );
					}, this );
				ratioButton.on( 'mouseover', function()
					{
						this.addClass( 'BtnOver' );
					}, ratioButton );
				ratioButton.on( 'mouseout', function()
					{
						this.removeClass( 'BtnOver' );
					}, ratioButton );
			}
		},	
		onHide : function()
		{
			if ( this.editObj[ 'imagePreview' ] )
				this.editObj[ 'imagePreview' ].setAttribute( 'src', '' );

			if ( this.editObj[ 'imageOriginal' ] )
			{
				this.editObj[ 'imageOriginal' ].removeListener( 'load', onImgLoad );
				this.editObj[ 'imageOriginal' ].removeListener( 'error', onImgLoadError );
				this.editObj[ 'imageOriginal' ].removeListener( 'abort', onImgLoadError );
				this.editObj[ 'imageOriginal' ].remove();
			}
			this.editObj[ 'imagePreview' ] = false;

			// Don't call onChange before onShow.
			this.allowOnChange = false;

			// Pop the default values from default value set that are pushed in onShow().
			this.popDefault();
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.image.infoTab,
				accessKey : 'I',
				elements :
				[
					{
						type : 'vbox',
						padding : 0,
						children :
						[
							{
								type : 'html',
								html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.image.url ) + '</span>'
							},
							{
								type : 'hbox',
								widths : [ '280px', '110px' ],
								align : 'right',
								children :
								[
									{
										id : 'txtUrl',
										type : 'text',
										label : '',
										validate : function()
										{
											addChange( 'src', this, 'image' );
											addChange( '_cke_saved_url', this, 'image' );
											return true;
										},
										onChange : function(){
											onUrlChange( this );
										}
									},
									{
										type : 'button',
										id : 'browse',
										align : 'center',
										label : editor.lang.common.browseServer,
										onClick : function()
										{
											this.getDialog().setValueOf( "info", "txtUrl", "http://www.fckeditor.net/images/demo_screenshot.gif" );
										}
									}
								]
							}
						]
					},
					{
						id : 'txtAlt',
						type : 'text',
						label : editor.lang.image.alt,
						accessKey : 'A',
						'default' : editor.config.pluginConfig.image.defaultValues.alt,
						onChange : function()
						{
							onChange( this, 'alt' );
						},
						validate: function()
						{
							addChange( 'alt', this, 'image' );
							return true;
						}
					},
					{
						type : 'hbox',
						widths : [ '140px', '240px' ],
						children :
						[
							{
								type : 'vbox',
								padding : 10,
								children :
								[
									{
										type : 'hbox',
										widths : [ '70%', '30%' ],
										children :
										[
											{
												type : 'vbox',
												padding : 1,
												children :
												[
													{
														type : 'text',
														id : 'txtWidth',
														labelLayout : 'horizontal',
														label : editor.lang.image.width,
														onChange : function()
														{
															onSizeChange( this );
														},
														validate: function()
														{										
															return addChange( 'width', this, 'image', function ()
																{
																	var aMatch  =  this.getValue().match( regexValidSize );
																	if ( aMatch )
																		return aMatch[0];
																	else
																	{
																		alert( editor.lang.common.validateNumberFailed );
																		return null;
																	}
																}
															);
														}
													},
													{
														type : 'text',
														id : 'txtHeight',
														labelLayout : 'horizontal',
														label : editor.lang.image.height,
														onChange : function()
														{
															onSizeChange( this );
														},
														validate: function()
														{
															return addChange( 'height', this, 'image', function ()
																{
																	var aMatch  =  this.getValue().match( regexValidSize );
																	if ( aMatch )
																		return aMatch[0];
																	else
																	{
																		alert( editor.lang.common.validateNumberFailed );
																		return null;
																	}
																}
															);
														}
													}
												]
											},
											{
												type : 'html',
												style : 'position:relative;top:-10px;height:20px',	
												html : '<div>'+
													'<div onclick="" title="' + editor.lang.image.lockRatio + 
													'" class="BtnLocked" id="btnLockSizes"></div>' +
													'<div onclick="" title="' + editor.lang.image.resetSize + 
													'" class="BtnReset" id="btnResetSize"></div>'+
													'</div>'
											}
										]
									},
									{
										type : 'vbox',
										padding : 1,
										children :
										[
											{
												type : 'text',
												id : 'txtBorder',
												labelLayout : 'horizontal',
												label : editor.lang.image.border,
												'default' : editor.config.pluginConfig.image.defaultValues.border,
												onChange : function()
												{
													onChange( this, 'border' );
												},
												validate: function()
												{
													var func = CKEDITOR.dialog.validate.integer( editor.lang.common.validateNumberFailed );
													var isValid = func.apply( this );
													if ( isValid )
														addChange( 'border', this, 'image' );
													return isValid;
												}
											},
											{
												type : 'text',
												id : 'txtHSpace',
												labelLayout : 'horizontal',
												label : editor.lang.image.hSpace,
												'default' : editor.config.pluginConfig.image.defaultValues.hSpace,
												onChange : function()
												{
													onChange( this, 'hspace' );
												},
												validate: function()
												{
													var func = CKEDITOR.dialog.validate.integer( editor.lang.common.validateNumberFailed );
													var isValid = func.apply( this );
													if ( isValid )
														addChange( 'hspace', this, 'image' );
													return isValid;
												}
											},
											{
												type : 'text',
												id : 'txtVSpace',
												labelLayout : 'horizontal',
												label : editor.lang.image.vSpace,
												'default' : editor.config.pluginConfig.image.defaultValues.vSpace,
												onChange : function()
												{
													onChange( this, 'vspace' );
												},
												validate: function()
												{
													var func = CKEDITOR.dialog.validate.integer( editor.lang.common.validateNumberFailed );
													var isValid = func.apply( this );
													if ( isValid )
														addChange( 'vspace', this, 'image' );
													return isValid;
												}
											},
											{
												id : 'cmbAlign',
												type : 'select',
												labelLayout : 'horizontal',
												widths : [ '35%','65%' ],
												style : 'width:100%',
												label : editor.lang.image.align,
												'default' : editor.config.pluginConfig.image.defaultValues.align,
												items :
												[
													[ editor.lang.common.notSet , ''],
													[ editor.lang.image.alignLeft , 'left'],
													[ editor.lang.image.alignAbsBottom , 'absBottom'],
													[ editor.lang.image.alignAbsMiddle , 'absMiddle'],
													[ editor.lang.image.alignBaseline , 'baseline'],
													[ editor.lang.image.alignBottom , 'bottom'],
													[ editor.lang.image.alignMiddle , 'middle'],
													[ editor.lang.image.alignRight , 'right'],
													[ editor.lang.image.alignTextTop , 'textTop'],
													[ editor.lang.image.alignTop , 'top']
												],
												onChange : function()
												{
													onChange( this, 'align' );
												},
												validate: function()
												{
													addChange( 'align', this, 'image' );
													return true;
												}
											}
										]
									}
								]
							},
							{
								type : 'vbox',
								height : '250px',
								children :
								[
									{
										type : 'html',
										style : 'width:95%;',
										html : previewAreaHtml
									}
								]
							}
						]
					}
				]
			},
			{
				id : 'Link',
				label : editor.lang.link.title,
				padding : 0,
				elements :
				[
					{
						id : 'txtUrl',
						type : 'text',
						label : editor.lang.image.url,
						style : 'width: 100%',
						'default' : editor.config.pluginConfig.image.defaultValues.link,
						validate: function()
						{
							addChange( '_cke_saved_href', this, 'link', function ( )
								{
									return decodeURI( this.getValue() );
								}
							);
							return true;
						}
					},
					{
						type : 'button',
						id : 'browse',
						style : 'float:right',
						label : editor.lang.common.browseServer,
						onClick : function()
						{
							this.getDialog().setValueOf( "Link", "txtUrl", "http://www.fckeditor.net/" );
							
						}
					},
					{
						id : 'cmbTarget',
						type : 'select',
						label : editor.lang.link.target,
						'default' : editor.config.pluginConfig.image.defaultValues.target,
						items :
						[
							[ editor.lang.link.targetNotSet , ''],
							[ editor.lang.link.targetNew , '_blank'],
							[ editor.lang.link.targetTop , '_top'],
							[ editor.lang.link.targetSelf , '_self'],
							[ editor.lang.link.targetParent , '_parent']
						],
						validate: function()
						{
							addChange( 'target', this, 'link' );
							return true;
						}
					}
				]
			},
			{
				id : 'Upload',
				label : editor.lang.image.upload,
				elements :
				[
					{
						type : 'file',
						id : 'upload',
						label : editor.lang.image.btnUpload,
						action : editor.config.pluginConfig.image.uploadAction,
						size : 38
					},
					{
						type : 'fileButton',
						id : 'uploadButton',
						label : editor.lang.image.btnUpload,
						'for' : [ 'Upload', 'upload' ]
					}
				]
			},
			{
				id : 'advanced',
				label : editor.lang.common.advancedTab,
				elements :
				[
					{
						type : 'hbox',
						widths : [ '50%', '25%', '25%' ],
						children :
						[
							{
								type : 'text',
								id : 'linkId',
								label : editor.lang.common.id,
								validate : function()
								{
									addChange( 'id', this, 'image' );
									return true;
								}
							},
							{
								id : 'cmbLangDir',
								type : 'select',
								style : 'width : 100%;',
								label : editor.lang.common.langDir,
								'default' : editor.config.pluginConfig.image.defaultValues.langDir,
								items :
								[
									[ editor.lang.common.notSet, '' ],
									[ editor.lang.common.langDirLtr, 'ltr' ],
									[ editor.lang.common.langDirRtl, 'rtl' ]
								],
								validate : function()
								{
									addChange( 'dir', this, 'image' );
									return true;
								}
							},
							{
								type : 'text',
								id : 'txtLangCode',
								label : editor.lang.common.langCode,
								'default' : editor.config.pluginConfig.image.defaultValues.langCode,
								validate : function()
								{
									addChange( 'lang', this, 'image' );
									return true;
								}
							}
						]
					},
					{
						type : 'text',
						id : 'txtGenLongDescr',
						label : editor.lang.common.longDescr,
						validate : function()
						{
							addChange( 'longdesc', this, 'image' );
							return true;
						}
					},
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								type : 'text',
								id : 'txtGenClass',
								label : editor.lang.common.cssClass,
								'default' : editor.config.pluginConfig.image.defaultValues.classes,
								validate : function()
								{
									addChange( 'class', this, 'image' );
									return true;
								}
							},
							{
								type : 'text',
								id : 'txtGenTitle',
								label : editor.lang.common.advisoryTitle,
								'default' : editor.config.pluginConfig.image.defaultValues.title,
								onChange : function()
								{
									onChange( this, 'title' );
								},
								validate : function()
								{
									addChange( 'title', this, 'image' );
									return true;
								}
							},
						]
					},
					{
						type : 'text',
						id : 'txtdlgGenStyle',
						label : editor.lang.common.cssStyle,
						'default' : editor.config.pluginConfig.image.defaultValues.style,
						validate : function()
						{				
							addChange( 'style', this, 'image' );
							return true;
						}
					}
				]
			}
		]
	};
};

CKEDITOR.dialog.add( 'image', function( editor ){
		return imageDialog( editor, 'image' )
	}
);

CKEDITOR.dialog.add( 'imagebutton', function( editor ){
		return imageDialog( editor, 'imagebutton' )
	}
);
