/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.dialog.add( 'smiley', function( editor )
{
	var smileySelector =
	{
		type : 'html',
		onClick : function( evt )
		{
			var target = evt.data.getTarget(),
				targetName = target.getName();
			if ( targetName != 'td' && targetName != 'img' )
				return;

			if ( targetName == 'td' )
				target = target.getChild(0).$;
			else
				target = target.$;

			this.getDialog().restoreSelection();
			editor.insertElement( CKEDITOR.dom.element.createFromHtml( '<img src="' + 
			CKEDITOR.tools.htmlEncode( target.src ) + '" title="' + 
			CKEDITOR.tools.htmlEncode( target.title ) + '" alt="' + 
			CKEDITOR.tools.htmlEncode( target.title ) + '" ' 
					+ '_cke_saved_src="' + CKEDITOR.tools.htmlEncode( target.src ) + '" />',
				editor.document ) );
			this.getDialog().hide();
		},
		style : 'width: 100%; height: 100%; border-collapse: separate;'
	},
		html = [ '<table cellspacing="2" cellpadding="2" border="0"><tbody>' ],
		cellWidth = parseInt( 100 / editor.config.pluginConfig.smiley.columns ) + '%',
		images = editor.config.pluginConfig.smiley.images,
		columns = editor.config.pluginConfig.smiley.columns,
		i;

	for ( i = 0 ; i < images.length ; i++ )
	{
		if ( i % editor.config.pluginConfig.smiley.columns == 0 )
			html.push( '<tr>' );

		html.push( '<td class="dark_background hand centered" style="vertical-align: middle;"><img border="0" title="'+
		editor.config.pluginConfig.smiley.descriptions[i] +'" src="' +
				CKEDITOR.tools.htmlEncode( editor.config.pluginConfig.smiley.path + images[i] ) + '" ' +
				// IE BUG: Below is a workaround to an IE image loading bug to ensure the image sizes are correct.
				( CKEDITOR.env.ie ? 'onload="this.setAttribute(\'width\', 2); this.removeAttribute(\'width\');" ' : '' ) +
				'class="hand" /></td>' );

		if ( i % columns == columns - 1 )
			html.push( '</tr>' );
	}

	if ( i < columns - 1 )
	{
		for ( ; i < columns - 1 ; i++ )
			html.push( '<td></td>' );
		html.push( '</tr>' );
	}

	html.push( '</tbody></table>' );
	smileySelector.html = html.join( '' );

	return {
		title : editor.lang.smiley.title,
		minWidth : editor.config.pluginConfig.smiley.windowWidth,
		minHeight : editor.config.pluginConfig.smiley.windowHeight,
		contents : [
			{
				id : 'tab1',
				label : '',
				title : '',
				expand : true,
				elements : [
						smileySelector
					]
			}
		],
		buttons : [ CKEDITOR.dialog.cancelButton ]
	};
} );

